/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squirrelframework.foundation.fsm.ImmutableState;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.StateMachineData;

public class StateMachineDataImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements StateMachineData<T, S, E, C>,
StateMachineData.Reader<T, S, E, C>,
StateMachineData.Writer<T, S, E, C> {
    private static final long serialVersionUID = 4102325896046410596L;
    private static final Logger logger = LoggerFactory.getLogger(StateMachineDataImpl.class);
    private S currentState;
    private S lastState;
    private S initialState;
    private final Map<S, S> lastActiveChildStateStore = Maps.newHashMap();
    private final ListMultimap<S, S> parallelStatesStore = ArrayListMultimap.create();
    private Class<? extends T> stateMachineType;
    private Class<S> stateType;
    private Class<E> eventType;
    private Class<C> contextType;
    private String identifier;
    private Object startContext;
    private final transient Map<S, ImmutableState<T, S, E, C>> states;
    private Map<S, StateMachineData.Reader<? extends StateMachine<?, S, E, C>, S, E, C>> linkStateDataStore;

    public StateMachineDataImpl(Map<S, ImmutableState<T, S, E, C>> map) {
        this.states = Collections.unmodifiableMap(map);
    }

    public StateMachineDataImpl() {
        this.states = null;
    }

    @Override
    public Map<S, ImmutableState<T, S, E, C>> originalStates() {
        if (this.states == null) {
            return Collections.emptyMap();
        }
        return this.states;
    }

    private void clear() {
        this.currentState = null;
        this.lastState = null;
        this.initialState = null;
        this.stateMachineType = null;
        this.stateType = null;
        this.eventType = null;
        this.contextType = null;
        this.identifier = null;
        this.startContext = null;
        if (this.lastActiveChildStateStore != null) {
            this.lastActiveChildStateStore.clear();
        }
        if (this.parallelStatesStore != null) {
            this.parallelStatesStore.clear();
        }
        if (this.linkStateDataStore != null) {
            this.linkStateDataStore.clear();
        }
    }

    @Override
    public void dump(StateMachineData.Reader<T, S, E, C> reader) {
        Object object;
        this.clear();
        this.write().typeOfStateMachine(reader.typeOfStateMachine());
        this.write().typeOfState(reader.typeOfState());
        this.write().typeOfEvent(reader.typeOfEvent());
        this.write().typeOfContext(reader.typeOfContext());
        this.write().identifier(reader.identifier());
        this.write().currentState(reader.currentState());
        this.write().lastState(reader.lastState());
        this.write().initialState(reader.initialState());
        this.write().startContext(reader.startContext());
        for (S s : reader.activeParentStates()) {
            object = reader.lastActiveChildStateOf(s);
            if (object == null) continue;
            this.write().lastActiveChildStateFor(s, object);
        }
        for (S s : reader.parallelStates()) {
            object = reader.subStatesOn(s);
            if (object == null || object.isEmpty()) continue;
            for (Object e : object) {
                this.parallelStatesStore.put(s, e);
            }
        }
    }

    private Map<S, StateMachineData.Reader<? extends StateMachine<?, S, E, C>, S, E, C>> getLinkedStateData() {
        if (this.linkStateDataStore == null) {
            this.linkStateDataStore = Maps.newHashMap();
        }
        return this.linkStateDataStore;
    }

    @Override
    public StateMachineData.Reader<T, S, E, C> read() {
        return this;
    }

    @Override
    public StateMachineData.Writer<T, S, E, C> write() {
        return this;
    }

    @Override
    public void currentState(S s) {
        this.currentState = s;
    }

    @Override
    public void lastState(S s) {
        this.lastState = s;
    }

    @Override
    public void initialState(S s) {
        this.initialState = s;
    }

    @Override
    public void startContext(C c) {
        if (c != null && c instanceof Serializable) {
            this.startContext = c;
        }
    }

    @Override
    public void lastActiveChildStateFor(S s, S s2) {
        this.lastActiveChildStateStore.put(s, s2);
    }

    @Override
    public void subStateFor(S s, S s2) {
        if (this.rawStateFrom(s) != null && this.rawStateFrom(s).isParallelState()) {
            this.parallelStatesStore.put(s, s2);
        } else {
            logger.warn("Cannot set sub states on none parallel state {}.", (Object)s);
        }
    }

    @Override
    public void removeSubState(S s, S s2) {
        if (this.rawStateFrom(s) != null && this.rawStateFrom(s).isParallelState()) {
            this.parallelStatesStore.remove(s, s2);
        } else {
            logger.warn("Cannot remove sub states on none parallel state {}.", (Object)s);
        }
    }

    @Override
    public void removeSubStatesOn(S s) {
        if (this.rawStateFrom(s).isParallelState()) {
            this.parallelStatesStore.removeAll(s);
        }
    }

    @Override
    public void identifier(String string) {
        this.identifier = string;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public S currentState() {
        return this.currentState;
    }

    @Override
    public S lastState() {
        return this.lastState;
    }

    @Override
    public S initialState() {
        return this.initialState;
    }

    @Override
    public S lastActiveChildStateOf(S s) {
        return this.lastActiveChildStateStore.get(s);
    }

    @Override
    public C startContext() {
        return (C)this.startContext;
    }

    @Override
    public Collection<S> activeParentStates() {
        return Collections.unmodifiableCollection(this.lastActiveChildStateStore.keySet());
    }

    @Override
    public List<S> subStatesOn(S s) {
        Collection collection = this.parallelStatesStore.get((Object)s);
        return collection != null ? Collections.unmodifiableList(collection) : Collections.emptyList();
    }

    @Override
    public ImmutableState<T, S, E, C> currentRawState() {
        return this.currentState != null ? this.rawStateFrom(this.currentState) : null;
    }

    @Override
    public ImmutableState<T, S, E, C> lastRawState() {
        return this.rawStateFrom(this.lastState);
    }

    @Override
    public ImmutableState<T, S, E, C> rawStateFrom(S s) {
        if (s == null) {
            return null;
        }
        ImmutableState<T, S, E, C> immutableState = this.originalStates().get(s);
        return immutableState != null ? immutableState.getThis() : null;
    }

    @Override
    public ImmutableState<T, S, E, C> initialRawState() {
        return this.rawStateFrom(this.initialState());
    }

    @Override
    public Class<? extends T> typeOfStateMachine() {
        return this.stateMachineType;
    }

    @Override
    public Class<S> typeOfState() {
        return this.stateType;
    }

    @Override
    public Class<E> typeOfEvent() {
        return this.eventType;
    }

    @Override
    public Class<C> typeOfContext() {
        return this.contextType;
    }

    @Override
    public void typeOfStateMachine(Class<? extends T> clazz) {
        Preconditions.checkState(this.stateMachineType == null);
        this.stateMachineType = clazz;
    }

    @Override
    public void typeOfState(Class<S> clazz) {
        Preconditions.checkState(this.stateType == null);
        this.stateType = clazz;
    }

    @Override
    public void typeOfEvent(Class<E> clazz) {
        Preconditions.checkState(this.eventType == null);
        this.eventType = clazz;
    }

    @Override
    public void typeOfContext(Class<C> clazz) {
        Preconditions.checkState(this.contextType == null);
        this.contextType = clazz;
    }

    @Override
    public Collection<ImmutableState<T, S, E, C>> rawStates() {
        return Collections.unmodifiableCollection(this.originalStates().values());
    }

    @Override
    public Collection<S> states() {
        return Collections.unmodifiableCollection(this.originalStates().keySet());
    }

    @Override
    public Collection<S> parallelStates() {
        return Collections.unmodifiableCollection(this.parallelStatesStore.keySet());
    }

    @Override
    public Collection<S> linkedStates() {
        if (this.linkStateDataStore == null || this.linkStateDataStore.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(this.linkStateDataStore.keySet());
    }

    @Override
    public StateMachineData.Reader<? extends StateMachine<?, S, E, C>, S, E, C> linkedStateDataOf(S s) {
        if (this.linkStateDataStore != null && !this.linkStateDataStore.isEmpty()) {
            return this.linkStateDataStore.get(s);
        }
        return null;
    }

    @Override
    public void linkedStateDataOn(S s, StateMachineData.Reader<? extends StateMachine<?, S, E, C>, S, E, C> reader) {
        this.getLinkedStateData().put(s, reader);
    }
}

