/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squirrelframework.foundation.component.Observable;
import org.squirrelframework.foundation.component.SquirrelProvider;
import org.squirrelframework.foundation.component.impl.AbstractSubject;
import org.squirrelframework.foundation.event.AsyncEventListener;
import org.squirrelframework.foundation.event.ListenerMethod;
import org.squirrelframework.foundation.exception.ErrorCodes;
import org.squirrelframework.foundation.exception.TransitionException;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.ActionExecutionService;
import org.squirrelframework.foundation.fsm.Converter;
import org.squirrelframework.foundation.fsm.ConverterProvider;
import org.squirrelframework.foundation.fsm.ImmutableLinkedState;
import org.squirrelframework.foundation.fsm.ImmutableState;
import org.squirrelframework.foundation.fsm.MvelScriptManager;
import org.squirrelframework.foundation.fsm.SCXMLVisitor;
import org.squirrelframework.foundation.fsm.StateContext;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.StateMachineConfiguration;
import org.squirrelframework.foundation.fsm.StateMachineContext;
import org.squirrelframework.foundation.fsm.StateMachineData;
import org.squirrelframework.foundation.fsm.StateMachineLogger;
import org.squirrelframework.foundation.fsm.StateMachineStatus;
import org.squirrelframework.foundation.fsm.TransitionResult;
import org.squirrelframework.foundation.fsm.Visitor;
import org.squirrelframework.foundation.fsm.annotation.AsyncExecute;
import org.squirrelframework.foundation.fsm.annotation.ListenerOrder;
import org.squirrelframework.foundation.fsm.annotation.OnActionExecException;
import org.squirrelframework.foundation.fsm.annotation.OnAfterActionExecuted;
import org.squirrelframework.foundation.fsm.annotation.OnBeforeActionExecuted;
import org.squirrelframework.foundation.fsm.annotation.OnStateMachineStart;
import org.squirrelframework.foundation.fsm.annotation.OnStateMachineTerminate;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionBegin;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionComplete;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionDecline;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionEnd;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionException;
import org.squirrelframework.foundation.fsm.impl.FSM;
import org.squirrelframework.foundation.util.Pair;
import org.squirrelframework.foundation.util.ReflectUtils;
import org.squirrelframework.foundation.util.TypeReference;

public abstract class AbstractStateMachine<T extends StateMachine<T, S, E, C>, S, E, C>
extends AbstractSubject
implements StateMachine<T, S, E, C> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStateMachine.class);
    private final ActionExecutionService<T, S, E, C> executor = (ActionExecutionService)SquirrelProvider.getInstance().newInstance(new TypeReference<ActionExecutionService<T, S, E, C>>(){});
    private StateMachineData<T, S, E, C> data;
    private volatile StateMachineStatus status = StateMachineStatus.INITIALIZED;
    private LinkedBlockingDeque<Pair<E, C>> queuedEvents = new LinkedBlockingDeque();
    private LinkedBlockingQueue<Pair<E, C>> queuedTestEvents = new LinkedBlockingQueue();
    private volatile boolean isProcessingTestEvent = false;
    private E startEvent;
    private E finishEvent;
    private E terminateEvent;
    protected final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected final Lock writeLock = this.rwLock.writeLock();
    protected final Lock readLock = this.rwLock.readLock();
    private MvelScriptManager scriptManager;
    private boolean isAutoStartEnabled = true;
    private boolean isAutoTerminateEnabled = true;
    private boolean isDelegatorModeEnabled = false;
    private long transitionTimeout = -1L;
    private boolean isDataIsolateEnabled = false;
    private boolean isDebugModeEnabled = false;
    private boolean isRemoteMonitorEnabled = false;
    private Class<?>[] extraParamTypes;
    private TransitionException lastException = null;
    private static final Class<?>[][] stateMachineListenerMapping = new Class[][]{{OnTransitionBegin.class, StateMachine.TransitionBeginListener.class, StateMachine.TransitionBeginEvent.class}, {OnTransitionComplete.class, StateMachine.TransitionCompleteListener.class, StateMachine.TransitionCompleteEvent.class}, {OnTransitionDecline.class, StateMachine.TransitionDeclinedListener.class, StateMachine.TransitionDeclinedEvent.class}, {OnTransitionEnd.class, StateMachine.TransitionEndListener.class, StateMachine.TransitionEndEvent.class}, {OnTransitionException.class, StateMachine.TransitionExceptionListener.class, StateMachine.TransitionExceptionEvent.class}, {OnStateMachineStart.class, StateMachine.StartListener.class, StateMachine.StartEvent.class}, {OnStateMachineTerminate.class, StateMachine.TerminateListener.class, StateMachine.TerminateEvent.class}};
    private static final Class<?>[][] actionExecutorListenerMapping = new Class[][]{{OnBeforeActionExecuted.class, ActionExecutionService.BeforeExecActionListener.class, ActionExecutionService.BeforeExecActionEvent.class}, {OnAfterActionExecuted.class, ActionExecutionService.AfterExecActionListener.class, ActionExecutionService.AfterExecActionEvent.class}, {OnActionExecException.class, ActionExecutionService.ExecActionExceptionListener.class, ActionExecutionService.ExecActionExceptionEvent.class}};

    void prePostConstruct(S s, Map<S, ? extends ImmutableState<T, S, E, C>> map, StateMachineConfiguration stateMachineConfiguration, Runnable runnable) {
        this.data = FSM.newStateMachineData(map);
        this.data.write().initialState(s);
        this.data.write().currentState(null);
        this.data.write().identifier(stateMachineConfiguration.getIdProvider().get());
        this.isAutoStartEnabled = stateMachineConfiguration.isAutoStartEnabled();
        this.isAutoTerminateEnabled = stateMachineConfiguration.isAutoTerminateEnabled();
        this.isDataIsolateEnabled = stateMachineConfiguration.isDataIsolateEnabled();
        this.isDebugModeEnabled = stateMachineConfiguration.isDebugModeEnabled();
        this.isDelegatorModeEnabled = stateMachineConfiguration.isDelegatorModeEnabled();
        this.isRemoteMonitorEnabled = stateMachineConfiguration.isRemoteMonitorEnabled();
        runnable.run();
        this.prepare();
    }

    @Override
    public boolean isRemoteMonitorEnabled() {
        return this.isRemoteMonitorEnabled;
    }

    protected void prepare() {
        if (this.isDebugModeEnabled) {
            final StateMachineLogger stateMachineLogger = new StateMachineLogger(this);
            this.addStartListener(new StateMachine.StartListener<T, S, E, C>(){

                @Override
                public void started(StateMachine.StartEvent<T, S, E, C> startEvent) {
                    stateMachineLogger.startLogging();
                }
            });
            this.addTerminateListener(new StateMachine.TerminateListener<T, S, E, C>(){

                @Override
                public void terminated(StateMachine.TerminateEvent<T, S, E, C> terminateEvent) {
                    stateMachineLogger.stopLogging();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processEvent(E e, C c, StateMachineData<T, S, E, C> stateMachineData, ActionExecutionService<T, S, E, C> actionExecutionService, boolean bl) {
        StateMachineData<T, S, E, C> stateMachineData2 = stateMachineData;
        ImmutableState<T, S, E, C> immutableState = stateMachineData2.read().currentRawState();
        S s = immutableState.getStateId();
        Object s2 = null;
        try {
            this.beforeTransitionBegin(s, e, c);
            this.fireEvent(new TransitionBeginEventImpl<T, S, E, C>(s, e, c, this.getThis()));
            if (bl) {
                stateMachineData2 = FSM.newStateMachineData(stateMachineData.read().originalStates());
                stateMachineData2.dump(stateMachineData.read());
            }
            TransitionResult<T, S, E, C> transitionResult = FSM.newResult(false, immutableState, null);
            StateContext<T, S, E, C> stateContext = FSM.newStateContext(this, stateMachineData2, immutableState, e, c, transitionResult, actionExecutionService);
            immutableState.internalFire(stateContext);
            s2 = transitionResult.getTargetState().getStateId();
            if (transitionResult.isAccepted()) {
                actionExecutionService.execute();
                stateMachineData2.write().lastState(s);
                stateMachineData2.write().currentState(s2);
                if (bl) {
                    stateMachineData.dump(stateMachineData2.read());
                }
                this.fireEvent(new TransitionCompleteEventImpl<T, Object, E, C>(s, s2, e, c, this.getThis()));
                this.afterTransitionCompleted(s, this.getCurrentState(), e, c);
                boolean bl2 = true;
                return bl2;
            }
            this.fireEvent(new TransitionDeclinedEventImpl<T, S, E, C>(s, e, c, this.getThis()));
            this.afterTransitionDeclined(s, e, c);
        }
        catch (Exception exception) {
            this.setStatus(StateMachineStatus.ERROR);
            this.lastException = exception instanceof TransitionException ? (TransitionException)exception : new TransitionException(exception, ErrorCodes.FSM_TRANSITION_ERROR, new Object[]{s, s2, e, c, "UNKNOWN", exception.getMessage()});
            this.fireEvent(new TransitionExceptionEventImpl<T, S, E, C>(this.lastException, s, stateMachineData2.read().currentState(), e, c, this.getThis()));
            this.afterTransitionCausedException(s, s2, e, c);
        }
        finally {
            actionExecutionService.reset();
            this.fireEvent(new TransitionEndEventImpl<T, Object, E, C>(s, s2, e, c, this.getThis()));
            this.afterTransitionEnd(s, this.getCurrentState(), e, c);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvents() {
        if (this.isIdle()) {
            this.writeLock.lock();
            this.setStatus(StateMachineStatus.BUSY);
            try {
                Pair<E, C> pair;
                C c = null;
                while ((pair = this.queuedEvents.poll()) != null) {
                    if (Thread.interrupted()) {
                        this.queuedEvents.clear();
                        break;
                    }
                    E e = pair.first();
                    c = pair.second();
                    this.processEvent(e, c, this.data, this.executor, this.isDataIsolateEnabled);
                }
                ImmutableState<T, S, E, C> immutableState = this.data.read().currentRawState();
                if (this.isAutoTerminateEnabled && immutableState.isRootState() && immutableState.isFinalState()) {
                    this.terminate(c);
                }
            }
            finally {
                if (this.getStatus() == StateMachineStatus.BUSY) {
                    this.setStatus(StateMachineStatus.IDLE);
                }
                this.writeLock.unlock();
            }
        }
    }

    private void internalFire(E e, C c, boolean bl) {
        if (this.getStatus() == StateMachineStatus.INITIALIZED) {
            if (this.isAutoStartEnabled) {
                this.start(c);
            } else {
                throw new IllegalStateException("The state machine is not running.");
            }
        }
        if (this.getStatus() == StateMachineStatus.TERMINATED) {
            throw new IllegalStateException("The state machine is already terminated.");
        }
        if (this.getStatus() == StateMachineStatus.ERROR) {
            throw new IllegalStateException("The state machine is corruptted.");
        }
        if (bl) {
            this.queuedEvents.addFirst(new Pair<E, C>(e, c));
        } else {
            this.queuedEvents.addLast(new Pair<E, C>(e, c));
        }
        this.processEvents();
    }

    private boolean isEntryPoint() {
        return StateMachineContext.currentInstance() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire(E e, C c, boolean bl) {
        boolean bl2 = this.isEntryPoint();
        if (bl2) {
            StateMachineContext.set(this.getThis());
        } else if (this.isDelegatorModeEnabled && StateMachineContext.currentInstance() != this) {
            StateMachine stateMachine = (StateMachine)StateMachineContext.currentInstance();
            stateMachine.fire(e, c);
            return;
        }
        try {
            if (StateMachineContext.isTestEvent()) {
                this.internalTest(e, c);
            } else {
                this.internalFire(e, c, bl);
            }
        }
        finally {
            if (bl2) {
                StateMachineContext.set(null);
            }
        }
    }

    @Override
    public void fire(E e, C c) {
        this.fire(e, c, false);
    }

    public void untypedFire(Object object, Object object2) {
        this.fire(this.typeOfEvent().cast(object), this.typeOfContext().cast(object2));
    }

    @Override
    public void fireImmediate(E e, C c) {
        this.fire(e, c, true);
    }

    @Override
    public void fire(E e) {
        this.fire(e, null);
    }

    @Override
    public void fireImmediate(E e) {
        this.fireImmediate(e, null);
    }

    protected void cleanQueuedEvents() {
        this.queuedEvents.clear();
    }

    private ActionExecutionService<T, S, E, C> getDummyExecutor() {
        ActionExecutionService actionExecutionService = (ActionExecutionService)SquirrelProvider.getInstance().newInstance(new TypeReference<ActionExecutionService<T, S, E, C>>(){});
        actionExecutionService.setDummyExecution(true);
        return actionExecutionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S internalTest(E e, C c) {
        Preconditions.checkState(this.status != StateMachineStatus.ERROR && this.status != StateMachineStatus.TERMINATED, "Cannot test state machine under " + (Object)((Object)this.status) + " status.");
        S s = null;
        this.queuedTestEvents.add(new Pair<E, C>(e, c));
        if (!this.isProcessingTestEvent) {
            this.isProcessingTestEvent = true;
            StateMachineData stateMachineData = (StateMachineData)((Object)this.dumpSavedData());
            ActionExecutionService<T, S, E, C> actionExecutionService = this.getDummyExecutor();
            if (this.getStatus() == StateMachineStatus.INITIALIZED) {
                if (this.isAutoStartEnabled) {
                    this.internalStart(c, stateMachineData, actionExecutionService);
                } else {
                    throw new IllegalStateException("The state machine is not running.");
                }
            }
            try {
                Pair<E, C> pair = null;
                while ((pair = this.queuedTestEvents.poll()) != null) {
                    E e2 = pair.first();
                    C c2 = pair.second();
                    this.processEvent(e2, c2, stateMachineData, actionExecutionService, false);
                }
                s = this.resolveState(stateMachineData.read().currentState(), stateMachineData);
            }
            finally {
                this.isProcessingTestEvent = false;
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S test(E e, C c) {
        boolean bl = this.isEntryPoint();
        if (bl) {
            StateMachineContext.set(this.getThis(), true);
        }
        try {
            S s = this.internalTest(e, c);
            return s;
        }
        finally {
            if (bl) {
                StateMachineContext.set(null);
            }
        }
    }

    @Override
    public S test(E e) {
        return this.test(e, null);
    }

    @Override
    public boolean canAccept(E e) {
        ImmutableState<T, S, E, C> immutableState = this.getCurrentRawState();
        if (immutableState == null) {
            if (this.isAutoStartEnabled) {
                immutableState = this.getInitialRawState();
            } else {
                return false;
            }
        }
        return immutableState.getAcceptableEvents().contains(e);
    }

    protected boolean isIdle() {
        return this.getStatus() != StateMachineStatus.BUSY;
    }

    protected void afterTransitionCausedException(S s, S s2, E e, C c) {
        if (this.getLastException().getTargetException() != null) {
            this.getLastException().getTargetException().printStackTrace();
        }
        throw this.getLastException();
    }

    protected void beforeTransitionBegin(S s, E e, C c) {
    }

    protected void afterTransitionCompleted(S s, S s2, E e, C c) {
    }

    protected void afterTransitionEnd(S s, S s2, E e, C c) {
    }

    protected void afterTransitionDeclined(S s, E e, C c) {
    }

    protected void beforeActionInvoked(S s, S s2, E e, C c) {
    }

    protected void afterActionInvoked(S s, S s2, E e, C c) {
    }

    private ImmutableState<T, S, E, C> resolveRawState(ImmutableState<T, S, E, C> immutableState) {
        ImmutableState<Object, S, E, C> immutableState2 = immutableState;
        if (immutableState2 instanceof ImmutableLinkedState) {
            StateMachine stateMachine = ((ImmutableLinkedState)immutableState).getLinkedStateMachine(this.getThis());
            immutableState2 = stateMachine.getCurrentRawState();
        }
        return immutableState2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableState<T, S, E, C> getCurrentRawState() {
        this.readLock.lock();
        try {
            ImmutableState<T, S, E, C> immutableState = this.data.read().currentRawState();
            ImmutableState<T, S, E, C> immutableState2 = this.resolveRawState(immutableState);
            return immutableState2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableState<T, S, E, C> getLastRawState() {
        this.readLock.lock();
        try {
            ImmutableState<T, S, E, C> immutableState = this.data.read().lastRawState();
            ImmutableState<T, S, E, C> immutableState2 = this.resolveRawState(immutableState);
            return immutableState2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ImmutableState<T, S, E, C> getInitialRawState() {
        return this.getRawStateFrom(this.getInitialState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableState<T, S, E, C> getRawStateFrom(S s) {
        this.readLock.lock();
        try {
            ImmutableState<T, S, E, C> immutableState = this.data.read().rawStateFrom(s);
            return immutableState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ImmutableState<T, S, E, C>> getAllRawStates() {
        this.readLock.lock();
        try {
            Collection<ImmutableState<T, S, E, C>> collection = this.data.read().rawStates();
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<S> getAllStates() {
        this.readLock.lock();
        try {
            Collection<S> collection = this.data.read().states();
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private S resolveState(S s, StateMachineData<T, S, E, C> stateMachineData) {
        S s2 = s;
        ImmutableState<T, S, E, C> immutableState = stateMachineData.read().rawStateFrom(s2);
        if (immutableState instanceof ImmutableLinkedState) {
            ImmutableLinkedState immutableLinkedState = (ImmutableLinkedState)immutableState;
            s2 = immutableLinkedState.getLinkedStateMachine(this.getThis()).getCurrentState();
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S getCurrentState() {
        this.readLock.lock();
        try {
            S s = this.resolveState(this.data.read().currentState(), this.data);
            return s;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S getLastState() {
        this.readLock.lock();
        try {
            S s = this.resolveState(this.data.read().lastState(), this.data);
            return s;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S getInitialState() {
        this.readLock.lock();
        try {
            S s = this.data.read().initialState();
            return s;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void entryAll(ImmutableState<T, S, E, C> immutableState, StateContext<T, S, E, C> stateContext) {
        ImmutableState immutableState2;
        Stack<ImmutableState> stack = new Stack<ImmutableState>();
        for (immutableState2 = immutableState; immutableState2 != null; immutableState2 = immutableState2.getParentState()) {
            stack.push(immutableState2);
        }
        while (stack.size() > 0) {
            immutableState2 = (ImmutableState)stack.pop();
            immutableState2.entry(stateContext);
        }
    }

    @Override
    public synchronized void start(C c) {
        if (this.isStarted()) {
            return;
        }
        this.setStatus(StateMachineStatus.BUSY);
        this.internalStart(c, this.data, this.executor);
        this.setStatus(StateMachineStatus.IDLE);
        this.processEvents();
    }

    private void internalStart(C c, StateMachineData<T, S, E, C> stateMachineData, ActionExecutionService<T, S, E, C> actionExecutionService) {
        ImmutableState<T, S, E, C> immutableState = stateMachineData.read().initialRawState();
        StateContext<T, S, E, C> stateContext = FSM.newStateContext(this, stateMachineData, immutableState, this.getStartEvent(), c, null, actionExecutionService);
        this.entryAll(immutableState, stateContext);
        ImmutableState<T, S, E, C> immutableState2 = immutableState.enterByHistory(stateContext);
        actionExecutionService.execute();
        stateMachineData.write().currentState(immutableState2.getStateId());
        stateMachineData.write().startContext(c);
        this.fireEvent(new StartEventImpl(this.getThis()));
    }

    @Override
    public void start() {
        this.start(null);
    }

    @Override
    public boolean isStarted() {
        return this.getStatus() == StateMachineStatus.IDLE || this.getStatus() == StateMachineStatus.BUSY;
    }

    @Override
    public boolean isTerminated() {
        return this.getStatus() == StateMachineStatus.TERMINATED;
    }

    @Override
    public boolean isError() {
        return this.getStatus() == StateMachineStatus.ERROR;
    }

    @Override
    public StateMachineStatus getStatus() {
        return this.status;
    }

    protected void setStatus(StateMachineStatus stateMachineStatus) {
        this.status = stateMachineStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S getLastActiveChildStateOf(S s) {
        this.readLock.lock();
        try {
            S s2 = this.data.read().lastActiveChildStateOf(s);
            return s2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<S> getSubStatesOn(S s) {
        this.readLock.lock();
        try {
            List<S> list = this.data.read().subStatesOn(s);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public synchronized void terminate(C c) {
        if (this.isTerminated()) {
            return;
        }
        StateContext<T, S, E, C> stateContext = FSM.newStateContext(this, this.data, this.data.read().currentRawState(), this.getTerminateEvent(), c, null, this.executor);
        this.exitAll(this.data.read().currentRawState(), stateContext);
        this.executor.execute();
        this.setStatus(StateMachineStatus.TERMINATED);
        this.fireEvent(new TerminateEventImpl(this.getThis()));
    }

    @Override
    public void terminate() {
        this.terminate(null);
    }

    private void exitAll(ImmutableState<T, S, E, C> immutableState, StateContext<T, S, E, C> stateContext) {
        for (ImmutableState<T, S, E, C> immutableState2 = immutableState; immutableState2 != null; immutableState2 = immutableState2.getParentState()) {
            immutableState2.exit(stateContext);
        }
    }

    @Override
    public T getThis() {
        return (T)this;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitOnEntry(this);
        for (ImmutableState<T, S, E, C> immutableState : this.getAllRawStates()) {
            if (immutableState.getParentState() != null) continue;
            immutableState.accept(visitor);
        }
        visitor.visitOnExit(this);
    }

    void setTypeOfStateMachine(Class<? extends T> clazz) {
        this.data.write().typeOfStateMachine(clazz);
    }

    void setTypeOfState(Class<S> clazz) {
        this.data.write().typeOfState(clazz);
    }

    void setTypeOfEvent(Class<E> clazz) {
        this.data.write().typeOfEvent(clazz);
    }

    void setTypeOfContext(Class<C> clazz) {
        this.data.write().typeOfContext(clazz);
    }

    void setScriptManager(MvelScriptManager mvelScriptManager) {
        Preconditions.checkState(this.scriptManager == null);
        this.scriptManager = mvelScriptManager;
    }

    void setStartEvent(E e) {
        Preconditions.checkState(this.startEvent == null);
        this.startEvent = e;
    }

    E getStartEvent() {
        return this.startEvent;
    }

    void setTerminateEvent(E e) {
        Preconditions.checkState(this.terminateEvent == null);
        this.terminateEvent = e;
    }

    E getTerminateEvent() {
        return this.terminateEvent;
    }

    void setFinishEvent(E e) {
        Preconditions.checkState(this.finishEvent == null);
        this.finishEvent = e;
    }

    E getFinishEvent() {
        return this.finishEvent;
    }

    void setExtraParamTypes(Class<?>[] classArray) {
        Preconditions.checkState(this.extraParamTypes == null);
        this.extraParamTypes = classArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateMachineData.Reader<T, S, E, C> dumpSavedData() {
        this.readLock.lock();
        try {
            StateMachineData<T, S, E, C> stateMachineData = FSM.newStateMachineData(this.data.read().originalStates());
            stateMachineData.dump(this.data.read());
            this.saveLinkedStateData(this.data.read(), stateMachineData.write());
            StateMachineData.Reader<T, S, E, C> reader = stateMachineData.read();
            return reader;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void saveLinkedStateData(StateMachineData.Reader<T, S, E, C> reader, StateMachineData.Writer<T, S, E, C> writer) {
        this.dumpLinkedStateFor(reader.currentRawState(), writer);
    }

    private void dumpLinkedStateFor(ImmutableState<T, S, E, C> immutableState, StateMachineData.Writer<T, S, E, C> writer) {
        if (immutableState != null && immutableState instanceof ImmutableLinkedState) {
            ImmutableLinkedState immutableLinkedState = (ImmutableLinkedState)immutableState;
            StateMachineData.Reader reader = immutableLinkedState.getLinkedStateMachine(this.getThis()).dumpSavedData();
            writer.linkedStateDataOn(immutableState.getStateId(), reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadSavedData(StateMachineData.Reader<T, S, E, C> reader) {
        Preconditions.checkNotNull(reader, "Saved data cannot be null");
        if (this.writeLock.tryLock()) {
            try {
                this.data.dump(reader);
                for (S s : reader.linkedStates()) {
                    StateMachineData.Reader<StateMachine<?, S, E, C>, S, E, C> reader2 = reader.linkedStateDataOf(s);
                    ImmutableState<T, S, E, C> immutableState = this.data.read().rawStateFrom(s);
                    if (reader2 == null || !(immutableState instanceof ImmutableLinkedState)) continue;
                    ImmutableLinkedState immutableLinkedState = (ImmutableLinkedState)immutableState;
                    immutableLinkedState.getLinkedStateMachine(this.getThis()).loadSavedData(reader2);
                }
                this.setStatus(StateMachineStatus.IDLE);
                boolean bl = true;
                return bl;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return false;
    }

    @Override
    public boolean isContextSensitive() {
        return true;
    }

    @Override
    public Class<C> typeOfContext() {
        return this.data.read().typeOfContext();
    }

    @Override
    public Class<E> typeOfEvent() {
        return this.data.read().typeOfEvent();
    }

    @Override
    public Class<S> typeOfState() {
        return this.data.read().typeOfState();
    }

    @Override
    public TransitionException getLastException() {
        return this.lastException;
    }

    protected void setLastException(TransitionException transitionException) {
        this.lastException = transitionException;
    }

    private Object newListenerMethodProxy(final Object object, final Method method, Class<?> clazz, final String string) {
        Class[] classArray;
        final String string2 = ReflectUtils.getStatic(ReflectUtils.getField(clazz, "METHOD_NAME")).toString();
        AsyncExecute asyncExecute = ReflectUtils.getAnnotation(object.getClass(), AsyncExecute.class);
        if (asyncExecute == null) {
            asyncExecute = method.getAnnotation(AsyncExecute.class);
        }
        final boolean bl = asyncExecute != null;
        final long l = asyncExecute != null ? asyncExecute.timeout() : -1L;
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object object2, Method method2, Object[] objectArray) throws Throwable {
                if (method2.getName().equals("getListenTarget")) {
                    return object;
                }
                if (method2.getName().equals(string2)) {
                    if (objectArray[0] instanceof StateMachine.TransitionEvent) {
                        StateMachine.TransitionEvent transitionEvent = (StateMachine.TransitionEvent)objectArray[0];
                        return AbstractStateMachine.this.invokeTransitionListenerMethod(object, method, string, transitionEvent);
                    }
                    if (objectArray[0] instanceof ActionExecutionService.ActionEvent) {
                        ActionExecutionService.ActionEvent actionEvent = (ActionExecutionService.ActionEvent)objectArray[0];
                        return AbstractStateMachine.this.invokeActionListenerMethod(object, method, string, actionEvent);
                    }
                    if (objectArray[0] instanceof StateMachine.StartEvent || objectArray[0] instanceof StateMachine.TerminateEvent) {
                        StateMachine.StateMachineEvent stateMachineEvent = (StateMachine.StateMachineEvent)objectArray[0];
                        return AbstractStateMachine.this.invokeStateMachineListenerMethod(object, method, string, stateMachineEvent);
                    }
                    throw new IllegalArgumentException("Unable to recognize argument type " + objectArray[0].getClass().getName() + ".");
                }
                if (method2.getName().equals("equals")) {
                    return super.equals(objectArray[0]);
                }
                if (method2.getName().equals("hashCode")) {
                    return super.hashCode();
                }
                if (method2.getName().equals("toString")) {
                    return super.toString();
                }
                if (bl && method2.getName().equals("timeout")) {
                    return l;
                }
                throw new UnsupportedOperationException("Cannot invoke method " + method2.getName() + ".");
            }
        };
        if (bl) {
            Class[] classArray2 = new Class[3];
            classArray2[0] = clazz;
            classArray2[1] = DeclarativeListener.class;
            classArray = classArray2;
            classArray2[2] = AsyncEventListener.class;
        } else {
            Class[] classArray3 = new Class[2];
            classArray3[0] = clazz;
            classArray = classArray3;
            classArray3[1] = DeclarativeListener.class;
        }
        Class[] classArray4 = classArray;
        Object object2 = Proxy.newProxyInstance(StateMachine.class.getClassLoader(), classArray4, invocationHandler);
        return object2;
    }

    private Object invokeStateMachineListenerMethod(Object object, Method method, String string, StateMachine.StateMachineEvent<T, S, E, C> stateMachineEvent) {
        Class<?>[] classArray = method.getParameterTypes();
        HashMap<String, T> hashMap = Maps.newHashMap();
        hashMap.put("stateMachine", stateMachineEvent.getStateMachine());
        boolean bl = true;
        if (string != null && string.length() > 0) {
            bl = this.scriptManager.evalBoolean(string, hashMap);
        }
        if (!bl) {
            return null;
        }
        if (classArray.length == 0) {
            return ReflectUtils.invoke(method, object);
        }
        ArrayList<T> arrayList = Lists.newArrayList();
        for (Class<?> clazz : classArray) {
            if (clazz.isAssignableFrom(this.getClass())) {
                arrayList.add(stateMachineEvent.getStateMachine());
                continue;
            }
            arrayList.add(null);
        }
        return ReflectUtils.invoke(method, object, arrayList.toArray());
    }

    private Object invokeActionListenerMethod(Object object, Method method, String string, ActionExecutionService.ActionEvent<T, S, E, C> actionEvent) {
        Class<?>[] classArray = method.getParameterTypes();
        HashMap<String, Object> hashMap = Maps.newHashMap();
        hashMap.put("from", actionEvent.getFrom());
        hashMap.put("to", actionEvent.getTo());
        hashMap.put("event", actionEvent.getEvent());
        hashMap.put("context", actionEvent.getContext());
        hashMap.put("stateMachine", actionEvent.getStateMachine());
        if (actionEvent instanceof ActionExecutionService.ExecActionExceptionEvent) {
            TransitionException transitionException = ((ActionExecutionService.ExecActionExceptionEvent)actionEvent).getException();
            hashMap.put("exception", transitionException);
        }
        boolean bl = true;
        if (string != null && string.length() > 0) {
            bl = this.scriptManager.evalBoolean(string, hashMap);
        }
        if (!bl) {
            return null;
        }
        if (classArray.length == 0) {
            return ReflectUtils.invoke(method, object);
        }
        ArrayList<Object> arrayList = Lists.newArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (Class<Object> clazz : classArray) {
            if (!bl2 && clazz.isAssignableFrom(this.typeOfState())) {
                arrayList.add(actionEvent.getFrom());
                bl2 = true;
                continue;
            }
            if (!bl3 && clazz.isAssignableFrom(this.typeOfState())) {
                arrayList.add(actionEvent.getTo());
                bl3 = true;
                continue;
            }
            if (!bl4 && clazz.isAssignableFrom(this.typeOfEvent())) {
                arrayList.add(actionEvent.getEvent());
                bl4 = true;
                continue;
            }
            if (!bl5 && clazz.isAssignableFrom(this.typeOfContext())) {
                arrayList.add(actionEvent.getContext());
                bl5 = true;
                continue;
            }
            if (clazz.isAssignableFrom(this.getClass())) {
                arrayList.add(actionEvent.getStateMachine());
                continue;
            }
            if (clazz.isAssignableFrom(Action.class)) {
                arrayList.add(actionEvent.getExecutionTarget());
                continue;
            }
            if (clazz == int[].class) {
                arrayList.add(actionEvent.getMOfN());
                continue;
            }
            if (actionEvent instanceof ActionExecutionService.ExecActionExceptionEvent && clazz.isAssignableFrom(TransitionException.class)) {
                arrayList.add(((ActionExecutionService.ExecActionExceptionEvent)actionEvent).getException());
                continue;
            }
            arrayList.add(null);
        }
        return ReflectUtils.invoke(method, object, arrayList.toArray());
    }

    private Object invokeTransitionListenerMethod(Object object, Method method, String string, StateMachine.TransitionEvent<T, S, E, C> transitionEvent) {
        Class<?>[] classArray = method.getParameterTypes();
        HashMap<String, Object> hashMap = Maps.newHashMap();
        hashMap.put("from", transitionEvent.getSourceState());
        hashMap.put("event", transitionEvent.getCause());
        hashMap.put("context", transitionEvent.getContext());
        hashMap.put("stateMachine", transitionEvent.getStateMachine());
        if (transitionEvent instanceof StateMachine.TransitionCompleteEvent) {
            hashMap.put("to", ((StateMachine.TransitionCompleteEvent)transitionEvent).getTargetState());
        } else if (transitionEvent instanceof StateMachine.TransitionExceptionEvent) {
            hashMap.put("to", ((StateMachine.TransitionExceptionEvent)transitionEvent).getTargetState());
            hashMap.put("exception", ((StateMachine.TransitionExceptionEvent)transitionEvent).getException());
        }
        boolean bl = true;
        if (string != null && string.length() > 0) {
            bl = this.scriptManager.evalBoolean(string, hashMap);
        }
        if (!bl) {
            return null;
        }
        if (classArray.length == 0) {
            return ReflectUtils.invoke(method, object);
        }
        ArrayList<Object> arrayList = Lists.newArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (Class<Object> clazz : classArray) {
            if (!bl2 && clazz.isAssignableFrom(this.typeOfState())) {
                arrayList.add(transitionEvent.getSourceState());
                bl2 = true;
                continue;
            }
            if (!bl3 && transitionEvent instanceof StateMachine.TransitionEndEvent && clazz.isAssignableFrom(this.typeOfState())) {
                arrayList.add(((StateMachine.TransitionEndEvent)transitionEvent).getTargetState());
                bl3 = true;
                continue;
            }
            if (!bl3 && transitionEvent instanceof StateMachine.TransitionCompleteEvent && clazz.isAssignableFrom(this.typeOfState())) {
                arrayList.add(((StateMachine.TransitionCompleteEvent)transitionEvent).getTargetState());
                bl3 = true;
                continue;
            }
            if (!bl3 && transitionEvent instanceof StateMachine.TransitionExceptionEvent && clazz.isAssignableFrom(this.typeOfState()) && !bl3) {
                arrayList.add(((StateMachine.TransitionExceptionEvent)transitionEvent).getTargetState());
                bl3 = true;
                continue;
            }
            if (!bl4 && clazz.isAssignableFrom(this.typeOfEvent())) {
                arrayList.add(transitionEvent.getCause());
                bl4 = true;
                continue;
            }
            if (!bl5 && clazz.isAssignableFrom(this.typeOfContext())) {
                arrayList.add(transitionEvent.getContext());
                bl5 = true;
                continue;
            }
            if (clazz.isAssignableFrom(this.getClass())) {
                arrayList.add(transitionEvent.getStateMachine());
                continue;
            }
            if (transitionEvent instanceof StateMachine.TransitionExceptionEvent && clazz.isAssignableFrom(TransitionException.class)) {
                arrayList.add(((StateMachine.TransitionExceptionEvent)transitionEvent).getException());
                continue;
            }
            arrayList.add(null);
        }
        return ReflectUtils.invoke(method, object, arrayList.toArray());
    }

    private void registerDeclarativeListener(Object object, Method method, Observable observable, Class<? extends Annotation> clazz, Class<?> clazz2, Class<?> clazz3) {
        Annotation annotation = method.getAnnotation(clazz);
        if (annotation != null) {
            Field field;
            Method method2 = ReflectUtils.getMethod(annotation.getClass(), "when", new Class[0]);
            String string = "";
            if (method2 != null) {
                string = (String)ReflectUtils.invoke(method2, annotation);
            }
            if ((field = ReflectUtils.getField(clazz2, "METHOD")) != null && Modifier.isStatic(field.getModifiers())) {
                Method method3 = (Method)ReflectUtils.getStatic(field);
                Object object2 = this.newListenerMethodProxy(object, method, clazz2, string);
                observable.addListener(clazz3, object2, method3);
            } else {
                logger.info("Cannot find static field named 'METHOD' on listener class '" + clazz2 + "'.");
            }
        }
    }

    @Override
    public void addDeclarativeListener(Object object) {
        ArrayList<String> arrayList = Lists.newArrayList();
        Method[] methodArray = object.getClass().getMethods();
        Arrays.sort(methodArray, new Comparator<Method>(){

            @Override
            public int compare(Method method, Method method2) {
                ListenerOrder listenerOrder = method.getAnnotation(ListenerOrder.class);
                ListenerOrder listenerOrder2 = method2.getAnnotation(ListenerOrder.class);
                if (listenerOrder != null && listenerOrder2 != null) {
                    return listenerOrder.value() - listenerOrder2.value();
                }
                if (listenerOrder != null && listenerOrder2 == null) {
                    return -1;
                }
                if (listenerOrder == null && listenerOrder2 != null) {
                    return 1;
                }
                return method.getName().compareTo(method2.getName());
            }
        });
        for (Method method : methodArray) {
            int n;
            String string;
            if ("--wait-notify-notifyAll-toString-equals-hashCode-getClass--".indexOf("-" + method.getName() + "-") > 0 || arrayList.contains(string = method.toString())) continue;
            arrayList.add(string);
            for (n = 0; n < stateMachineListenerMapping.length; ++n) {
                this.registerDeclarativeListener(object, method, this, stateMachineListenerMapping[n][0], stateMachineListenerMapping[n][1], stateMachineListenerMapping[n][2]);
            }
            for (n = 0; n < actionExecutorListenerMapping.length; ++n) {
                this.registerDeclarativeListener(object, method, this.executor, actionExecutorListenerMapping[n][0], actionExecutorListenerMapping[n][1], actionExecutorListenerMapping[n][2]);
            }
        }
    }

    @Override
    public void removeDeclarativeListener(Object object) {
        this.removeDeclarativeListener(this, object);
        this.removeDeclarativeListener(this.executor, object);
    }

    public int getExecutorListenerSize() {
        return this.executor.getListenerSize();
    }

    @Override
    public String getIdentifier() {
        return this.data.read().identifier();
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id=\"").append(this.getIdentifier()).append("\" ");
        stringBuilder.append("fsm-type=\"").append(this.getClass().getName()).append("\" ");
        stringBuilder.append("state-type=\"").append(this.typeOfState().getName()).append("\" ");
        stringBuilder.append("event-type=\"").append(this.typeOfEvent().getName()).append("\" ");
        stringBuilder.append("context-type=\"").append(this.typeOfContext().getName()).append("\" ");
        Converter<E> converter = ConverterProvider.INSTANCE.getConverter(this.typeOfEvent());
        if (this.getStartEvent() != null) {
            stringBuilder.append("start-event=\"");
            stringBuilder.append(converter.convertToString(this.getStartEvent()));
            stringBuilder.append("\" ");
        }
        if (this.getTerminateEvent() != null) {
            stringBuilder.append("terminate-event=\"");
            stringBuilder.append(converter.convertToString(this.getTerminateEvent()));
            stringBuilder.append("\" ");
        }
        if (this.getFinishEvent() != null) {
            stringBuilder.append("finish-event=\"");
            stringBuilder.append(converter.convertToString(this.getFinishEvent()));
            stringBuilder.append("\" ");
        }
        stringBuilder.append("context-insensitive=\"").append(this.isContextSensitive()).append("\" ");
        if (this.extraParamTypes != null && this.extraParamTypes.length > 0) {
            stringBuilder.append("extra-parameters=\"[");
            for (int i = 0; i < this.extraParamTypes.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.extraParamTypes[i].getName());
            }
            stringBuilder.append("]\" ");
        }
        return stringBuilder.toString();
    }

    @Override
    public String exportXMLDefinition(boolean bl) {
        SCXMLVisitor sCXMLVisitor = SquirrelProvider.getInstance().newInstance(SCXMLVisitor.class);
        this.accept(sCXMLVisitor);
        return sCXMLVisitor.getScxml(bl);
    }

    private void removeDeclarativeListener(Observable observable, final Object object) {
        observable.removeListener(new Predicate<ListenerMethod>(){

            @Override
            public boolean apply(ListenerMethod listenerMethod) {
                return listenerMethod.getTarget() instanceof DeclarativeListener && ((DeclarativeListener)listenerMethod.getTarget()).getListenTarget() == object;
            }
        });
    }

    @Override
    public void addStateMachineListener(StateMachine.StateMachineListener<T, S, E, C> stateMachineListener) {
        this.addListener(StateMachine.StateMachineEvent.class, stateMachineListener, StateMachine.StateMachineListener.METHOD);
    }

    @Override
    public void removeStateMachineListener(StateMachine.StateMachineListener<T, S, E, C> stateMachineListener) {
        this.removeListener(StateMachine.StateMachineEvent.class, stateMachineListener, StateMachine.StateMachineListener.METHOD);
    }

    @Override
    public void addStartListener(StateMachine.StartListener<T, S, E, C> startListener) {
        this.addListener(StateMachine.StartEvent.class, startListener, StateMachine.StartListener.METHOD);
    }

    @Override
    public void removeStartListener(StateMachine.StartListener<T, S, E, C> startListener) {
        this.removeListener(StateMachine.StartEvent.class, startListener, StateMachine.StartListener.METHOD);
    }

    @Override
    public void addTerminateListener(StateMachine.TerminateListener<T, S, E, C> terminateListener) {
        this.addListener(StateMachine.TerminateEvent.class, terminateListener, StateMachine.TerminateListener.METHOD);
    }

    @Override
    public void removeTerminateListener(StateMachine.TerminateListener<T, S, E, C> terminateListener) {
        this.removeListener(StateMachine.TerminateEvent.class, terminateListener, StateMachine.TerminateListener.METHOD);
    }

    @Override
    public void addStateMachineExceptionListener(StateMachine.StateMachineExceptionListener<T, S, E, C> stateMachineExceptionListener) {
        this.addListener(StateMachine.StateMachineExceptionEvent.class, stateMachineExceptionListener, StateMachine.StateMachineExceptionListener.METHOD);
    }

    @Override
    public void removeStateMachineExceptionListener(StateMachine.StateMachineExceptionListener<T, S, E, C> stateMachineExceptionListener) {
        this.removeListener(StateMachine.StateMachineExceptionEvent.class, stateMachineExceptionListener, StateMachine.StateMachineExceptionListener.METHOD);
    }

    @Override
    public void addTransitionBeginListener(StateMachine.TransitionBeginListener<T, S, E, C> transitionBeginListener) {
        this.addListener(StateMachine.TransitionBeginEvent.class, transitionBeginListener, StateMachine.TransitionBeginListener.METHOD);
    }

    @Override
    public void removeTransitionBeginListener(StateMachine.TransitionBeginListener<T, S, E, C> transitionBeginListener) {
        this.removeListener(StateMachine.TransitionBeginEvent.class, transitionBeginListener, StateMachine.TransitionBeginListener.METHOD);
    }

    @Override
    public void addTransitionCompleteListener(StateMachine.TransitionCompleteListener<T, S, E, C> transitionCompleteListener) {
        this.addListener(StateMachine.TransitionCompleteEvent.class, transitionCompleteListener, StateMachine.TransitionCompleteListener.METHOD);
    }

    @Override
    public void removeTransitionCompleteListener(StateMachine.TransitionCompleteListener<T, S, E, C> transitionCompleteListener) {
        this.removeListener(StateMachine.TransitionCompleteEvent.class, transitionCompleteListener, StateMachine.TransitionCompleteListener.METHOD);
    }

    @Override
    public void addTransitionExceptionListener(StateMachine.TransitionExceptionListener<T, S, E, C> transitionExceptionListener) {
        this.addListener(StateMachine.TransitionExceptionEvent.class, transitionExceptionListener, StateMachine.TransitionExceptionListener.METHOD);
    }

    @Override
    public void removeTransitionExceptionListener(StateMachine.TransitionExceptionListener<T, S, E, C> transitionExceptionListener) {
        this.removeListener(StateMachine.TransitionExceptionEvent.class, transitionExceptionListener, StateMachine.TransitionExceptionListener.METHOD);
    }

    @Override
    public void addTransitionDeclinedListener(StateMachine.TransitionDeclinedListener<T, S, E, C> transitionDeclinedListener) {
        this.addListener(StateMachine.TransitionDeclinedEvent.class, transitionDeclinedListener, StateMachine.TransitionDeclinedListener.METHOD);
    }

    @Override
    public void removeTransitionDeclinedListener(StateMachine.TransitionDeclinedListener<T, S, E, C> transitionDeclinedListener) {
        this.removeListener(StateMachine.TransitionDeclinedEvent.class, transitionDeclinedListener, StateMachine.TransitionDeclinedListener.METHOD);
    }

    @Override
    @Deprecated
    public void removeTransitionDecleindListener(StateMachine.TransitionDeclinedListener<T, S, E, C> transitionDeclinedListener) {
        this.removeListener(StateMachine.TransitionDeclinedEvent.class, transitionDeclinedListener, StateMachine.TransitionDeclinedListener.METHOD);
    }

    @Override
    public void addTransitionEndListener(StateMachine.TransitionEndListener<T, S, E, C> transitionEndListener) {
        this.addListener(StateMachine.TransitionEndEvent.class, transitionEndListener, StateMachine.TransitionEndListener.METHOD);
    }

    @Override
    public void removeTransitionEndListener(StateMachine.TransitionEndListener<T, S, E, C> transitionEndListener) {
        this.removeListener(StateMachine.TransitionEndEvent.class, transitionEndListener, StateMachine.TransitionEndListener.METHOD);
    }

    @Override
    public void addExecActionListener(ActionExecutionService.BeforeExecActionListener<T, S, E, C> beforeExecActionListener) {
        this.executor.addExecActionListener(beforeExecActionListener);
    }

    @Override
    public void removeExecActionListener(ActionExecutionService.BeforeExecActionListener<T, S, E, C> beforeExecActionListener) {
        this.executor.removeExecActionListener(beforeExecActionListener);
    }

    public static class TransitionEndEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractTransitionEvent<T, S, E, C>
    implements StateMachine.TransitionEndEvent<T, S, E, C> {
        private final S targetState;

        public TransitionEndEventImpl(S s, S s2, E e, C c, T t) {
            super(s, e, c, t);
            this.targetState = s2;
        }

        @Override
        public S getTargetState() {
            return this.targetState;
        }
    }

    public static class TransitionDeclinedEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractTransitionEvent<T, S, E, C>
    implements StateMachine.TransitionDeclinedEvent<T, S, E, C> {
        public TransitionDeclinedEventImpl(S s, E e, C c, T t) {
            super(s, e, c, t);
        }
    }

    public static class TransitionExceptionEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractTransitionEvent<T, S, E, C>
    implements StateMachine.TransitionExceptionEvent<T, S, E, C> {
        private final S targetState;
        private final TransitionException e;

        public TransitionExceptionEventImpl(TransitionException transitionException, S s, S s2, E e, C c, T t) {
            super(s, e, c, t);
            this.targetState = s2;
            this.e = transitionException;
        }

        @Override
        public S getTargetState() {
            return this.targetState;
        }

        @Override
        public TransitionException getException() {
            return this.e;
        }
    }

    public static class TransitionCompleteEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractTransitionEvent<T, S, E, C>
    implements StateMachine.TransitionCompleteEvent<T, S, E, C> {
        private final S targetState;

        public TransitionCompleteEventImpl(S s, S s2, E e, C c, T t) {
            super(s, e, c, t);
            this.targetState = s2;
        }

        @Override
        public S getTargetState() {
            return this.targetState;
        }
    }

    public static class TransitionBeginEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractTransitionEvent<T, S, E, C>
    implements StateMachine.TransitionBeginEvent<T, S, E, C> {
        public TransitionBeginEventImpl(S s, E e, C c, T t) {
            super(s, e, c, t);
        }
    }

    public static abstract class AbstractTransitionEvent<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractStateMachineEvent<T, S, E, C>
    implements StateMachine.TransitionEvent<T, S, E, C> {
        private final S sourceState;
        private final E event;
        private final C context;

        public AbstractTransitionEvent(S s, E e, C c, T t) {
            super(t);
            this.sourceState = s;
            this.event = e;
            this.context = c;
        }

        @Override
        public S getSourceState() {
            return this.sourceState;
        }

        @Override
        public E getCause() {
            return this.event;
        }

        @Override
        public C getContext() {
            return this.context;
        }
    }

    public static class StateMachineExceptionEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractStateMachineEvent<T, S, E, C>
    implements StateMachine.StateMachineExceptionEvent<T, S, E, C> {
        private final Exception e;

        public StateMachineExceptionEventImpl(Exception exception, T t) {
            super(t);
            this.e = exception;
        }

        @Override
        public Exception getException() {
            return this.e;
        }
    }

    public static class TerminateEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractStateMachineEvent<T, S, E, C>
    implements StateMachine.TerminateEvent<T, S, E, C> {
        public TerminateEventImpl(T t) {
            super(t);
        }
    }

    public static class StartEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractStateMachineEvent<T, S, E, C>
    implements StateMachine.StartEvent<T, S, E, C> {
        public StartEventImpl(T t) {
            super(t);
        }
    }

    public static abstract class AbstractStateMachineEvent<T extends StateMachine<T, S, E, C>, S, E, C>
    implements StateMachine.StateMachineEvent<T, S, E, C> {
        private final T stateMachine;

        public AbstractStateMachineEvent(T t) {
            this.stateMachine = t;
        }

        @Override
        public T getStateMachine() {
            return this.stateMachine;
        }
    }

    private static interface DeclarativeListener {
        public Object getListenTarget();
    }
}

