/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.StateMachinePerformanceModel;
import org.squirrelframework.foundation.fsm.annotation.OnActionExecException;
import org.squirrelframework.foundation.fsm.annotation.OnAfterActionExecuted;
import org.squirrelframework.foundation.fsm.annotation.OnBeforeActionExecuted;
import org.squirrelframework.foundation.fsm.annotation.OnStateMachineStart;
import org.squirrelframework.foundation.fsm.annotation.OnStateMachineTerminate;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionBegin;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionDecline;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionEnd;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionException;

public class StateMachinePerformanceMonitor {
    private final String name;
    private final ConcurrentMap<String, Stopwatch> transitionWatches = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> transitionInvokeTimes = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> transitionFailedTimes = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> transitionDeclinedTimes = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> transitionElapsedMillis = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> maxTransitionConsumedTime = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> minTransitionConsumedTime = Maps.newConcurrentMap();
    private final ConcurrentMap<String, Stopwatch> actionWatches = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> actionInvokeTimes = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> actionFailedTimes = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> actionElapsedMillis = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> maxActionConsumedTime = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> minActionConsumedTime = Maps.newConcurrentMap();
    private final Object waitLock = new Object();
    private volatile boolean isBusyStat = false;

    public StateMachinePerformanceMonitor(String string) {
        this.name = string;
    }

    private String getTransitionKey(Object object, Object object2, Object object3, Object object4) {
        return object + "--{" + object3 + ", " + object4 + "}->" + object2;
    }

    private void clearCache() {
        this.transitionInvokeTimes.clear();
        this.transitionFailedTimes.clear();
        this.transitionDeclinedTimes.clear();
        this.transitionElapsedMillis.clear();
        this.maxTransitionConsumedTime.clear();
        this.minTransitionConsumedTime.clear();
        this.actionInvokeTimes.clear();
        this.actionFailedTimes.clear();
        this.actionElapsedMillis.clear();
        this.maxActionConsumedTime.clear();
        this.minActionConsumedTime.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIfBusyStat() {
        if (this.isBusyStat) {
            Object object = this.waitLock;
            synchronized (object) {
                while (this.isBusyStat) {
                    try {
                        this.waitLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(interruptedException);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllAfterBusyStat() {
        Object object = this.waitLock;
        synchronized (object) {
            this.isBusyStat = false;
            this.waitLock.notifyAll();
        }
    }

    @OnStateMachineStart
    public void onStateMachineStart(StateMachine<?, ?, ?, ?> stateMachine) {
        this.transitionWatches.put(stateMachine.getIdentifier(), Stopwatch.createUnstarted());
        this.actionWatches.put(stateMachine.getIdentifier(), Stopwatch.createUnstarted());
    }

    @OnStateMachineTerminate
    public void onStateMachineTerminate(StateMachine<?, ?, ?, ?> stateMachine) {
        this.transitionWatches.remove(stateMachine.getIdentifier());
        this.actionWatches.remove(stateMachine.getIdentifier());
    }

    @OnTransitionBegin
    public void onTransitionBegin(StateMachine<?, ?, ?, ?> stateMachine) {
        this.waitIfBusyStat();
        ((Stopwatch)this.transitionWatches.get(stateMachine.getIdentifier())).reset().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnTransitionEnd
    public void onTransitionEnd(Object object, Object object2, Object object3, Object object4, StateMachine<?, ?, ?, ?> stateMachine) {
        this.waitIfBusyStat();
        String string = this.getTransitionKey(object, object2, object3, object4);
        long l = ((Stopwatch)this.transitionWatches.get(stateMachine.getIdentifier())).stop().elapsed(TimeUnit.MILLISECONDS);
        this.transitionElapsedMillis.putIfAbsent(string, new AtomicLong(0L));
        ((AtomicLong)this.transitionElapsedMillis.get(string)).addAndGet(l);
        this.transitionInvokeTimes.putIfAbsent(string, new AtomicLong(0L));
        ((AtomicLong)this.transitionInvokeTimes.get(string)).incrementAndGet();
        StateMachinePerformanceMonitor stateMachinePerformanceMonitor = this;
        synchronized (stateMachinePerformanceMonitor) {
            if (this.maxTransitionConsumedTime.get(string) == null || l > ((AtomicLong)this.maxTransitionConsumedTime.get(string)).get()) {
                this.maxTransitionConsumedTime.put(string, new AtomicLong(l));
            }
            if (this.minTransitionConsumedTime.get(string) == null || l < ((AtomicLong)this.minTransitionConsumedTime.get(string)).get()) {
                this.minTransitionConsumedTime.put(string, new AtomicLong(l));
            }
        }
    }

    @OnTransitionException
    public void onTransitionException(Object object, Object object2, Object object3, Object object4) {
        this.waitIfBusyStat();
        String string = this.getTransitionKey(object, object2, object3, object4);
        this.transitionFailedTimes.putIfAbsent(string, new AtomicLong(0L));
        ((AtomicLong)this.transitionFailedTimes.get(string)).incrementAndGet();
    }

    @OnTransitionDecline
    public void onTransitionDeclined(Object object, Object object2, Object object3) {
        this.waitIfBusyStat();
        String string = this.getTransitionKey(object, null, object2, object3);
        this.transitionDeclinedTimes.putIfAbsent(string, new AtomicLong(0L));
        ((AtomicLong)this.transitionDeclinedTimes.get(string)).incrementAndGet();
    }

    @OnBeforeActionExecuted
    public void onBeforeActionExecuted(StateMachine<?, ?, ?, ?> stateMachine, Action<?, ?, ?, ?> action) {
        this.waitIfBusyStat();
        ((Stopwatch)this.actionWatches.get(stateMachine.getIdentifier())).reset().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnAfterActionExecuted
    public void onAfterActionExecuted(StateMachine<?, ?, ?, ?> stateMachine, Action<?, ?, ?, ?> action) {
        this.waitIfBusyStat();
        String string = action.toString();
        long l = ((Stopwatch)this.actionWatches.get(stateMachine.getIdentifier())).stop().elapsed(TimeUnit.MILLISECONDS);
        this.actionElapsedMillis.putIfAbsent(string, new AtomicLong(0L));
        ((AtomicLong)this.actionElapsedMillis.get(string)).addAndGet(l);
        this.actionInvokeTimes.putIfAbsent(string, new AtomicLong(0L));
        ((AtomicLong)this.actionInvokeTimes.get(string)).incrementAndGet();
        StateMachinePerformanceMonitor stateMachinePerformanceMonitor = this;
        synchronized (stateMachinePerformanceMonitor) {
            if (this.maxActionConsumedTime.get(string) == null || l > ((AtomicLong)this.maxActionConsumedTime.get(string)).get()) {
                this.maxActionConsumedTime.put(string, new AtomicLong(l));
            }
            if (this.minActionConsumedTime.get(string) == null || l < ((AtomicLong)this.minActionConsumedTime.get(string)).get()) {
                this.minActionConsumedTime.put(string, new AtomicLong(l));
            }
        }
    }

    @OnActionExecException
    public void onActionExecException(Action<?, ?, ?, ?> action) {
        this.waitIfBusyStat();
        String string = action.toString();
        this.actionFailedTimes.putIfAbsent(string, new AtomicLong(0L));
        ((AtomicLong)this.actionFailedTimes.get(string)).incrementAndGet();
    }

    private long getTotal(ConcurrentMap<String, AtomicLong> concurrentMap) {
        long l = 0L;
        for (AtomicLong atomicLong : concurrentMap.values()) {
            l += atomicLong.get();
        }
        return l;
    }

    public synchronized StateMachinePerformanceModel getPerfModel() {
        float f;
        this.isBusyStat = true;
        StateMachinePerformanceModel stateMachinePerformanceModel = new StateMachinePerformanceModel();
        stateMachinePerformanceModel.setName(this.name);
        long l = this.getTotal(this.transitionInvokeTimes);
        stateMachinePerformanceModel.setTotalTransitionInvokedTimes(l);
        long l2 = this.getTotal(this.transitionFailedTimes);
        stateMachinePerformanceModel.setTotalTransitionFailedTimes(l2);
        long l3 = this.getTotal(this.transitionDeclinedTimes);
        stateMachinePerformanceModel.setTotalTransitionDeclinedTimes(l3);
        long l4 = this.getTotal(this.transitionElapsedMillis);
        float f2 = (float)l4 / ((float)l + Float.MIN_VALUE);
        stateMachinePerformanceModel.setAverageTranstionConsumedTime(f2);
        long l5 = this.getTotal(this.actionInvokeTimes);
        stateMachinePerformanceModel.setTotalActionInvokedTimes(l5);
        long l6 = this.getTotal(this.actionFailedTimes);
        stateMachinePerformanceModel.setTotalActionFailedTimes(l6);
        long l7 = this.getTotal(this.actionElapsedMillis);
        float f3 = (float)l7 / ((float)l5 + Float.MIN_VALUE);
        stateMachinePerformanceModel.setAverageActionConsumedTime(f3);
        for (String string : this.transitionInvokeTimes.keySet()) {
            f = (float)((AtomicLong)this.transitionElapsedMillis.get(string)).get() / ((float)((AtomicLong)this.transitionInvokeTimes.get(string)).get() + Float.MIN_VALUE);
            stateMachinePerformanceModel.addAverTransitionConsumedTime(string, f);
            stateMachinePerformanceModel.addTransitionInvokeTime(string, ((AtomicLong)this.transitionInvokeTimes.get(string)).get());
            stateMachinePerformanceModel.addMaxTransitionConsumedTime(string, ((AtomicLong)this.maxTransitionConsumedTime.get(string)).get());
            stateMachinePerformanceModel.addMinTransitionConsumedTime(string, ((AtomicLong)this.minTransitionConsumedTime.get(string)).get());
        }
        for (String string : this.actionInvokeTimes.keySet()) {
            f = (float)((AtomicLong)this.actionElapsedMillis.get(string)).get() / ((float)((AtomicLong)this.actionInvokeTimes.get(string)).get() + Float.MIN_VALUE);
            stateMachinePerformanceModel.addAverActionConsumedTime(string, f);
            stateMachinePerformanceModel.addActionInvokeTime(string, ((AtomicLong)this.actionInvokeTimes.get(string)).get());
            stateMachinePerformanceModel.addMaxActionConsumedTime(string, ((AtomicLong)this.maxActionConsumedTime.get(string)).get());
            stateMachinePerformanceModel.addMinActionConsumedTime(string, ((AtomicLong)this.minActionConsumedTime.get(string)).get());
        }
        this.clearCache();
        this.notifyAllAfterBusyStat();
        return stateMachinePerformanceModel;
    }
}

