/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.event;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import org.squirrelframework.foundation.component.SquirrelComponent;
import org.squirrelframework.foundation.event.ListenerMethod;

public class PolymEventDispatcher
implements SquirrelComponent {
    private LinkedHashSet<ListenerMethod> listeners = null;

    public void register(Class<?> clazz, Object object, Method method) {
        if (this.listeners == null) {
            this.listeners = new LinkedHashSet();
        }
        this.listeners.add(new ListenerMethod(clazz, object, method));
    }

    public void unregister(Predicate<ListenerMethod> predicate) {
        if (this.listeners != null) {
            Iterators.removeIf(this.listeners.iterator(), predicate);
        }
    }

    public void unregister(final Class<?> clazz, final Object object) {
        if (this.listeners != null) {
            Iterators.removeIf(this.listeners.iterator(), new Predicate<ListenerMethod>(){

                @Override
                public boolean apply(ListenerMethod listenerMethod) {
                    return listenerMethod.matches(clazz, object);
                }
            });
        }
    }

    public void unregister(final Class<?> clazz, final Object object, final Method method) {
        ListenerMethod listenerMethod;
        if (this.listeners != null && (listenerMethod = Iterators.find(this.listeners.iterator(), new Predicate<ListenerMethod>(){

            @Override
            public boolean apply(ListenerMethod listenerMethod) {
                return listenerMethod.matches(clazz, object, method);
            }
        })) != null) {
            this.listeners.remove(listenerMethod);
        }
    }

    public void unregisterAll() {
        this.listeners = null;
    }

    public void fireEvent(Object object) {
        if (this.listeners == null) {
            return;
        }
        ListenerMethod[] listenerMethodArray = this.listeners.toArray(new ListenerMethod[this.listeners.size()]);
        for (int i = 0; i < listenerMethodArray.length; ++i) {
            if (!listenerMethodArray[i].getEventType().isAssignableFrom(object.getClass())) continue;
            listenerMethodArray[i].invokeMethod(object);
        }
    }

    public int getListenerSize() {
        return this.listeners != null ? this.listeners.size() : 0;
    }
}

