/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.component.impl;

import com.google.common.base.Predicate;
import java.lang.reflect.Method;
import org.squirrelframework.foundation.component.Observable;
import org.squirrelframework.foundation.component.SquirrelProvider;
import org.squirrelframework.foundation.event.ListenerMethod;
import org.squirrelframework.foundation.event.PolymEventDispatcher;
import org.squirrelframework.foundation.event.SquirrelEvent;
import org.squirrelframework.foundation.util.ReflectUtils;

public abstract class AbstractSubject
implements Observable {
    private boolean notifiable = true;
    private PolymEventDispatcher eventDispatcher;

    @Override
    public boolean isNotifiable() {
        return this.notifiable;
    }

    @Override
    public void setNotifiable(boolean bl) {
        this.notifiable = bl;
    }

    @Override
    public void addListener(Class<?> clazz, Object object, Method method) {
        if (this.eventDispatcher == null) {
            this.eventDispatcher = SquirrelProvider.getInstance().newInstance(PolymEventDispatcher.class);
        }
        this.eventDispatcher.register(clazz, object, method);
    }

    @Override
    public void addListener(Class<?> clazz, Object object, String string) {
        Method method = ReflectUtils.getFirstMethodOfName(object.getClass(), string);
        this.addListener(clazz, object, method);
    }

    @Override
    public void removeListener(Predicate<ListenerMethod> predicate) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.unregister(predicate);
        }
    }

    @Override
    public void removeListener(Class<?> clazz, Object object, Method method) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.unregister(clazz, object, method);
        }
    }

    @Override
    public int getListenerSize() {
        return this.eventDispatcher != null ? this.eventDispatcher.getListenerSize() : 0;
    }

    @Override
    public void removeListener(Class<?> clazz, Object object, String string) {
        Method method = ReflectUtils.getFirstMethodOfName(object.getClass(), string);
        this.removeListener(clazz, object, method);
    }

    @Override
    public void removeListener(Class<?> clazz, Object object) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.unregister(clazz, object);
        }
    }

    @Override
    public void removeAllListeners() {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.unregisterAll();
        }
    }

    @Override
    public void fireEvent(SquirrelEvent squirrelEvent) {
        if (this.eventDispatcher != null && this.isNotifiable()) {
            this.eventDispatcher.fireEvent(squirrelEvent);
        }
    }
}

