/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.squirrelframework.foundation.component.SquirrelComponent;
import org.squirrelframework.foundation.component.SquirrelPostProcessor;
import org.squirrelframework.foundation.component.SquirrelProvider;
import org.squirrelframework.foundation.component.SquirrelSingleton;
import org.squirrelframework.foundation.component.impl.CompositePostProcessorImpl;
import org.squirrelframework.foundation.util.ClassComparator;
import org.squirrelframework.foundation.util.ReflectUtils;
import org.squirrelframework.foundation.util.TypeReference;

public class SquirrelPostProcessorProvider
implements SquirrelComponent,
SquirrelSingleton {
    private static SquirrelPostProcessorProvider instance = new SquirrelPostProcessorProvider();
    private Map<Class<?>, SquirrelPostProcessor<?>> postProcessorRegistry = new ConcurrentHashMap();

    public static SquirrelPostProcessorProvider getInstance() {
        return instance;
    }

    public static void setInstance(SquirrelPostProcessorProvider squirrelPostProcessorProvider) {
        instance = squirrelPostProcessorProvider;
    }

    public <T> void register(Class<T> clazz, SquirrelPostProcessor<? super T> squirrelPostProcessor) {
        Method method = ReflectUtils.getFirstMethodOfName(squirrelPostProcessor.getClass(), "postProcess");
        Class<?>[] classArray = method.getParameterTypes();
        Preconditions.checkArgument(classArray.length == 1, "Parameter size of method " + method.getName() + " is not match.");
        Preconditions.checkArgument(classArray[0].isAssignableFrom(clazz), "Parameter type of method " + method.getName() + " is not correct.");
        if (this.postProcessorRegistry.containsKey(clazz)) {
            SquirrelPostProcessor<?> squirrelPostProcessor2 = this.postProcessorRegistry.get(clazz);
            if (squirrelPostProcessor2 instanceof CompositePostProcessorImpl) {
                ((CompositePostProcessorImpl)squirrelPostProcessor2).compose(squirrelPostProcessor);
            } else {
                this.postProcessorRegistry.remove(clazz);
                CompositePostProcessorImpl<T> compositePostProcessorImpl = new CompositePostProcessorImpl<T>(squirrelPostProcessor2);
                compositePostProcessorImpl.compose(squirrelPostProcessor);
                this.postProcessorRegistry.put(clazz, compositePostProcessorImpl);
            }
        } else {
            this.postProcessorRegistry.put(clazz, squirrelPostProcessor);
        }
    }

    public <T> void register(Class<T> clazz, Class<? extends SquirrelPostProcessor<? super T>> clazz2) {
        SquirrelPostProcessor<? super T> squirrelPostProcessor = SquirrelProvider.getInstance().newInstance(clazz2);
        this.register(clazz, squirrelPostProcessor);
    }

    public void unregister(Class<?> clazz) {
        this.postProcessorRegistry.remove(clazz);
    }

    public void clearRegistry() {
        this.postProcessorRegistry.clear();
    }

    public <T> SquirrelPostProcessor<T> getPostProcessor(Class<T> clazz) {
        return this.postProcessorRegistry.get(clazz);
    }

    public <T> List<SquirrelPostProcessor<? super T>> getCallablePostProcessors(Class<T> clazz) {
        ArrayList<SquirrelPostProcessor<T>> arrayList = Lists.newArrayList();
        for (Map.Entry<Class<?>, SquirrelPostProcessor<?>> entry : this.postProcessorRegistry.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            SquirrelPostProcessor<?> squirrelPostProcessor = entry.getValue();
            arrayList.add(squirrelPostProcessor);
        }
        return arrayList;
    }

    public <T> SquirrelPostProcessor<? super T> getBestMatchPostProcessor(Class<T> clazz, Comparator<SquirrelPostProcessor<? super T>> comparator) {
        List<SquirrelPostProcessor<T>> list = this.getCallablePostProcessors(clazz);
        if (list.isEmpty()) {
            return null;
        }
        Collections.sort(list, comparator);
        return list.get(0);
    }

    public <T> SquirrelPostProcessor<? super T> getBestMatchPostProcessor(Class<T> clazz) {
        return this.getBestMatchPostProcessor(clazz, new ClassComparator<SquirrelPostProcessor<? super T>>());
    }

    public <T> void register(Class<T> clazz, TypeReference<? extends SquirrelPostProcessor<? super T>> typeReference) {
        this.register(clazz, typeReference.getRawType());
    }

    public <T> void register(TypeReference<T> typeReference, SquirrelPostProcessor<? super T> squirrelPostProcessor) {
        this.register(typeReference.getRawType(), squirrelPostProcessor);
    }
}

