/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import org.quartz.SchedulerException;
import org.quartz.spi.InstanceIdGenerator;

public class SystemPropertyInstanceIdGenerator
implements InstanceIdGenerator {
    public static final String SYSTEM_PROPERTY = "org.quartz.scheduler.instanceId";
    private String prepend = null;
    private String postpend = null;
    private String systemPropertyName = "org.quartz.scheduler.instanceId";

    @Override
    public String generateInstanceId() throws SchedulerException {
        String string = System.getProperty(this.getSystemPropertyName());
        if (string == null) {
            throw new SchedulerException("No value for 'org.quartz.scheduler.instanceId' system property found, please configure your environment accordingly!");
        }
        if (this.getPrepend() != null) {
            string = this.getPrepend() + string;
        }
        if (this.getPostpend() != null) {
            string = string + this.getPostpend();
        }
        return string;
    }

    public String getPrepend() {
        return this.prepend;
    }

    public void setPrepend(String string) {
        this.prepend = string == null ? null : string.trim();
    }

    public String getPostpend() {
        return this.postpend;
    }

    public void setPostpend(String string) {
        this.postpend = string == null ? null : string.trim();
    }

    public String getSystemPropertyName() {
        return this.systemPropertyName;
    }

    public void setSystemPropertyName(String string) {
        this.systemPropertyName = string == null ? SYSTEM_PROPERTY : string.trim();
    }
}

