/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.quartz.SchedulerConfigException;
import org.quartz.spi.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleThreadPool
implements ThreadPool {
    private int count = -1;
    private int prio = 5;
    private boolean isShutdown = false;
    private boolean handoffPending = false;
    private boolean inheritLoader = false;
    private boolean inheritGroup = true;
    private boolean makeThreadsDaemons = false;
    private ThreadGroup threadGroup;
    private final Object nextRunnableLock = new Object();
    private List<WorkerThread> workers;
    private LinkedList<WorkerThread> availWorkers = new LinkedList();
    private LinkedList<WorkerThread> busyWorkers = new LinkedList();
    private String threadNamePrefix;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String schedulerInstanceName;

    public SimpleThreadPool() {
    }

    public SimpleThreadPool(int n, int n2) {
        this.setThreadCount(n);
        this.setThreadPriority(n2);
    }

    public Logger getLog() {
        return this.log;
    }

    @Override
    public int getPoolSize() {
        return this.getThreadCount();
    }

    public void setThreadCount(int n) {
        this.count = n;
    }

    public int getThreadCount() {
        return this.count;
    }

    public void setThreadPriority(int n) {
        this.prio = n;
    }

    public int getThreadPriority() {
        return this.prio;
    }

    public void setThreadNamePrefix(String string) {
        this.threadNamePrefix = string;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public boolean isThreadsInheritContextClassLoaderOfInitializingThread() {
        return this.inheritLoader;
    }

    public void setThreadsInheritContextClassLoaderOfInitializingThread(boolean bl) {
        this.inheritLoader = bl;
    }

    public boolean isThreadsInheritGroupOfInitializingThread() {
        return this.inheritGroup;
    }

    public void setThreadsInheritGroupOfInitializingThread(boolean bl) {
        this.inheritGroup = bl;
    }

    public boolean isMakeThreadsDaemons() {
        return this.makeThreadsDaemons;
    }

    public void setMakeThreadsDaemons(boolean bl) {
        this.makeThreadsDaemons = bl;
    }

    @Override
    public void setInstanceId(String string) {
    }

    @Override
    public void setInstanceName(String string) {
        this.schedulerInstanceName = string;
    }

    @Override
    public void initialize() throws SchedulerConfigException {
        if (this.workers != null && this.workers.size() > 0) {
            return;
        }
        if (this.count <= 0) {
            throw new SchedulerConfigException("Thread count must be > 0");
        }
        if (this.prio <= 0 || this.prio > 9) {
            throw new SchedulerConfigException("Thread priority must be > 0 and <= 9");
        }
        if (this.isThreadsInheritGroupOfInitializingThread()) {
            this.threadGroup = Thread.currentThread().getThreadGroup();
        } else {
            this.threadGroup = Thread.currentThread().getThreadGroup();
            Object object = this.threadGroup;
            while (!((ThreadGroup)object).getName().equals("main")) {
                this.threadGroup = object;
                object = this.threadGroup.getParent();
            }
            this.threadGroup = new ThreadGroup((ThreadGroup)object, this.schedulerInstanceName + "-SimpleThreadPool");
            if (this.isMakeThreadsDaemons()) {
                this.threadGroup.setDaemon(true);
            }
        }
        if (this.isThreadsInheritContextClassLoaderOfInitializingThread()) {
            this.getLog().info("Job execution threads will use class loader of thread: " + Thread.currentThread().getName());
        }
        for (WorkerThread workerThread : this.createWorkerThreads(this.count)) {
            workerThread.start();
            this.availWorkers.add(workerThread);
        }
    }

    protected List<WorkerThread> createWorkerThreads(int n) {
        this.workers = new LinkedList<WorkerThread>();
        for (int i = 1; i <= n; ++i) {
            String string = this.getThreadNamePrefix();
            if (string == null) {
                string = this.schedulerInstanceName + "_Worker";
            }
            WorkerThread workerThread = new WorkerThread(this, this.threadGroup, string + "-" + i, this.getThreadPriority(), this.isMakeThreadsDaemons());
            if (this.isThreadsInheritContextClassLoaderOfInitializingThread()) {
                workerThread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
            }
            this.workers.add(workerThread);
        }
        return this.workers;
    }

    public void shutdown() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean bl) {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            this.getLog().debug("Shutting down threadpool...");
            this.isShutdown = true;
            if (this.workers == null) {
                return;
            }
            for (WorkerThread workerThread : this.workers) {
                workerThread.shutdown();
                this.availWorkers.remove(workerThread);
            }
            this.nextRunnableLock.notifyAll();
            if (bl) {
                boolean bl2 = false;
                try {
                    WorkerThread workerThread;
                    while (this.handoffPending) {
                        try {
                            this.nextRunnableLock.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            bl2 = true;
                        }
                    }
                    while (this.busyWorkers.size() > 0) {
                        workerThread = this.busyWorkers.getFirst();
                        try {
                            this.getLog().debug("Waiting for thread " + workerThread.getName() + " to shut down");
                            this.nextRunnableLock.wait(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            bl2 = true;
                        }
                    }
                    Iterator<WorkerThread> iterator = this.workers.iterator();
                    while (iterator.hasNext()) {
                        workerThread = iterator.next();
                        try {
                            workerThread.join();
                            iterator.remove();
                        }
                        catch (InterruptedException interruptedException) {
                            bl2 = true;
                        }
                    }
                }
                finally {
                    if (bl2) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.getLog().debug("No executing jobs remaining, all threads stopped.");
            }
            this.getLog().debug("Shutdown of threadpool complete.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runInThread(Runnable runnable) {
        if (runnable == null) {
            return false;
        }
        Object object = this.nextRunnableLock;
        synchronized (object) {
            this.handoffPending = true;
            while (this.availWorkers.size() < 1 && !this.isShutdown) {
                try {
                    this.nextRunnableLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.isShutdown) {
                WorkerThread workerThread = this.availWorkers.removeFirst();
                this.busyWorkers.add(workerThread);
                workerThread.run(runnable);
            } else {
                WorkerThread workerThread = new WorkerThread(this, this.threadGroup, "WorkerThread-LastJob", this.prio, this.isMakeThreadsDaemons(), runnable);
                this.busyWorkers.add(workerThread);
                this.workers.add(workerThread);
                workerThread.start();
            }
            this.nextRunnableLock.notifyAll();
            this.handoffPending = false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int blockForAvailableThreads() {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            while ((this.availWorkers.size() < 1 || this.handoffPending) && !this.isShutdown) {
                try {
                    this.nextRunnableLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.availWorkers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeAvailable(WorkerThread workerThread) {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            if (!this.isShutdown) {
                this.availWorkers.add(workerThread);
            }
            this.busyWorkers.remove(workerThread);
            this.nextRunnableLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearFromBusyWorkersList(WorkerThread workerThread) {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            this.busyWorkers.remove(workerThread);
            this.nextRunnableLock.notifyAll();
        }
    }

    class WorkerThread
    extends Thread {
        private final Object lock;
        private AtomicBoolean run;
        private SimpleThreadPool tp;
        private Runnable runnable;
        private boolean runOnce;

        WorkerThread(SimpleThreadPool simpleThreadPool2, ThreadGroup threadGroup, String string, int n, boolean bl) {
            this(simpleThreadPool2, threadGroup, string, n, bl, null);
        }

        WorkerThread(SimpleThreadPool simpleThreadPool2, ThreadGroup threadGroup, String string, int n, boolean bl, Runnable runnable) {
            super(threadGroup, string);
            this.lock = new Object();
            this.run = new AtomicBoolean(true);
            this.runnable = null;
            this.runOnce = false;
            this.tp = simpleThreadPool2;
            this.runnable = runnable;
            if (runnable != null) {
                this.runOnce = true;
            }
            this.setPriority(n);
            this.setDaemon(bl);
        }

        void shutdown() {
            this.run.set(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Runnable runnable) {
            Object object = this.lock;
            synchronized (object) {
                if (this.runnable != null) {
                    throw new IllegalStateException("Already running a Runnable!");
                }
                this.runnable = runnable;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            while (this.run.get()) {
                Object object;
                try {
                    object = this.lock;
                    synchronized (object) {
                        while (this.runnable == null && this.run.get()) {
                            this.lock.wait(500L);
                        }
                        if (this.runnable != null) {
                            bl = true;
                            this.runnable.run();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    try {
                        SimpleThreadPool.this.getLog().error("Worker thread was interrupt()'ed.", interruptedException);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    try {
                        SimpleThreadPool.this.getLog().error("Error while executing the Runnable: ", throwable);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                finally {
                    object = this.lock;
                    synchronized (object) {
                        this.runnable = null;
                    }
                    if (this.getPriority() != this.tp.getThreadPriority()) {
                        this.setPriority(this.tp.getThreadPriority());
                    }
                    if (this.runOnce) {
                        this.run.set(false);
                        SimpleThreadPool.this.clearFromBusyWorkersList(this);
                        continue;
                    }
                    if (!bl) continue;
                    bl = false;
                    SimpleThreadPool.this.makeAvailable(this);
                }
            }
            try {
                SimpleThreadPool.this.getLog().debug("WorkerThread is shut down.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

