/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.listeners;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;
import org.quartz.TriggerListener;

public class BroadcastTriggerListener
implements TriggerListener {
    private String name;
    private List<TriggerListener> listeners;

    public BroadcastTriggerListener(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Listener name cannot be null!");
        }
        this.name = string;
        this.listeners = new LinkedList<TriggerListener>();
    }

    public BroadcastTriggerListener(String string, List<TriggerListener> list) {
        this(string);
        this.listeners.addAll(list);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addListener(TriggerListener triggerListener) {
        this.listeners.add(triggerListener);
    }

    public boolean removeListener(TriggerListener triggerListener) {
        return this.listeners.remove(triggerListener);
    }

    public boolean removeListener(String string) {
        Iterator<TriggerListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            TriggerListener triggerListener = iterator.next();
            if (!triggerListener.getName().equals(string)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public List<TriggerListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public void triggerFired(Trigger trigger, JobExecutionContext jobExecutionContext) {
        for (TriggerListener triggerListener : this.listeners) {
            triggerListener.triggerFired(trigger, jobExecutionContext);
        }
    }

    @Override
    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext jobExecutionContext) {
        for (TriggerListener triggerListener : this.listeners) {
            if (!triggerListener.vetoJobExecution(trigger, jobExecutionContext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void triggerMisfired(Trigger trigger) {
        for (TriggerListener triggerListener : this.listeners) {
            triggerListener.triggerMisfired(trigger);
        }
    }

    @Override
    public void triggerComplete(Trigger trigger, JobExecutionContext jobExecutionContext, Trigger.CompletedExecutionInstruction completedExecutionInstruction) {
        for (TriggerListener triggerListener : this.listeners) {
            triggerListener.triggerComplete(trigger, jobExecutionContext, completedExecutionInstruction);
        }
    }
}

