/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.listeners;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;

public class BroadcastJobListener
implements JobListener {
    private String name;
    private List<JobListener> listeners;

    public BroadcastJobListener(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Listener name cannot be null!");
        }
        this.name = string;
        this.listeners = new LinkedList<JobListener>();
    }

    public BroadcastJobListener(String string, List<JobListener> list) {
        this(string);
        this.listeners.addAll(list);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addListener(JobListener jobListener) {
        this.listeners.add(jobListener);
    }

    public boolean removeListener(JobListener jobListener) {
        return this.listeners.remove(jobListener);
    }

    public boolean removeListener(String string) {
        Iterator<JobListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            JobListener jobListener = iterator.next();
            if (!jobListener.getName().equals(string)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public List<JobListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public void jobToBeExecuted(JobExecutionContext jobExecutionContext) {
        for (JobListener jobListener : this.listeners) {
            jobListener.jobToBeExecuted(jobExecutionContext);
        }
    }

    @Override
    public void jobExecutionVetoed(JobExecutionContext jobExecutionContext) {
        for (JobListener jobListener : this.listeners) {
            jobListener.jobExecutionVetoed(jobExecutionContext);
        }
    }

    @Override
    public void jobWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException jobExecutionException) {
        for (JobListener jobListener : this.listeners) {
            jobListener.jobWasExecuted(jobExecutionContext, jobExecutionException);
        }
    }
}

