/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.jms;

import javax.jms.Message;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.jobs.ee.jms.JmsHelper;
import org.quartz.jobs.ee.jms.JmsMessageFactory;

public final class SendTopicMessageJob
implements Job {
    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        TopicConnection topicConnection = null;
        TopicSession topicSession = null;
        TopicPublisher topicPublisher = null;
        try {
            JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
            InitialContext initialContext = JmsHelper.getInitialContext(jobDataMap);
            TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)initialContext.lookup(jobDataMap.getString("jms.connection.factory"));
            if (!JmsHelper.isDestinationSecure(jobDataMap)) {
                topicConnection = topicConnectionFactory.createTopicConnection();
            } else {
                String string = jobDataMap.getString("jms.user");
                String string2 = jobDataMap.getString("jms.password");
                topicConnection = topicConnectionFactory.createTopicConnection(string, string2);
            }
            boolean bl = JmsHelper.useTransaction(jobDataMap);
            int n = jobDataMap.getInt("jms.acknowledge");
            topicSession = topicConnection.createTopicSession(bl, n);
            Topic topic = (Topic)initialContext.lookup(jobDataMap.getString("jms.destination"));
            topicPublisher = topicSession.createPublisher(topic);
            JmsMessageFactory jmsMessageFactory = JmsHelper.getMessageFactory(jobDataMap.getString("jms.message.factory.class.name"));
            Message message = jmsMessageFactory.createMessage(jobDataMap, (Session)topicSession);
            topicPublisher.publish(message);
        }
        catch (Exception exception) {
            try {
                throw new JobExecutionException(exception);
            }
            catch (Throwable throwable) {
                JmsHelper.closeResource(topicPublisher);
                JmsHelper.closeResource(topicSession);
                JmsHelper.closeResource(topicConnection);
                throw throwable;
            }
        }
        JmsHelper.closeResource(topicPublisher);
        JmsHelper.closeResource(topicSession);
        JmsHelper.closeResource(topicConnection);
    }
}

