/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.jms;

import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.jobs.ee.jms.JmsHelper;
import org.quartz.jobs.ee.jms.JmsMessageFactory;

public final class SendQueueMessageJob
implements Job {
    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        QueueConnection queueConnection = null;
        QueueSession queueSession = null;
        QueueSender queueSender = null;
        try {
            JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
            InitialContext initialContext = JmsHelper.getInitialContext(jobDataMap);
            QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)initialContext.lookup(jobDataMap.getString("jms.connection.factory"));
            if (!JmsHelper.isDestinationSecure(jobDataMap)) {
                queueConnection = queueConnectionFactory.createQueueConnection();
            } else {
                String string = jobDataMap.getString("jms.user");
                String string2 = jobDataMap.getString("jms.password");
                queueConnection = queueConnectionFactory.createQueueConnection(string, string2);
            }
            boolean bl = JmsHelper.useTransaction(jobDataMap);
            int n = jobDataMap.getInt("jms.acknowledge");
            queueSession = queueConnection.createQueueSession(bl, n);
            Queue queue = (Queue)initialContext.lookup(jobDataMap.getString("jms.destination"));
            queueSender = queueSession.createSender(queue);
            JmsMessageFactory jmsMessageFactory = JmsHelper.getMessageFactory(jobDataMap.getString("jms.message.factory.class.name"));
            Message message = jmsMessageFactory.createMessage(jobDataMap, (Session)queueSession);
            queueSender.send(message);
        }
        catch (Exception exception) {
            try {
                throw new JobExecutionException(exception.getMessage());
            }
            catch (Throwable throwable) {
                JmsHelper.closeResource(queueSender);
                JmsHelper.closeResource(queueSession);
                JmsHelper.closeResource(queueConnection);
                throw throwable;
            }
        }
        JmsHelper.closeResource(queueSender);
        JmsHelper.closeResource(queueSession);
        JmsHelper.closeResource(queueConnection);
    }
}

