/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.jms;

import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.quartz.JobDataMap;
import org.quartz.jobs.ee.jms.JmsJobException;
import org.quartz.jobs.ee.jms.JmsMessageFactory;

public final class JmsHelper {
    public static final String CREDENTIALS = "java.naming.security.credentials";
    public static final String INITIAL_CONTEXT_FACTORY = "java.naming.factory.initial";
    public static final String JMS_ACK_MODE = "jms.acknowledge";
    public static final String JMS_CONNECTION_FACTORY_JNDI = "jms.connection.factory";
    public static final String JMS_DESTINATION_JNDI = "jms.destination";
    public static final String JMS_MSG_FACTORY_CLASS_NAME = "jms.message.factory.class.name";
    public static final String JMS_PASSWORD = "jms.password";
    public static final String JMS_USE_TXN = "jms.use.transaction";
    public static final String JMS_USER = "jms.user";
    public static final String PRINCIPAL = "java.naming.security.principal";
    public static final String PROVIDER_URL = "java.naming.provider.url";

    public static void closeResource(Object object) {
        if (object == null) {
            return;
        }
        try {
            Method method = object.getClass().getMethod("close", new Class[0]);
            method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static InitialContext getInitialContext(JobDataMap jobDataMap) throws NamingException {
        String string;
        String string2;
        String string3;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(4);
        String string4 = jobDataMap.getString(INITIAL_CONTEXT_FACTORY);
        if (string4 != null) {
            hashtable.put(INITIAL_CONTEXT_FACTORY, string4);
        }
        if ((string3 = jobDataMap.getString(PROVIDER_URL)) != null) {
            hashtable.put(PROVIDER_URL, string3);
        }
        if ((string2 = jobDataMap.getString(PRINCIPAL)) != null) {
            hashtable.put(PRINCIPAL, string2);
        }
        if ((string = jobDataMap.getString(CREDENTIALS)) != null) {
            hashtable.put(CREDENTIALS, string);
        }
        if (hashtable.size() == 0) {
            return new InitialContext();
        }
        return new InitialContext(hashtable);
    }

    public static JmsMessageFactory getMessageFactory(String string) throws JmsJobException {
        try {
            Class<?> clazz = Class.forName(string);
            JmsMessageFactory jmsMessageFactory = (JmsMessageFactory)clazz.newInstance();
            return jmsMessageFactory;
        }
        catch (Exception exception) {
            throw new JmsJobException(exception.getMessage(), exception);
        }
    }

    public static boolean isDestinationSecure(JobDataMap jobDataMap) {
        return jobDataMap.getString(JMS_USER) != null && jobDataMap.getString(JMS_PASSWORD) != null;
    }

    public static boolean useTransaction(JobDataMap jobDataMap) {
        return jobDataMap.getBoolean(JMS_USE_TXN);
    }

    private JmsHelper() {
    }
}

