/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.jta;

import org.quartz.ExecuteInJTATransaction;
import org.quartz.Scheduler;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.core.JobRunShell;
import org.quartz.core.JobRunShellFactory;
import org.quartz.ee.jta.JTAJobRunShell;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.utils.ClassUtils;

public class JTAAnnotationAwareJobRunShellFactory
implements JobRunShellFactory {
    private Scheduler scheduler;

    @Override
    public void initialize(Scheduler scheduler) throws SchedulerConfigException {
        this.scheduler = scheduler;
    }

    @Override
    public JobRunShell createJobRunShell(TriggerFiredBundle triggerFiredBundle) throws SchedulerException {
        ExecuteInJTATransaction executeInJTATransaction = ClassUtils.getAnnotation(triggerFiredBundle.getJobDetail().getJobClass(), ExecuteInJTATransaction.class);
        if (executeInJTATransaction == null) {
            return new JobRunShell(this.scheduler, triggerFiredBundle);
        }
        int n = executeInJTATransaction.timeout();
        if (n >= 0) {
            return new JTAJobRunShell(this.scheduler, triggerFiredBundle, n);
        }
        return new JTAJobRunShell(this.scheduler, triggerFiredBundle);
    }
}

