/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core.jmx;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.quartz.JobKey;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.core.jmx.CronTriggerSupport;
import org.quartz.core.jmx.JobDataMapSupport;
import org.quartz.core.jmx.SimpleTriggerSupport;
import org.quartz.spi.MutableTrigger;
import org.quartz.spi.OperableTrigger;

public class TriggerSupport {
    private static final String COMPOSITE_TYPE_NAME = "Trigger";
    private static final String COMPOSITE_TYPE_DESCRIPTION = "Trigger Details";
    private static final String[] ITEM_NAMES = new String[]{"name", "group", "jobName", "jobGroup", "description", "jobDataMap", "calendarName", "fireInstanceId", "misfireInstruction", "priority", "startTime", "endTime", "nextFireTime", "previousFireTime", "finalFireTime"};
    private static final String[] ITEM_DESCRIPTIONS = new String[]{"name", "group", "jobName", "jobGroup", "description", "jobDataMap", "calendarName", "fireInstanceId", "misfireInstruction", "priority", "startTime", "endTime", "nextFireTime", "previousFireTime", "finalFireTime"};
    private static final OpenType[] ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, JobDataMapSupport.TABULAR_TYPE, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.DATE, SimpleType.DATE, SimpleType.DATE, SimpleType.DATE, SimpleType.DATE};
    private static final CompositeType COMPOSITE_TYPE;
    private static final String TABULAR_TYPE_NAME = "Trigger collection";
    private static final String TABULAR_TYPE_DESCRIPTION = "Trigger collection";
    private static final String[] INDEX_NAMES;
    private static final TabularType TABULAR_TYPE;

    public static String[] getItemNames() {
        return ITEM_NAMES;
    }

    public static String[] getItemDescriptions() {
        return ITEM_DESCRIPTIONS;
    }

    public static OpenType[] getItemTypes() {
        return ITEM_TYPES;
    }

    public String[] getIndexNames() {
        return INDEX_NAMES;
    }

    public static CompositeData toCompositeData(Trigger trigger) {
        try {
            return new CompositeDataSupport(COMPOSITE_TYPE, ITEM_NAMES, new Object[]{trigger.getKey().getName(), trigger.getKey().getGroup(), trigger.getJobKey().getName(), trigger.getJobKey().getGroup(), trigger.getDescription(), JobDataMapSupport.toTabularData(trigger.getJobDataMap()), trigger.getCalendarName(), ((OperableTrigger)trigger).getFireInstanceId(), trigger.getMisfireInstruction(), trigger.getPriority(), trigger.getStartTime(), trigger.getEndTime(), trigger.getNextFireTime(), trigger.getPreviousFireTime(), trigger.getFinalFireTime()});
        }
        catch (OpenDataException openDataException) {
            throw new RuntimeException(openDataException);
        }
    }

    public static TabularData toTabularData(List<? extends Trigger> list) {
        TabularDataSupport tabularDataSupport = new TabularDataSupport(TABULAR_TYPE);
        if (list != null) {
            ArrayList<CompositeData> arrayList = new ArrayList<CompositeData>();
            for (Trigger trigger : list) {
                arrayList.add(TriggerSupport.toCompositeData(trigger));
            }
            tabularDataSupport.putAll(arrayList.toArray(new CompositeData[arrayList.size()]));
        }
        return tabularDataSupport;
    }

    public static List<CompositeData> toCompositeList(List<? extends Trigger> list) {
        ArrayList<CompositeData> arrayList = new ArrayList<CompositeData>();
        for (Trigger trigger : list) {
            CompositeData compositeData = TriggerSupport.toCompositeData(trigger);
            if (compositeData == null) continue;
            arrayList.add(compositeData);
        }
        return arrayList;
    }

    public static void initializeTrigger(MutableTrigger mutableTrigger, CompositeData compositeData) {
        mutableTrigger.setDescription((String)compositeData.get("description"));
        mutableTrigger.setCalendarName((String)compositeData.get("calendarName"));
        if (compositeData.containsKey("priority")) {
            mutableTrigger.setPriority((Integer)compositeData.get("priority"));
        }
        if (compositeData.containsKey("jobDataMap")) {
            mutableTrigger.setJobDataMap(JobDataMapSupport.newJobDataMap((TabularData)compositeData.get("jobDataMap")));
        }
        Date date = compositeData.containsKey("startTime") ? (Date)compositeData.get("startTime") : new Date();
        mutableTrigger.setStartTime(date);
        mutableTrigger.setEndTime((Date)compositeData.get("endTime"));
        if (compositeData.containsKey("misfireInstruction")) {
            mutableTrigger.setMisfireInstruction((Integer)compositeData.get("misfireInstruction"));
        }
        mutableTrigger.setKey(new TriggerKey((String)compositeData.get("name"), (String)compositeData.get("group")));
        mutableTrigger.setJobKey(new JobKey((String)compositeData.get("jobName"), (String)compositeData.get("jobGroup")));
    }

    public static void initializeTrigger(MutableTrigger mutableTrigger, Map<String, Object> map) {
        Object object;
        mutableTrigger.setDescription((String)map.get("description"));
        mutableTrigger.setCalendarName((String)map.get("calendarName"));
        if (map.containsKey("priority")) {
            mutableTrigger.setPriority((Integer)map.get("priority"));
        }
        if (map.containsKey("jobDataMap")) {
            object = (Map)map.get("jobDataMap");
            mutableTrigger.setJobDataMap(JobDataMapSupport.newJobDataMap((Map<String, Object>)object));
        }
        object = map.containsKey("startTime") ? (Date)map.get("startTime") : new Date();
        mutableTrigger.setStartTime((Date)object);
        if (map.containsKey("endTime")) {
            mutableTrigger.setEndTime((Date)map.get("endTime"));
        }
        if (map.containsKey("misfireInstruction")) {
            mutableTrigger.setMisfireInstruction((Integer)map.get("misfireInstruction"));
        }
        mutableTrigger.setKey(new TriggerKey((String)map.get("name"), (String)map.get("group")));
        mutableTrigger.setJobKey(new JobKey((String)map.get("jobName"), (String)map.get("jobGroup")));
    }

    public static OperableTrigger newTrigger(CompositeData compositeData) throws ParseException {
        OperableTrigger operableTrigger = null;
        operableTrigger = compositeData.containsKey("cronExpression") ? CronTriggerSupport.newTrigger(compositeData) : SimpleTriggerSupport.newTrigger(compositeData);
        return operableTrigger;
    }

    public static OperableTrigger newTrigger(Map<String, Object> map) throws ParseException {
        OperableTrigger operableTrigger = null;
        operableTrigger = map.containsKey("cronExpression") ? CronTriggerSupport.newTrigger(map) : SimpleTriggerSupport.newTrigger(map);
        return operableTrigger;
    }

    static {
        INDEX_NAMES = new String[]{"name", "group"};
        try {
            COMPOSITE_TYPE = new CompositeType(COMPOSITE_TYPE_NAME, COMPOSITE_TYPE_DESCRIPTION, ITEM_NAMES, ITEM_DESCRIPTIONS, ITEM_TYPES);
            TABULAR_TYPE = new TabularType("Trigger collection", "Trigger collection", COMPOSITE_TYPE, INDEX_NAMES);
        }
        catch (OpenDataException openDataException) {
            throw new RuntimeException(openDataException);
        }
    }
}

