/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core.jmx;

import java.util.ArrayList;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.quartz.JobDataMap;

public class JobDataMapSupport {
    private static final String typeName = "JobDataMap";
    private static final String[] keyValue = new String[]{"key", "value"};
    private static final OpenType[] openTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
    private static final CompositeType rowType;
    public static final TabularType TABULAR_TYPE;

    public static JobDataMap newJobDataMap(TabularData tabularData) {
        JobDataMap jobDataMap = new JobDataMap();
        if (tabularData != null) {
            for (CompositeData compositeData : tabularData.values()) {
                jobDataMap.put((String)compositeData.get("key"), (String)compositeData.get("value"));
            }
        }
        return jobDataMap;
    }

    public static JobDataMap newJobDataMap(Map<String, Object> map) {
        JobDataMap jobDataMap = new JobDataMap();
        if (map != null) {
            for (String string : map.keySet()) {
                jobDataMap.put(string, map.get(string));
            }
        }
        return jobDataMap;
    }

    public static CompositeData toCompositeData(String string, String string2) {
        try {
            return new CompositeDataSupport(rowType, keyValue, new Object[]{string, string2});
        }
        catch (OpenDataException openDataException) {
            throw new RuntimeException(openDataException);
        }
    }

    public static TabularData toTabularData(JobDataMap jobDataMap) {
        TabularDataSupport tabularDataSupport = new TabularDataSupport(TABULAR_TYPE);
        ArrayList<CompositeData> arrayList = new ArrayList<CompositeData>();
        for (String string : jobDataMap.keySet()) {
            arrayList.add(JobDataMapSupport.toCompositeData(string, String.valueOf(jobDataMap.get(string))));
        }
        tabularDataSupport.putAll(arrayList.toArray(new CompositeData[arrayList.size()]));
        return tabularDataSupport;
    }

    static {
        try {
            rowType = new CompositeType(typeName, typeName, keyValue, keyValue, openTypes);
            TABULAR_TYPE = new TabularType(typeName, typeName, rowType, new String[]{"key"});
        }
        catch (OpenDataException openDataException) {
            throw new RuntimeException(openDataException);
        }
    }
}

