/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.reflection.java.generics;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.hibernate.annotations.common.reflection.java.generics.ApproximatingTypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.CompoundTypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.IdentityTypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.SimpleTypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.TypeSwitch;

public class TypeEnvironmentFactory {
    public TypeEnvironment getEnvironment(Class clazz) {
        if (clazz == null) {
            return IdentityTypeEnvironment.INSTANCE;
        }
        return this.createEnvironment(clazz);
    }

    public TypeEnvironment getEnvironment(Type type) {
        if (type == null) {
            return IdentityTypeEnvironment.INSTANCE;
        }
        return this.createEnvironment(type);
    }

    public TypeEnvironment getEnvironment(Type type, TypeEnvironment typeEnvironment) {
        return CompoundTypeEnvironment.create(this.getEnvironment(type), typeEnvironment);
    }

    public TypeEnvironment toApproximatingEnvironment(TypeEnvironment typeEnvironment) {
        return CompoundTypeEnvironment.create(new ApproximatingTypeEnvironment(), typeEnvironment);
    }

    private TypeEnvironment createEnvironment(Type type) {
        return (TypeEnvironment)new TypeSwitch<TypeEnvironment>(){

            @Override
            public TypeEnvironment caseClass(Class clazz) {
                return CompoundTypeEnvironment.create(TypeEnvironmentFactory.this.createSuperTypeEnvironment(clazz), TypeEnvironmentFactory.this.getEnvironment(clazz.getSuperclass()));
            }

            @Override
            public TypeEnvironment caseParameterizedType(ParameterizedType parameterizedType) {
                return TypeEnvironmentFactory.this.createEnvironment(parameterizedType);
            }

            @Override
            public TypeEnvironment defaultCase(Type type) {
                throw new IllegalArgumentException("Invalid type for generating environment: " + type);
            }
        }.doSwitch(type);
    }

    private TypeEnvironment createSuperTypeEnvironment(Class clazz) {
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 == null) {
            return IdentityTypeEnvironment.INSTANCE;
        }
        Type[] typeArray = clazz2.getTypeParameters();
        Type type = clazz.getGenericSuperclass();
        if (type instanceof Class) {
            return IdentityTypeEnvironment.INSTANCE;
        }
        if (type instanceof ParameterizedType) {
            Type[] typeArray2 = ((ParameterizedType)type).getActualTypeArguments();
            return new SimpleTypeEnvironment(typeArray, typeArray2);
        }
        throw new AssertionError((Object)"Should be unreachable");
    }

    private TypeEnvironment createEnvironment(ParameterizedType parameterizedType) {
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        Type type = parameterizedType.getRawType();
        if (type instanceof Class) {
            Type[] typeArray2 = ((Class)type).getTypeParameters();
            return new SimpleTypeEnvironment(typeArray2, typeArray);
        }
        return IdentityTypeEnvironment.INSTANCE;
    }
}

