/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations;

import org.hibernate.cache.access.AccessType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CacheConcurrencyStrategy {
    NONE(null),
    READ_ONLY(AccessType.READ_ONLY),
    NONSTRICT_READ_WRITE(AccessType.NONSTRICT_READ_WRITE),
    READ_WRITE(AccessType.READ_WRITE),
    TRANSACTIONAL(AccessType.TRANSACTIONAL);

    private final AccessType accessType;

    private CacheConcurrencyStrategy(AccessType accessType) {
        this.accessType = accessType;
    }

    public static CacheConcurrencyStrategy fromAccessType(AccessType accessType) {
        String string;
        String string2 = string = accessType == null ? null : accessType.getName();
        if (AccessType.READ_ONLY.getName().equals(string)) {
            return READ_ONLY;
        }
        if (AccessType.READ_WRITE.getName().equals(string)) {
            return READ_WRITE;
        }
        if (AccessType.NONSTRICT_READ_WRITE.getName().equals(string)) {
            return NONSTRICT_READ_WRITE;
        }
        if (AccessType.TRANSACTIONAL.getName().equals(string)) {
            return TRANSACTIONAL;
        }
        return NONE;
    }

    public static CacheConcurrencyStrategy parse(String string) {
        if (CacheConcurrencyStrategy.READ_ONLY.accessType.getName().equalsIgnoreCase(string)) {
            return READ_ONLY;
        }
        if (CacheConcurrencyStrategy.READ_WRITE.accessType.getName().equalsIgnoreCase(string)) {
            return READ_WRITE;
        }
        if (CacheConcurrencyStrategy.NONSTRICT_READ_WRITE.accessType.getName().equalsIgnoreCase(string)) {
            return NONSTRICT_READ_WRITE;
        }
        if (CacheConcurrencyStrategy.TRANSACTIONAL.accessType.getName().equalsIgnoreCase(string)) {
            return TRANSACTIONAL;
        }
        if ("none".equalsIgnoreCase(string)) {
            return NONE;
        }
        return null;
    }

    public AccessType toAccessType() {
        return this.accessType;
    }
}

