/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.scopes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.DeprecationWarning;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.common.WebSocketSessionListener;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

public class SimpleContainerScope
extends ContainerLifeCycle
implements WebSocketContainerScope {
    private final ByteBufferPool bufferPool;
    private final DecoratedObjectFactory objectFactory;
    private final WebSocketPolicy policy;
    private final Executor executor;
    private final Logger logger;
    private SslContextFactory sslContextFactory;
    private List<WebSocketSessionListener> sessionListeners = new ArrayList<WebSocketSessionListener>();

    public SimpleContainerScope(WebSocketPolicy webSocketPolicy) {
        this(webSocketPolicy, new MappedByteBufferPool());
    }

    public SimpleContainerScope(WebSocketPolicy webSocketPolicy, ByteBufferPool byteBufferPool) {
        this(webSocketPolicy, byteBufferPool, new DecoratedObjectFactory());
    }

    public SimpleContainerScope(WebSocketPolicy webSocketPolicy, ByteBufferPool byteBufferPool, DecoratedObjectFactory decoratedObjectFactory) {
        this(webSocketPolicy, byteBufferPool, null, decoratedObjectFactory);
    }

    public SimpleContainerScope(WebSocketPolicy webSocketPolicy, ByteBufferPool byteBufferPool, Executor executor, DecoratedObjectFactory decoratedObjectFactory) {
        this(webSocketPolicy, byteBufferPool, executor, null, decoratedObjectFactory);
    }

    public SimpleContainerScope(WebSocketPolicy webSocketPolicy, ByteBufferPool byteBufferPool, Executor executor, SslContextFactory sslContextFactory, DecoratedObjectFactory decoratedObjectFactory) {
        this.logger = Log.getLogger(this.getClass());
        this.policy = webSocketPolicy;
        this.bufferPool = byteBufferPool;
        if (decoratedObjectFactory == null) {
            this.objectFactory = new DecoratedObjectFactory();
            this.objectFactory.addDecorator(new DeprecationWarning());
        } else {
            this.objectFactory = decoratedObjectFactory;
        }
        if (sslContextFactory == null) {
            if (webSocketPolicy.getBehavior() == WebSocketBehavior.CLIENT) {
                this.sslContextFactory = new SslContextFactory.Client();
            } else if (webSocketPolicy.getBehavior() == WebSocketBehavior.SERVER) {
                this.sslContextFactory = new SslContextFactory.Server();
            }
        } else {
            this.sslContextFactory = sslContextFactory;
        }
        if (executor == null) {
            QueuedThreadPool queuedThreadPool = new QueuedThreadPool();
            String string = "Container";
            if (webSocketPolicy != null) {
                if (webSocketPolicy.getBehavior() == WebSocketBehavior.CLIENT) {
                    string = "Client";
                } else if (webSocketPolicy.getBehavior() == WebSocketBehavior.SERVER) {
                    string = "Server";
                }
            }
            String string2 = String.format("WebSocket%s@%s", string, this.hashCode());
            queuedThreadPool.setName(string2);
            queuedThreadPool.setDaemon(true);
            this.executor = queuedThreadPool;
            this.addBean(this.executor);
        } else {
            this.executor = executor;
        }
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public DecoratedObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    public void setSslContextFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
    }

    @Override
    public void addSessionListener(WebSocketSessionListener webSocketSessionListener) {
        this.sessionListeners.add(webSocketSessionListener);
    }

    @Override
    public void removeSessionListener(WebSocketSessionListener webSocketSessionListener) {
        this.sessionListeners.remove(webSocketSessionListener);
    }

    @Override
    public Collection<WebSocketSessionListener> getSessionListeners() {
        return this.sessionListeners;
    }
}

