/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.BlockingWriteCallback;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.frames.BinaryFrame;

public class MessageOutputStream
extends OutputStream {
    private static final Logger LOG = Log.getLogger(MessageOutputStream.class);
    private final OutgoingFrames outgoing;
    private final ByteBufferPool bufferPool;
    private final BlockingWriteCallback blocker;
    private long frameCount;
    private BinaryFrame frame;
    private ByteBuffer buffer;
    private WriteCallback callback;
    private boolean closed;

    public MessageOutputStream(WebSocketSession webSocketSession) {
        this(webSocketSession.getOutgoingHandler(), webSocketSession.getPolicy().getMaxBinaryMessageBufferSize(), webSocketSession.getBufferPool());
    }

    public MessageOutputStream(OutgoingFrames outgoingFrames, int n, ByteBufferPool byteBufferPool) {
        this.outgoing = outgoingFrames;
        this.bufferPool = byteBufferPool;
        this.blocker = new BlockingWriteCallback();
        this.buffer = byteBufferPool.acquire(n, true);
        BufferUtil.flipToFill(this.buffer);
        this.frame = new BinaryFrame();
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.send(byArray, n, n2);
        }
        catch (Throwable throwable) {
            this.notifyFailure(throwable);
            throw throwable;
        }
    }

    @Override
    public void write(int n) throws IOException {
        try {
            this.send(new byte[]{(byte)n}, 0, 1);
        }
        catch (Throwable throwable) {
            this.notifyFailure(throwable);
            throw throwable;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.flush(false);
        }
        catch (Throwable throwable) {
            this.notifyFailure(throwable);
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush(true);
            this.bufferPool.release(this.buffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stream closed, {} frames sent", this.frameCount);
            }
            this.notifySuccess();
        }
        catch (Throwable throwable) {
            this.notifyFailure(throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(boolean bl) throws IOException {
        MessageOutputStream messageOutputStream = this;
        synchronized (messageOutputStream) {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            this.closed = bl;
            BufferUtil.flipToFlush(this.buffer, 0);
            this.frame.setPayload(this.buffer);
            this.frame.setFin(bl);
            try (BlockingWriteCallback.WriteBlocker writeBlocker = this.blocker.acquireWriteBlocker();){
                this.outgoing.outgoingFrame(this.frame, writeBlocker, BatchMode.OFF);
                writeBlocker.block();
            }
            ++this.frameCount;
            this.frame.setIsContinuation();
            BufferUtil.flipToFill(this.buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(byte[] byArray, int n, int n2) throws IOException {
        MessageOutputStream messageOutputStream = this;
        synchronized (messageOutputStream) {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            while (n2 > 0) {
                int n3 = this.buffer.remaining();
                int n4 = Math.min(n3, n2);
                this.buffer.put(byArray, n, n4);
                n += n4;
                if ((n2 -= n4) <= 0) continue;
                this.flush(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(WriteCallback writeCallback) {
        MessageOutputStream messageOutputStream = this;
        synchronized (messageOutputStream) {
            this.callback = writeCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySuccess() {
        WriteCallback writeCallback;
        MessageOutputStream messageOutputStream = this;
        synchronized (messageOutputStream) {
            writeCallback = this.callback;
        }
        if (writeCallback != null) {
            writeCallback.writeSuccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFailure(Throwable throwable) {
        WriteCallback writeCallback;
        MessageOutputStream messageOutputStream = this;
        synchronized (messageOutputStream) {
            writeCallback = this.callback;
        }
        if (writeCallback != null) {
            writeCallback.writeFailed(throwable);
        }
    }
}

