/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.fragment;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.frames.DataFrame;

public class FragmentExtension
extends AbstractExtension {
    private static final Logger LOG = Log.getLogger(FragmentExtension.class);
    private final Queue<FrameEntry> entries = new ArrayDeque<FrameEntry>();
    private final IteratingCallback flusher = new Flusher();
    private int maxLength;

    @Override
    public String getName() {
        return "fragment";
    }

    @Override
    public void incomingFrame(Frame frame) {
        this.nextIncomingFrame(frame);
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
        int n;
        ByteBuffer byteBuffer = frame.getPayload();
        int n2 = n = byteBuffer != null ? byteBuffer.remaining() : 0;
        if (OpCode.isControlFrame(frame.getOpCode()) || this.maxLength <= 0 || n <= this.maxLength) {
            this.nextOutgoingFrame(frame, writeCallback, batchMode);
            return;
        }
        FrameEntry frameEntry = new FrameEntry(frame, writeCallback, batchMode);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queuing {}", frameEntry);
        }
        this.offerEntry(frameEntry);
        this.flusher.iterate();
    }

    @Override
    public void setConfig(ExtensionConfig extensionConfig) {
        super.setConfig(extensionConfig);
        this.maxLength = extensionConfig.getParameter("maxLength", -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerEntry(FrameEntry frameEntry) {
        FragmentExtension fragmentExtension = this;
        synchronized (fragmentExtension) {
            this.entries.offer(frameEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameEntry pollEntry() {
        FragmentExtension fragmentExtension = this;
        synchronized (fragmentExtension) {
            return this.entries.poll();
        }
    }

    private class Flusher
    extends IteratingCallback
    implements WriteCallback {
        private FrameEntry current;
        private boolean finished = true;

        private Flusher() {
        }

        @Override
        protected IteratingCallback.Action process() {
            if (this.finished) {
                this.current = FragmentExtension.this.pollEntry();
                if (this.current == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Processing IDLE", this.current);
                    }
                    return IteratingCallback.Action.IDLE;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Processing {}", this.current);
                }
                this.fragment(this.current, true);
            } else {
                this.fragment(this.current, false);
            }
            return IteratingCallback.Action.SCHEDULED;
        }

        private void fragment(FrameEntry frameEntry, boolean bl) {
            Frame frame = frameEntry.frame;
            ByteBuffer byteBuffer = frame.getPayload();
            int n = byteBuffer.remaining();
            int n2 = Math.min(n, FragmentExtension.this.maxLength);
            this.finished = n2 == n;
            boolean bl2 = frame.getType().isContinuation() || !bl;
            DataFrame dataFrame = new DataFrame(frame, bl2);
            boolean bl3 = frame.isFin() && this.finished;
            dataFrame.setFin(bl3);
            int n3 = byteBuffer.limit();
            int n4 = byteBuffer.position() + n2;
            byteBuffer.limit(n4);
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer.limit(n3);
            dataFrame.setPayload(byteBuffer2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fragmented {}->{}", frame, dataFrame);
            }
            byteBuffer.position(n4);
            FragmentExtension.this.nextOutgoingFrame(dataFrame, this, frameEntry.batchMode);
        }

        @Override
        protected void onCompleteSuccess() {
        }

        @Override
        protected void onCompleteFailure(Throwable throwable) {
        }

        @Override
        public void writeSuccess() {
            if (this.finished) {
                this.notifyCallbackSuccess(this.current.callback);
            }
            this.succeeded();
        }

        @Override
        public void writeFailed(Throwable throwable) {
            this.notifyCallbackFailure(this.current.callback, throwable);
            this.succeeded();
        }

        private void notifyCallbackSuccess(WriteCallback writeCallback) {
            block3: {
                try {
                    if (writeCallback != null) {
                        writeCallback.writeSuccess();
                    }
                }
                catch (Throwable throwable) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Exception while notifying success of callback " + writeCallback, throwable);
                }
            }
        }

        private void notifyCallbackFailure(WriteCallback writeCallback, Throwable throwable) {
            block3: {
                try {
                    if (writeCallback != null) {
                        writeCallback.writeFailed(throwable);
                    }
                }
                catch (Throwable throwable2) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Exception while notifying failure of callback " + writeCallback, throwable2);
                }
            }
        }
    }

    private static class FrameEntry {
        private final Frame frame;
        private final WriteCallback callback;
        private final BatchMode batchMode;

        private FrameEntry(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
            this.frame = frame;
            this.callback = writeCallback;
            this.batchMode = batchMode;
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

