/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferAccumulator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.MessageTooLargeException;

@Deprecated
public class ByteAccumulator
implements AutoCloseable {
    private static final int MIN_SPACE = 8;
    private final ByteBufferAccumulator accumulator;
    private final int maxSize;
    private int length = 0;

    public ByteAccumulator(int n) {
        this(n, null);
    }

    public ByteAccumulator(int n, ByteBufferPool byteBufferPool) {
        this.maxSize = n;
        this.accumulator = new ByteBufferAccumulator(byteBufferPool, false);
    }

    public int getLength() {
        return this.length;
    }

    public ByteBuffer ensureBuffer(int n) {
        return this.accumulator.ensureBuffer(8, n);
    }

    public void addLength(int n) {
        this.length += n;
        if (this.length > this.maxSize) {
            String string = String.format("Resulting message size [%d] is too large for configured max of [%d]", this.length, this.maxSize);
            throw new MessageTooLargeException(string);
        }
    }

    public void copyChunk(byte[] byArray, int n, int n2) {
        this.copyChunk(BufferUtil.toBuffer(byArray, n, n2));
    }

    public void copyChunk(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (this.length + n > this.maxSize) {
            String string = String.format("Resulting message size [%d] is too large for configured max of [%d]", this.length + n, this.maxSize);
            throw new MessageTooLargeException(string);
        }
        this.length += n;
        this.accumulator.copyBuffer(byteBuffer);
    }

    public void transferTo(ByteBuffer byteBuffer) {
        BufferUtil.flipToFlush(byteBuffer, 0);
        int n = BufferUtil.space(byteBuffer);
        if (n < this.length) {
            String string = String.format("Not enough space in ByteBuffer remaining [%d] for accumulated buffers length [%d]", n, this.length);
            throw new IllegalArgumentException(string);
        }
        this.accumulator.writeTo(byteBuffer);
        this.close();
    }

    @Override
    public void close() {
        this.accumulator.close();
    }
}

