/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.websocket.api.BadPayloadException;
import org.eclipse.jetty.websocket.api.ProtocolException;
import org.eclipse.jetty.websocket.api.StatusCode;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;

public class CloseInfo {
    private int statusCode = 0;
    private byte[] reasonBytes;

    public CloseInfo() {
        this(1005, null);
    }

    public CloseInfo(ByteBuffer byteBuffer, boolean bl) {
        this.statusCode = 1005;
        if (byteBuffer == null || byteBuffer.remaining() == 0) {
            return;
        }
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        if (byteBuffer2.remaining() == 1 && bl) {
            throw new ProtocolException("Invalid 1 byte payload");
        }
        if (byteBuffer2.remaining() >= 2) {
            this.statusCode = 0;
            this.statusCode |= (byteBuffer2.get() & 0xFF) << 8;
            this.statusCode |= byteBuffer2.get() & 0xFF;
            if (bl) {
                this.assertValidStatusCode(this.statusCode);
            }
            if (byteBuffer2.remaining() > 0) {
                int n = Math.min(byteBuffer2.remaining(), 123);
                this.reasonBytes = new byte[n];
                byteBuffer2.get(this.reasonBytes, 0, n);
                if (bl) {
                    try {
                        Utf8StringBuilder utf8StringBuilder = new Utf8StringBuilder();
                        utf8StringBuilder.append(this.reasonBytes, 0, this.reasonBytes.length);
                    }
                    catch (Utf8Appendable.NotUtf8Exception notUtf8Exception) {
                        throw new BadPayloadException("Invalid Close Reason", (Throwable)notUtf8Exception);
                    }
                }
            }
        }
    }

    public CloseInfo(Frame frame) {
        this(frame.getPayload(), false);
    }

    public CloseInfo(Frame frame, boolean bl) {
        this(frame.getPayload(), bl);
    }

    public CloseInfo(int n) {
        this(n, null);
    }

    public CloseInfo(int n, String string) {
        this.statusCode = n;
        if (string != null) {
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            if (byArray.length > 123) {
                this.reasonBytes = new byte[123];
                System.arraycopy(byArray, 0, this.reasonBytes, 0, 123);
            } else {
                this.reasonBytes = byArray;
            }
        }
    }

    private void assertValidStatusCode(int n) {
        if (n <= 999 || n >= 5000) {
            throw new ProtocolException("Out of range close status code: " + n);
        }
        if (n == 1006 || n == 1005 || n == 1015) {
            throw new ProtocolException("Frame forbidden close status code: " + n);
        }
        if (n >= 1000 && n <= 2999 && !StatusCode.isTransmittable(n)) {
            throw new ProtocolException("RFC6455 and IANA Undefined close status code: " + n);
        }
    }

    private ByteBuffer asByteBuffer() {
        boolean bl;
        if (this.statusCode == 1006 || this.statusCode == 1005 || this.statusCode == -1) {
            return null;
        }
        int n = 2;
        boolean bl2 = bl = this.reasonBytes != null && this.reasonBytes.length > 0;
        if (bl) {
            n += this.reasonBytes.length;
        }
        ByteBuffer byteBuffer = BufferUtil.allocate(n);
        BufferUtil.flipToFill(byteBuffer);
        byteBuffer.put((byte)(this.statusCode >>> 8 & 0xFF));
        byteBuffer.put((byte)(this.statusCode >>> 0 & 0xFF));
        if (bl) {
            byteBuffer.put(this.reasonBytes, 0, this.reasonBytes.length);
        }
        BufferUtil.flipToFlush(byteBuffer, 0);
        return byteBuffer;
    }

    public CloseFrame asFrame() {
        CloseFrame closeFrame = new CloseFrame();
        closeFrame.setFin(true);
        if (this.statusCode != 1006 && this.statusCode != 1005 && this.statusCode != 1015) {
            this.assertValidStatusCode(this.statusCode);
            closeFrame.setPayload(this.asByteBuffer());
        }
        return closeFrame;
    }

    public String getReason() {
        if (this.reasonBytes == null) {
            return null;
        }
        return new String(this.reasonBytes, StandardCharsets.UTF_8);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean isHarsh() {
        return this.statusCode != 1000 && this.statusCode != 1005;
    }

    public boolean isAbnormal() {
        return this.statusCode != 1000;
    }

    public String toString() {
        return String.format("CloseInfo[code=%d,reason=%s]", this.statusCode, this.getReason());
    }
}

