/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread.strategy;

import java.io.Closeable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.TryExecutor;

@ManagedObject(value="eat what you kill execution strategy")
public class EatWhatYouKill
extends ContainerLifeCycle
implements ExecutionStrategy,
Runnable {
    private static final Logger LOG = Log.getLogger(EatWhatYouKill.class);
    private final LongAdder _pcMode = new LongAdder();
    private final LongAdder _picMode = new LongAdder();
    private final LongAdder _pecMode = new LongAdder();
    private final LongAdder _epcMode = new LongAdder();
    private final ExecutionStrategy.Producer _producer;
    private final Executor _executor;
    private final TryExecutor _tryExecutor;
    private State _state = State.IDLE;
    private boolean _pending;

    public EatWhatYouKill(ExecutionStrategy.Producer producer, Executor executor) {
        this._producer = producer;
        this._executor = executor;
        this._tryExecutor = TryExecutor.asTryExecutor(executor);
        this.addBean(this._producer);
        this.addBean(this._tryExecutor);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} created", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch() {
        boolean bl = false;
        EatWhatYouKill eatWhatYouKill = this;
        synchronized (eatWhatYouKill) {
            switch (this._state) {
                case IDLE: {
                    if (this._pending) break;
                    this._pending = true;
                    bl = true;
                    break;
                }
                case PRODUCING: {
                    this._state = State.REPRODUCING;
                    break;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} dispatch {}", this, bl);
        }
        if (bl) {
            this._executor.execute(this);
        }
    }

    @Override
    public void run() {
        this.tryProduce(true);
    }

    @Override
    public void produce() {
        this.tryProduce(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryProduce(boolean bl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} tryProduce {}", this, bl);
        }
        EatWhatYouKill eatWhatYouKill = this;
        synchronized (eatWhatYouKill) {
            if (bl) {
                this._pending = false;
            }
            switch (this._state) {
                case IDLE: {
                    this._state = State.PRODUCING;
                    break;
                }
                case PRODUCING: {
                    this._state = State.REPRODUCING;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        boolean bl2 = Invocable.isNonBlockingInvocation();
        while (this.isRunning()) {
            try {
                if (this.doProduce(bl2)) continue;
                return;
            }
            catch (Throwable throwable) {
                LOG.warn(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doProduce(boolean bl) {
        EatWhatYouKill eatWhatYouKill;
        Mode mode;
        Runnable runnable = this.produceTask();
        if (runnable == null) {
            EatWhatYouKill eatWhatYouKill2 = this;
            synchronized (eatWhatYouKill2) {
                switch (this._state) {
                    case PRODUCING: {
                        this._state = State.IDLE;
                        return false;
                    }
                    case REPRODUCING: {
                        this._state = State.PRODUCING;
                        return true;
                    }
                }
                throw new IllegalStateException(this.toStringLocked());
            }
        }
        if (bl) {
            switch (Invocable.getInvocationType(runnable)) {
                case NON_BLOCKING: {
                    mode = Mode.PRODUCE_CONSUME;
                    break;
                }
                case EITHER: {
                    mode = Mode.PRODUCE_INVOKE_CONSUME;
                    break;
                }
                default: {
                    mode = Mode.PRODUCE_EXECUTE_CONSUME;
                    break;
                }
            }
        } else {
            switch (Invocable.getInvocationType(runnable)) {
                case NON_BLOCKING: {
                    mode = Mode.PRODUCE_CONSUME;
                    break;
                }
                case BLOCKING: {
                    eatWhatYouKill = this;
                    synchronized (eatWhatYouKill) {
                        if (this._pending) {
                            this._state = State.IDLE;
                            mode = Mode.EXECUTE_PRODUCE_CONSUME;
                        } else if (this._tryExecutor.tryExecute(this)) {
                            this._pending = true;
                            this._state = State.IDLE;
                            mode = Mode.EXECUTE_PRODUCE_CONSUME;
                        } else {
                            mode = Mode.PRODUCE_EXECUTE_CONSUME;
                        }
                        break;
                    }
                }
                case EITHER: {
                    eatWhatYouKill = this;
                    synchronized (eatWhatYouKill) {
                        if (this._pending) {
                            this._state = State.IDLE;
                            mode = Mode.EXECUTE_PRODUCE_CONSUME;
                        } else if (this._tryExecutor.tryExecute(this)) {
                            this._pending = true;
                            this._state = State.IDLE;
                            mode = Mode.EXECUTE_PRODUCE_CONSUME;
                        } else {
                            mode = Mode.PRODUCE_INVOKE_CONSUME;
                        }
                        break;
                    }
                }
                default: {
                    throw new IllegalStateException(this.toString());
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} m={} t={}/{}", new Object[]{this, mode, runnable, Invocable.getInvocationType(runnable)});
        }
        switch (mode) {
            case PRODUCE_CONSUME: {
                this._pcMode.increment();
                this.runTask(runnable);
                return true;
            }
            case PRODUCE_INVOKE_CONSUME: {
                this._picMode.increment();
                this.invokeTask(runnable);
                return true;
            }
            case PRODUCE_EXECUTE_CONSUME: {
                this._pecMode.increment();
                this.execute(runnable);
                return true;
            }
            case EXECUTE_PRODUCE_CONSUME: {
                this._epcMode.increment();
                this.runTask(runnable);
                eatWhatYouKill = this;
                synchronized (eatWhatYouKill) {
                    if (this._state == State.IDLE) {
                        this._state = State.PRODUCING;
                        return true;
                    }
                }
                return false;
            }
        }
        throw new IllegalStateException(this.toString());
    }

    private void runTask(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            LOG.warn(throwable);
        }
    }

    private void invokeTask(Runnable runnable) {
        try {
            Invocable.invokeNonBlocking(runnable);
        }
        catch (Throwable throwable) {
            LOG.warn(throwable);
        }
    }

    private Runnable produceTask() {
        try {
            return this._producer.produce();
        }
        catch (Throwable throwable) {
            LOG.warn(throwable);
            return null;
        }
    }

    private void execute(Runnable runnable) {
        block6: {
            try {
                this._executor.execute(runnable);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                if (this.isRunning()) {
                    LOG.warn(rejectedExecutionException);
                } else {
                    LOG.ignore(rejectedExecutionException);
                }
                if (!(runnable instanceof Closeable)) break block6;
                try {
                    ((Closeable)((Object)runnable)).close();
                }
                catch (Throwable throwable) {
                    LOG.ignore(throwable);
                }
            }
        }
    }

    @ManagedAttribute(value="number of tasks consumed with PC mode", readonly=true)
    public long getPCTasksConsumed() {
        return this._pcMode.longValue();
    }

    @ManagedAttribute(value="number of tasks executed with PIC mode", readonly=true)
    public long getPICTasksExecuted() {
        return this._picMode.longValue();
    }

    @ManagedAttribute(value="number of tasks executed with PEC mode", readonly=true)
    public long getPECTasksExecuted() {
        return this._pecMode.longValue();
    }

    @ManagedAttribute(value="number of tasks consumed with EPC mode", readonly=true)
    public long getEPCTasksConsumed() {
        return this._epcMode.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(value="whether this execution strategy is idle", readonly=true)
    public boolean isIdle() {
        EatWhatYouKill eatWhatYouKill = this;
        synchronized (eatWhatYouKill) {
            return this._state == State.IDLE;
        }
    }

    @ManagedOperation(value="resets the task counts", impact="ACTION")
    public void reset() {
        this._pcMode.reset();
        this._epcMode.reset();
        this._pecMode.reset();
        this._picMode.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        EatWhatYouKill eatWhatYouKill = this;
        synchronized (eatWhatYouKill) {
            return this.toStringLocked();
        }
    }

    public String toStringLocked() {
        StringBuilder stringBuilder = new StringBuilder();
        this.getString(stringBuilder);
        this.getState(stringBuilder);
        return stringBuilder.toString();
    }

    private void getString(StringBuilder stringBuilder) {
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append('/');
        stringBuilder.append(this._producer);
        stringBuilder.append('/');
    }

    private void getState(StringBuilder stringBuilder) {
        stringBuilder.append((Object)this._state);
        stringBuilder.append("/p=");
        stringBuilder.append(this._pending);
        stringBuilder.append('/');
        stringBuilder.append(this._tryExecutor);
        stringBuilder.append("[pc=");
        stringBuilder.append(this.getPCTasksConsumed());
        stringBuilder.append(",pic=");
        stringBuilder.append(this.getPICTasksExecuted());
        stringBuilder.append(",pec=");
        stringBuilder.append(this.getPECTasksExecuted());
        stringBuilder.append(",epc=");
        stringBuilder.append(this.getEPCTasksConsumed());
        stringBuilder.append("]");
        stringBuilder.append("@");
        stringBuilder.append(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now()));
    }

    private static enum Mode {
        PRODUCE_CONSUME,
        PRODUCE_INVOKE_CONSUME,
        PRODUCE_EXECUTE_CONSUME,
        EXECUTE_PRODUCE_CONSUME;

    }

    private static enum State {
        IDLE,
        PRODUCING,
        REPRODUCING;

    }
}

