/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.io.Closeable;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadPool;

@ManagedObject
public class ThreadPoolBudget {
    private static final Logger LOG = Log.getLogger(ThreadPoolBudget.class);
    private static final Lease NOOP_LEASE = new Lease(){

        @Override
        public void close() {
        }

        @Override
        public int getThreads() {
            return 0;
        }
    };
    private final Set<Leased> leases = new CopyOnWriteArraySet<Leased>();
    private final AtomicBoolean warned = new AtomicBoolean();
    private final ThreadPool.SizedThreadPool pool;
    private final int warnAt;

    public ThreadPoolBudget(ThreadPool.SizedThreadPool sizedThreadPool) {
        this.pool = sizedThreadPool;
        this.warnAt = -1;
    }

    @Deprecated
    public ThreadPoolBudget(ThreadPool.SizedThreadPool sizedThreadPool, int n) {
        this.pool = sizedThreadPool;
        this.warnAt = n;
    }

    public ThreadPool.SizedThreadPool getSizedThreadPool() {
        return this.pool;
    }

    @ManagedAttribute(value="the number of threads leased to components")
    public int getLeasedThreads() {
        return this.leases.stream().mapToInt(Lease::getThreads).sum();
    }

    public void reset() {
        this.leases.clear();
        this.warned.set(false);
    }

    public Lease leaseTo(Object object, int n) {
        Leased leased = new Leased(object, n);
        this.leases.add(leased);
        try {
            this.check(this.pool.getMaxThreads());
            return leased;
        }
        catch (IllegalStateException illegalStateException) {
            leased.close();
            throw illegalStateException;
        }
    }

    public boolean check(int n) throws IllegalStateException {
        int n2 = this.getLeasedThreads();
        int n3 = n - n2;
        if (n3 <= 0) {
            this.printInfoOnLeases();
            throw new IllegalStateException(String.format("Insufficient configured threads: required=%d < max=%d for %s", n2, n, this.pool));
        }
        if (n3 < this.warnAt) {
            if (this.warned.compareAndSet(false, true)) {
                this.printInfoOnLeases();
                LOG.info("Low configured threads: (max={} - required={})={} < warnAt={} for {}", n, n2, n3, this.warnAt, this.pool);
            }
            return false;
        }
        return true;
    }

    private void printInfoOnLeases() {
        this.leases.forEach(leased -> LOG.info("{} requires {} threads from {}", ((Leased)leased).leasee, leased.getThreads(), this.pool));
    }

    public static Lease leaseFrom(Executor executor, Object object, int n) {
        ThreadPoolBudget threadPoolBudget;
        if (executor instanceof ThreadPool.SizedThreadPool && (threadPoolBudget = ((ThreadPool.SizedThreadPool)executor).getThreadPoolBudget()) != null) {
            return threadPoolBudget.leaseTo(object, n);
        }
        return NOOP_LEASE;
    }

    public class Leased
    implements Lease {
        private final Object leasee;
        private final int threads;

        private Leased(Object object, int n) {
            this.leasee = object;
            this.threads = n;
        }

        @Override
        public int getThreads() {
            return this.threads;
        }

        @Override
        public void close() {
            ThreadPoolBudget.this.leases.remove(this);
            ThreadPoolBudget.this.warned.set(false);
        }
    }

    public static interface Lease
    extends Closeable {
        public int getThreads();
    }
}

