/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.thread.Scheduler;

@ManagedObject
public class ScheduledExecutorScheduler
extends AbstractLifeCycle
implements Scheduler,
Dumpable {
    private final String name;
    private final boolean daemon;
    private final ClassLoader classloader;
    private final ThreadGroup threadGroup;
    private final int threads;
    private final AtomicInteger count = new AtomicInteger();
    private volatile ScheduledThreadPoolExecutor scheduler;
    private volatile Thread thread;

    public ScheduledExecutorScheduler() {
        this(null, false);
    }

    public ScheduledExecutorScheduler(String string, boolean bl) {
        this(string, bl, null);
    }

    public ScheduledExecutorScheduler(@Name(value="name") String string, @Name(value="daemon") boolean bl, @Name(value="threads") int n) {
        this(string, bl, null, null, n);
    }

    public ScheduledExecutorScheduler(String string, boolean bl, ClassLoader classLoader) {
        this(string, bl, classLoader, null);
    }

    public ScheduledExecutorScheduler(String string, boolean bl, ClassLoader classLoader, ThreadGroup threadGroup) {
        this(string, bl, classLoader, threadGroup, -1);
    }

    public ScheduledExecutorScheduler(@Name(value="name") String string, @Name(value="daemon") boolean bl, @Name(value="classLoader") ClassLoader classLoader, @Name(value="threadGroup") ThreadGroup threadGroup, @Name(value="threads") int n) {
        this.name = StringUtil.isBlank(string) ? "Scheduler-" + this.hashCode() : string;
        this.daemon = bl;
        this.classloader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        this.threadGroup = threadGroup;
        this.threads = n;
    }

    @Override
    protected void doStart() throws Exception {
        int n = this.threads > 0 ? this.threads : 1;
        this.scheduler = new ScheduledThreadPoolExecutor(n, runnable -> {
            Thread thread = this.thread = new Thread(this.threadGroup, runnable, this.name + "-" + this.count.incrementAndGet());
            thread.setDaemon(this.daemon);
            thread.setContextClassLoader(this.classloader);
            return thread;
        });
        this.scheduler.setRemoveOnCancelPolicy(true);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this.scheduler.shutdownNow();
        super.doStop();
        this.scheduler = null;
    }

    @Override
    public Scheduler.Task schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = this.scheduler;
        if (scheduledThreadPoolExecutor == null) {
            return () -> false;
        }
        ScheduledFuture<?> scheduledFuture = scheduledThreadPoolExecutor.schedule(runnable, l, timeUnit);
        return new ScheduledFutureTask(scheduledFuture);
    }

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        Thread thread = this.thread;
        if (thread == null) {
            Dumpable.dumpObject(appendable, this);
        } else {
            Dumpable.dumpObjects(appendable, string, this, thread.getStackTrace());
        }
    }

    @ManagedAttribute(value="The name of the scheduler")
    public String getName() {
        return this.name;
    }

    @ManagedAttribute(value="Whether the scheduler uses daemon threads")
    public boolean isDaemon() {
        return this.daemon;
    }

    @ManagedAttribute(value="The number of scheduler threads")
    public int getThreads() {
        return this.threads;
    }

    private static class ScheduledFutureTask
    implements Scheduler.Task {
        private final ScheduledFuture<?> scheduledFuture;

        ScheduledFutureTask(ScheduledFuture<?> scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        @Override
        public boolean cancel() {
            return this.scheduledFuture.cancel(false);
        }
    }
}

