/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.util.AtomicBiInteger;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.PrivilegedThreadFactory;
import org.eclipse.jetty.util.thread.ReservedThreadExecutor;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.ThreadPoolBudget;
import org.eclipse.jetty.util.thread.TryExecutor;

@ManagedObject(value="A thread pool")
public class QueuedThreadPool
extends ContainerLifeCycle
implements ThreadFactory,
ThreadPool.SizedThreadPool,
Dumpable,
TryExecutor {
    private static final Logger LOG = Log.getLogger(QueuedThreadPool.class);
    private static final Runnable NOOP = () -> {};
    private final AtomicBiInteger _counts = new AtomicBiInteger(Integer.MIN_VALUE, 0);
    private final AtomicLong _lastShrink = new AtomicLong();
    private final Set<Thread> _threads = ConcurrentHashMap.newKeySet();
    private final Object _joinLock = new Object();
    private final BlockingQueue<Runnable> _jobs;
    private final ThreadGroup _threadGroup;
    private final ThreadFactory _threadFactory;
    private String _name = "qtp" + this.hashCode();
    private int _idleTimeout;
    private int _maxThreads;
    private int _minThreads;
    private int _reservedThreads = -1;
    private TryExecutor _tryExecutor = TryExecutor.NO_TRY;
    private int _priority = 5;
    private boolean _daemon = false;
    private boolean _detailedDump = false;
    private int _lowThreadsThreshold = 1;
    private ThreadPoolBudget _budget;
    private final Runnable _runnable = new Runner();

    public QueuedThreadPool() {
        this(200);
    }

    public QueuedThreadPool(@Name(value="maxThreads") int n) {
        this(n, Math.min(8, n));
    }

    public QueuedThreadPool(@Name(value="maxThreads") int n, @Name(value="minThreads") int n2) {
        this(n, n2, 60000);
    }

    public QueuedThreadPool(@Name(value="maxThreads") int n, @Name(value="minThreads") int n2, @Name(value="queue") BlockingQueue<Runnable> blockingQueue) {
        this(n, n2, 60000, -1, blockingQueue, null);
    }

    public QueuedThreadPool(@Name(value="maxThreads") int n, @Name(value="minThreads") int n2, @Name(value="idleTimeout") int n3) {
        this(n, n2, n3, null);
    }

    public QueuedThreadPool(@Name(value="maxThreads") int n, @Name(value="minThreads") int n2, @Name(value="idleTimeout") int n3, @Name(value="queue") BlockingQueue<Runnable> blockingQueue) {
        this(n, n2, n3, blockingQueue, null);
    }

    public QueuedThreadPool(@Name(value="maxThreads") int n, @Name(value="minThreads") int n2, @Name(value="idleTimeout") int n3, @Name(value="queue") BlockingQueue<Runnable> blockingQueue, @Name(value="threadGroup") ThreadGroup threadGroup) {
        this(n, n2, n3, -1, blockingQueue, threadGroup);
    }

    public QueuedThreadPool(@Name(value="maxThreads") int n, @Name(value="minThreads") int n2, @Name(value="idleTimeout") int n3, @Name(value="reservedThreads") int n4, @Name(value="queue") BlockingQueue<Runnable> blockingQueue, @Name(value="threadGroup") ThreadGroup threadGroup) {
        this(n, n2, n3, n4, blockingQueue, threadGroup, null);
    }

    public QueuedThreadPool(@Name(value="maxThreads") int n, @Name(value="minThreads") int n2, @Name(value="idleTimeout") int n3, @Name(value="reservedThreads") int n4, @Name(value="queue") BlockingQueue<Runnable> blockingQueue, @Name(value="threadGroup") ThreadGroup threadGroup, @Name(value="threadFactory") ThreadFactory threadFactory) {
        if (n < n2) {
            throw new IllegalArgumentException("max threads (" + n + ") less than min threads (" + n2 + ")");
        }
        this.setMinThreads(n2);
        this.setMaxThreads(n);
        this.setIdleTimeout(n3);
        this.setStopTimeout(5000L);
        this.setReservedThreads(n4);
        if (blockingQueue == null) {
            int n5 = Math.max(this._minThreads, 8) * 1024;
            blockingQueue = new BlockingArrayQueue<Runnable>(n5, n5);
        }
        this._jobs = blockingQueue;
        this._threadGroup = threadGroup;
        this.setThreadPoolBudget(new ThreadPoolBudget(this));
        this._threadFactory = threadFactory == null ? this : threadFactory;
    }

    @Override
    public ThreadPoolBudget getThreadPoolBudget() {
        return this._budget;
    }

    public void setThreadPoolBudget(ThreadPoolBudget threadPoolBudget) {
        if (threadPoolBudget != null && threadPoolBudget.getSizedThreadPool() != this) {
            throw new IllegalArgumentException();
        }
        this.updateBean(this._budget, threadPoolBudget);
        this._budget = threadPoolBudget;
    }

    @Override
    protected void doStart() throws Exception {
        if (this._reservedThreads == 0) {
            this._tryExecutor = NO_TRY;
        } else {
            ReservedThreadExecutor reservedThreadExecutor = new ReservedThreadExecutor(this, this._reservedThreads);
            reservedThreadExecutor.setIdleTimeout(this._idleTimeout, TimeUnit.MILLISECONDS);
            this._tryExecutor = reservedThreadExecutor;
        }
        this.addBean(this._tryExecutor);
        this._lastShrink.set(System.nanoTime());
        super.doStart();
        this._counts.set(0, 0);
        this.ensureThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        Object object;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping {}", this);
        }
        super.doStop();
        this.removeBean(this._tryExecutor);
        this._tryExecutor = TryExecutor.NO_TRY;
        int n = this._counts.getAndSetHi(Integer.MIN_VALUE);
        long l = this.getStopTimeout();
        BlockingQueue<Runnable> blockingQueue = this.getQueue();
        for (int i = 0; i < n; ++i) {
            blockingQueue.offer(NOOP);
        }
        if (l > 0L) {
            this.joinThreads(System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(l) / 2L);
        }
        Thread.yield();
        for (Thread thread : this._threads) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Interrupting {}", thread);
            }
            thread.interrupt();
        }
        if (l > 0L) {
            this.joinThreads(System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(l) / 2L);
            Thread.yield();
            if (LOG.isDebugEnabled()) {
                for (Thread thread : this._threads) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                        stringBuilder.append(System.lineSeparator()).append("\tat ").append(stackTraceElement);
                    }
                    LOG.warn("Couldn't stop {}{}", thread, stringBuilder.toString());
                }
            } else {
                for (Thread thread : this._threads) {
                    LOG.warn("{} Couldn't stop {}", this, thread);
                }
            }
        }
        while (!this._jobs.isEmpty()) {
            object = (Runnable)this._jobs.poll();
            if (object instanceof Closeable) {
                try {
                    ((Closeable)object).close();
                }
                catch (Throwable throwable) {
                    LOG.warn(throwable);
                }
                continue;
            }
            if (object == NOOP) continue;
            LOG.warn("Stopped without executing or closing {}", object);
        }
        if (this._budget != null) {
            this._budget.reset();
        }
        object = this._joinLock;
        synchronized (object) {
            this._joinLock.notifyAll();
        }
    }

    private void joinThreads(long l) throws InterruptedException {
        for (Thread thread : this._threads) {
            long l2 = TimeUnit.NANOSECONDS.toMillis(l - System.nanoTime());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Waiting for {} for {}", thread, l2);
            }
            if (l2 <= 0L) continue;
            thread.join(l2);
        }
    }

    @ManagedAttribute(value="maximum time a thread may be idle in ms")
    public int getIdleTimeout() {
        return this._idleTimeout;
    }

    public void setIdleTimeout(int n) {
        this._idleTimeout = n;
        ReservedThreadExecutor reservedThreadExecutor = this.getBean(ReservedThreadExecutor.class);
        if (reservedThreadExecutor != null) {
            reservedThreadExecutor.setIdleTimeout(n, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    @ManagedAttribute(value="maximum number of threads in the pool")
    public int getMaxThreads() {
        return this._maxThreads;
    }

    @Override
    public void setMaxThreads(int n) {
        if (this._budget != null) {
            this._budget.check(n);
        }
        this._maxThreads = n;
        if (this._minThreads > this._maxThreads) {
            this._minThreads = this._maxThreads;
        }
    }

    @Override
    @ManagedAttribute(value="minimum number of threads in the pool")
    public int getMinThreads() {
        return this._minThreads;
    }

    @Override
    public void setMinThreads(int n) {
        this._minThreads = n;
        if (this._minThreads > this._maxThreads) {
            this._maxThreads = this._minThreads;
        }
        if (this.isStarted()) {
            this.ensureThreads();
        }
    }

    @ManagedAttribute(value="number of configured reserved threads or -1 for heuristic")
    public int getReservedThreads() {
        return this._reservedThreads;
    }

    public void setReservedThreads(int n) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._reservedThreads = n;
    }

    @ManagedAttribute(value="name of the thread pool")
    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._name = string;
    }

    @ManagedAttribute(value="priority of threads in the pool")
    public int getThreadsPriority() {
        return this._priority;
    }

    public void setThreadsPriority(int n) {
        this._priority = n;
    }

    @ManagedAttribute(value="thread pool uses daemon threads")
    public boolean isDaemon() {
        return this._daemon;
    }

    public void setDaemon(boolean bl) {
        this._daemon = bl;
    }

    @ManagedAttribute(value="reports additional details in the dump")
    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    public void setDetailedDump(boolean bl) {
        this._detailedDump = bl;
    }

    @ManagedAttribute(value="threshold at which the pool is low on threads")
    public int getLowThreadsThreshold() {
        return this._lowThreadsThreshold;
    }

    public void setLowThreadsThreshold(int n) {
        this._lowThreadsThreshold = n;
    }

    @ManagedAttribute(value="size of the job queue")
    public int getQueueSize() {
        int n = this._counts.getLo();
        return Math.max(0, -n);
    }

    @ManagedAttribute(value="maximum number (capacity) of reserved threads")
    public int getMaxReservedThreads() {
        TryExecutor tryExecutor = this._tryExecutor;
        if (tryExecutor instanceof ReservedThreadExecutor) {
            ReservedThreadExecutor reservedThreadExecutor = (ReservedThreadExecutor)tryExecutor;
            return reservedThreadExecutor.getCapacity();
        }
        return 0;
    }

    @ManagedAttribute(value="number of available reserved threads")
    public int getAvailableReservedThreads() {
        TryExecutor tryExecutor = this._tryExecutor;
        if (tryExecutor instanceof ReservedThreadExecutor) {
            ReservedThreadExecutor reservedThreadExecutor = (ReservedThreadExecutor)tryExecutor;
            return reservedThreadExecutor.getAvailable();
        }
        return 0;
    }

    @Override
    @ManagedAttribute(value="number of threads in the pool")
    public int getThreads() {
        int n = this._counts.getHi();
        return Math.max(0, n);
    }

    @ManagedAttribute(value="number of threads ready to execute transient jobs")
    public int getReadyThreads() {
        return this.getIdleThreads() + this.getAvailableReservedThreads();
    }

    @ManagedAttribute(value="number of threads used by internal components")
    public int getLeasedThreads() {
        return this.getMaxLeasedThreads() - this.getMaxReservedThreads();
    }

    @ManagedAttribute(value="maximum number of threads leased to internal components")
    public int getMaxLeasedThreads() {
        ThreadPoolBudget threadPoolBudget = this._budget;
        return threadPoolBudget == null ? 0 : threadPoolBudget.getLeasedThreads();
    }

    @Override
    @ManagedAttribute(value="number of idle threads but not reserved")
    public int getIdleThreads() {
        int n = this._counts.getLo();
        return Math.max(0, n);
    }

    @ManagedAttribute(value="number of threads executing internal and transient jobs")
    public int getBusyThreads() {
        return this.getThreads() - this.getReadyThreads();
    }

    @ManagedAttribute(value="number of threads executing transient jobs")
    public int getUtilizedThreads() {
        return this.getThreads() - this.getLeasedThreads() - this.getReadyThreads();
    }

    @ManagedAttribute(value="maximum number of threads available to run transient jobs")
    public int getMaxAvailableThreads() {
        return this.getMaxThreads() - this.getLeasedThreads();
    }

    @ManagedAttribute(value="utilization rate of threads executing transient jobs")
    public double getUtilizationRate() {
        return (double)this.getUtilizedThreads() / (double)this.getMaxAvailableThreads();
    }

    @Override
    @ManagedAttribute(value="thread pool is low on threads", readonly=true)
    public boolean isLowOnThreads() {
        return this.getMaxThreads() - this.getThreads() + this.getReadyThreads() - this.getQueueSize() <= this.getLowThreadsThreshold();
    }

    @Override
    public void execute(Runnable runnable) {
        int n;
        int n2;
        int n3;
        long l;
        do {
            if ((n3 = AtomicBiInteger.getHi(l = this._counts.get())) != Integer.MIN_VALUE) continue;
            throw new RejectedExecutionException(runnable.toString());
        } while (!this._counts.compareAndSet(l, n3 + (n2 = (n = AtomicBiInteger.getLo(l)) <= 0 && n3 < this._maxThreads ? 1 : 0), n + n2 - 1));
        if (!this._jobs.offer(runnable)) {
            if (this.addCounts(-n2, 1 - n2)) {
                LOG.warn("{} rejected {}", this, runnable);
            }
            throw new RejectedExecutionException(runnable.toString());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("queue {} startThread={}", runnable, n2);
        }
        while (n2-- > 0) {
            this.startThread();
        }
    }

    @Override
    public boolean tryExecute(Runnable runnable) {
        TryExecutor tryExecutor = this._tryExecutor;
        return tryExecutor != null && tryExecutor.tryExecute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() throws InterruptedException {
        Object object = this._joinLock;
        synchronized (object) {
            while (this.isRunning()) {
                this._joinLock.wait();
            }
        }
        while (this.isStopping()) {
            Thread.sleep(1L);
        }
    }

    private void ensureThreads() {
        long l;
        int n;
        while ((n = AtomicBiInteger.getHi(l = this._counts.get())) != Integer.MIN_VALUE) {
            int n2 = AtomicBiInteger.getLo(l);
            if (n >= this._minThreads && (n2 >= 0 || n >= this._maxThreads)) break;
            if (!this._counts.compareAndSet(l, n + 1, n2 + 1)) continue;
            this.startThread();
        }
    }

    protected void startThread() {
        boolean bl = false;
        try {
            Thread thread = this._threadFactory.newThread(this._runnable);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting {}", thread);
            }
            this._threads.add(thread);
            this._lastShrink.set(System.nanoTime());
            thread.start();
            bl = true;
        }
        finally {
            if (!bl) {
                this.addCounts(-1, -1);
            }
        }
    }

    private boolean addCounts(int n, int n2) {
        int n3;
        int n4;
        long l;
        long l2;
        do {
            l2 = this._counts.get();
            n4 = AtomicBiInteger.getHi(l2);
            n3 = AtomicBiInteger.getLo(l2);
            if (n4 != Integer.MIN_VALUE) continue;
            return false;
        } while (!this._counts.compareAndSet(l2, l = AtomicBiInteger.encode(n4 + n, n3 + n2)));
        return true;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        return PrivilegedThreadFactory.newThread(() -> {
            Thread thread = new Thread(this._threadGroup, runnable);
            thread.setDaemon(this.isDaemon());
            thread.setPriority(this.getThreadsPriority());
            thread.setName(this._name + "-" + thread.getId());
            thread.setContextClassLoader(this.getClass().getClassLoader());
            return thread;
        });
    }

    protected void removeThread(Thread thread) {
        this._threads.remove(thread);
    }

    @Override
    public void dump(Appendable appendable2, String string) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.getMaxThreads());
        for (Thread thread : this._threads) {
            StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
            String string3 = this.getCompressedStackTag(stackTraceElementArray);
            String string4 = String.format("%s %s tid=%d prio=%d", new Object[]{thread.getName(), thread.getState(), thread.getId(), thread.getPriority()});
            if (!StringUtil.isBlank(string3)) {
                arrayList.add(string4 + " " + string3);
                continue;
            }
            if (this.isDetailedDump()) {
                arrayList.add((appendable, string2) -> Dumpable.dumpObjects(appendable, string2, string4, stackTraceElementArray));
                continue;
            }
            arrayList.add(string4 + " @ " + (stackTraceElementArray.length > 0 ? stackTraceElementArray[0].toString() : "???"));
        }
        DumpableCollection dumpableCollection = new DumpableCollection("threads", arrayList);
        if (this.isDetailedDump()) {
            this.dumpObjects(appendable2, string, dumpableCollection, new DumpableCollection("jobs", new ArrayList<Runnable>(this.getQueue())));
        } else {
            this.dumpObjects(appendable2, string, dumpableCollection);
        }
    }

    private String getCompressedStackTag(StackTraceElement[] stackTraceElementArray) {
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            if ("idleJobPoll".equals(stackTraceElement.getMethodName()) && stackTraceElement.getClassName().equals(Runner.class.getName())) {
                return "IDLE";
            }
            if ("reservedWait".equals(stackTraceElement.getMethodName()) && stackTraceElement.getClassName().endsWith("ReservedThread")) {
                return "RESERVED";
            }
            if ("select".equals(stackTraceElement.getMethodName()) && stackTraceElement.getClassName().endsWith("SelectorProducer")) {
                return "SELECTING";
            }
            if (!"accept".equals(stackTraceElement.getMethodName()) || !stackTraceElement.getClassName().contains("ServerConnector")) continue;
            return "ACCEPTING";
        }
        return "";
    }

    protected void runJob(Runnable runnable) {
        runnable.run();
    }

    protected BlockingQueue<Runnable> getQueue() {
        return this._jobs;
    }

    @Deprecated
    public void setQueue(BlockingQueue<Runnable> blockingQueue) {
        throw new UnsupportedOperationException("Use constructor injection");
    }

    @ManagedOperation(value="interrupts a pool thread")
    public boolean interruptThread(@Name(value="id") long l) {
        for (Thread thread : this._threads) {
            if (thread.getId() != l) continue;
            thread.interrupt();
            return true;
        }
        return false;
    }

    @ManagedOperation(value="dumps a pool thread stack")
    public String dumpThread(@Name(value="id") long l) {
        for (Thread thread : this._threads) {
            if (thread.getId() != l) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(thread.getId()).append(" ").append(thread.getName()).append(" ");
            stringBuilder.append((Object)thread.getState()).append(":").append(System.lineSeparator());
            for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                stringBuilder.append("  at ").append(stackTraceElement.toString()).append(System.lineSeparator());
            }
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    public String toString() {
        long l = this._counts.get();
        int n = Math.max(0, AtomicBiInteger.getHi(l));
        int n2 = Math.max(0, AtomicBiInteger.getLo(l));
        int n3 = this.getQueueSize();
        return String.format("%s[%s]@%x{%s,%d<=%d<=%d,i=%d,r=%d,q=%d}[%s]", this.getClass().getSimpleName(), this._name, this.hashCode(), this.getState(), this.getMinThreads(), n, this.getMaxThreads(), n2, this.getReservedThreads(), n3, this._tryExecutor);
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        private Runnable idleJobPoll(long l) throws InterruptedException {
            if (l <= 0L) {
                return (Runnable)QueuedThreadPool.this._jobs.take();
            }
            return (Runnable)QueuedThreadPool.this._jobs.poll(l, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Runner started for {}", QueuedThreadPool.this);
            }
            boolean bl = true;
            try {
                void var2_3;
                Object var2_2 = null;
                while (QueuedThreadPool.this.addCounts(0, var2_3 == null ? 0 : 1)) {
                    bl = true;
                    try {
                        void var2_6;
                        Runnable runnable = (Runnable)QueuedThreadPool.this._jobs.poll();
                        if (runnable == null) {
                            Runnable runnable2;
                            long l = QueuedThreadPool.this.getIdleTimeout();
                            if (l > 0L && QueuedThreadPool.this.getThreads() > QueuedThreadPool.this._minThreads) {
                                long l2 = QueuedThreadPool.this._lastShrink.get();
                                long l3 = System.nanoTime();
                                if (l3 - l2 > TimeUnit.MILLISECONDS.toNanos(l) && QueuedThreadPool.this._lastShrink.compareAndSet(l2, l3)) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("shrinking {}", QueuedThreadPool.this);
                                    }
                                    break;
                                }
                            }
                            if ((runnable2 = this.idleJobPoll(l)) == null) continue;
                        }
                        bl = false;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("run {} in {}", var2_6, QueuedThreadPool.this);
                        }
                        QueuedThreadPool.this.runJob((Runnable)var2_6);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("ran {} in {}", var2_6, QueuedThreadPool.this);
                    }
                    catch (InterruptedException interruptedException) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("interrupted {} in {}", var2_3, QueuedThreadPool.this);
                        }
                        LOG.ignore(interruptedException);
                    }
                    catch (Throwable throwable) {
                        LOG.warn(throwable);
                    }
                    finally {
                        Thread.interrupted();
                    }
                }
            }
            catch (Throwable throwable) {
                Thread thread = Thread.currentThread();
                QueuedThreadPool.this.removeThread(thread);
                QueuedThreadPool.this.addCounts(-1, bl ? -1 : 0);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} exited for {}", thread, QueuedThreadPool.this);
                }
                QueuedThreadPool.this.ensureThreads();
                throw throwable;
            }
            Thread thread = Thread.currentThread();
            QueuedThreadPool.this.removeThread(thread);
            QueuedThreadPool.this.addCounts(-1, bl ? -1 : 0);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} exited for {}", thread, QueuedThreadPool.this);
            }
            QueuedThreadPool.this.ensureThreads();
        }
    }
}

