/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.util.Properties;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AbstractLogger
implements Logger {
    public static final int LEVEL_DEFAULT = -1;
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_WARN = 3;
    public static final int LEVEL_OFF = 10;

    @Override
    public final Logger getLogger(String string) {
        if (AbstractLogger.isBlank(string)) {
            return this;
        }
        String string2 = this.getName();
        String string3 = AbstractLogger.isBlank(string2) || Log.getRootLogger() == this ? string : string2 + "." + string;
        Logger logger = Log.getLoggers().get(string3);
        if (logger == null) {
            Logger logger2 = this.newLogger(string3);
            logger = Log.getMutableLoggers().putIfAbsent(string3, logger2);
            if (logger == null) {
                logger = logger2;
            }
        }
        return logger;
    }

    protected abstract Logger newLogger(String var1);

    private static boolean isBlank(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static int lookupLoggingLevel(Properties properties, String string) {
        if (properties == null || properties.isEmpty() || string == null) {
            return -1;
        }
        String string2 = string;
        while (string2 != null && string2.length() > 0) {
            String string3 = properties.getProperty(string2 + ".LEVEL");
            int n = AbstractLogger.getLevelId(string2 + ".LEVEL", string3);
            if (n != -1) {
                return n;
            }
            int n2 = string2.lastIndexOf(46);
            if (n2 >= 0) {
                string2 = string2.substring(0, n2);
                continue;
            }
            string2 = null;
        }
        return -1;
    }

    public static String getLoggingProperty(Properties properties, String string, String string2) {
        String string3 = string;
        while (string3 != null && string3.length() > 0) {
            String string4 = properties.getProperty(string3 + "." + string2);
            if (string4 != null) {
                return string4;
            }
            int n = string3.lastIndexOf(46);
            string3 = n >= 0 ? string3.substring(0, n) : null;
        }
        return null;
    }

    protected static int getLevelId(String string, String string2) {
        if (string2 == null) {
            return -1;
        }
        String string3 = string2.trim();
        if ("ALL".equalsIgnoreCase(string3)) {
            return 0;
        }
        if ("DEBUG".equalsIgnoreCase(string3)) {
            return 1;
        }
        if ("INFO".equalsIgnoreCase(string3)) {
            return 2;
        }
        if ("WARN".equalsIgnoreCase(string3)) {
            return 3;
        }
        if ("OFF".equalsIgnoreCase(string3)) {
            return 10;
        }
        System.err.println("Unknown StdErrLog level [" + string + "]=[" + string3 + "], expecting only [ALL, DEBUG, INFO, WARN, OFF] as values.");
        return -1;
    }

    protected static String condensePackageString(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = false;
        boolean bl2 = false;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!bl && (bl = Character.isJavaIdentifierStart(c))) {
                if (n2 >= 0) {
                    stringBuilder.append(string.charAt(n2));
                    bl2 = true;
                }
                n2 = i;
            }
            if (!bl) continue;
            if (!Character.isJavaIdentifierPart(c)) {
                bl = false;
                continue;
            }
            n3 = i;
        }
        if (n2 >= 0 && n3 >= n2) {
            if (bl2) {
                stringBuilder.append('.');
            }
            stringBuilder.append(string, n2, n3 + 1);
        }
        return stringBuilder.toString();
    }

    @Override
    public void debug(String string, long l) {
        if (this.isDebugEnabled()) {
            this.debug(string, new Object[]{new Long(l)});
        }
    }
}

