/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.util.EventListener;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;

@ManagedObject(value="Lifecycle Interface for startable components")
public interface LifeCycle {
    @ManagedOperation(value="Starts the instance", impact="ACTION")
    public void start() throws Exception;

    @ManagedOperation(value="Stops the instance", impact="ACTION")
    public void stop() throws Exception;

    public boolean isRunning();

    public boolean isStarted();

    public boolean isStarting();

    public boolean isStopping();

    public boolean isStopped();

    public boolean isFailed();

    public void addLifeCycleListener(Listener var1);

    public void removeLifeCycleListener(Listener var1);

    public static void start(Object object) {
        if (object instanceof LifeCycle) {
            try {
                ((LifeCycle)object).start();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static void stop(Object object) {
        if (object instanceof LifeCycle) {
            try {
                ((LifeCycle)object).stop();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static interface Listener
    extends EventListener {
        default public void lifeCycleStarting(LifeCycle lifeCycle) {
        }

        default public void lifeCycleStarted(LifeCycle lifeCycle) {
        }

        default public void lifeCycleFailure(LifeCycle lifeCycle, Throwable throwable) {
        }

        default public void lifeCycleStopping(LifeCycle lifeCycle) {
        }

        default public void lifeCycleStopped(LifeCycle lifeCycle) {
        }
    }
}

