/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;

public class AttributeContainerMap
extends ContainerLifeCycle
implements Attributes {
    private final Map<String, Object> _map = new HashMap<String, Object>();

    @Override
    public synchronized void setAttribute(String string, Object object) {
        Object object2 = this._map.put(string, object);
        this.updateBean(object2, object);
    }

    @Override
    public synchronized void removeAttribute(String string) {
        Object object = this._map.remove(string);
        if (object != null) {
            this.removeBean(object);
        }
    }

    @Override
    public synchronized Object getAttribute(String string) {
        return this._map.get(string);
    }

    @Override
    public synchronized Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this._map.keySet());
    }

    @Override
    public Set<String> getAttributeNameSet() {
        return this._map.keySet();
    }

    @Override
    public synchronized void clearAttributes() {
        this._map.clear();
        this.removeBeans();
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        Dumpable.dumpObject(appendable, this);
        Dumpable.dumpMapEntries(appendable, string, this._map, true);
    }

    @Override
    public String toString() {
        return String.format("%s@%x{size=%d}", this.getClass().getSimpleName(), this.hashCode(), this._map.size());
    }
}

