/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public interface SocketAddressResolver {
    public void resolve(String var1, int var2, Promise<List<InetSocketAddress>> var3);

    @ManagedObject(value="The asynchronous address resolver")
    public static class Async
    implements SocketAddressResolver {
        private static final Logger LOG = Log.getLogger(SocketAddressResolver.class);
        private final Executor executor;
        private final Scheduler scheduler;
        private final long timeout;

        public Async(Executor executor, Scheduler scheduler, long l) {
            this.executor = executor;
            this.scheduler = scheduler;
            this.timeout = l;
        }

        public Executor getExecutor() {
            return this.executor;
        }

        public Scheduler getScheduler() {
            return this.scheduler;
        }

        @ManagedAttribute(value="The timeout, in milliseconds, to resolve an address", readonly=true)
        public long getTimeout() {
            return this.timeout;
        }

        @Override
        public void resolve(String string, int n, Promise<List<InetSocketAddress>> promise) {
            this.executor.execute(() -> {
                Scheduler.Task task = null;
                AtomicBoolean atomicBoolean = new AtomicBoolean();
                if (this.timeout > 0L) {
                    Thread thread = Thread.currentThread();
                    task = this.scheduler.schedule(() -> {
                        if (atomicBoolean.compareAndSet(false, true)) {
                            promise.failed(new TimeoutException("DNS timeout " + this.getTimeout() + " ms"));
                            thread.interrupt();
                        }
                    }, this.timeout, TimeUnit.MILLISECONDS);
                }
                try {
                    long l = System.nanoTime();
                    InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
                    long l2 = System.nanoTime() - l;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Resolved {} in {} ms", string, TimeUnit.NANOSECONDS.toMillis(l2));
                    }
                    ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>(inetAddressArray.length);
                    for (InetAddress inetAddress : inetAddressArray) {
                        arrayList.add(new InetSocketAddress(inetAddress, n));
                    }
                    if (atomicBoolean.compareAndSet(false, true)) {
                        if (arrayList.isEmpty()) {
                            promise.failed(new UnknownHostException());
                        } else {
                            promise.succeeded(arrayList);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (atomicBoolean.compareAndSet(false, true)) {
                        promise.failed(throwable);
                    }
                }
                finally {
                    if (task != null) {
                        task.cancel();
                    }
                }
            });
        }
    }

    @ManagedObject(value="The synchronous address resolver")
    public static class Sync
    implements SocketAddressResolver {
        @Override
        public void resolve(String string, int n, Promise<List<InetSocketAddress>> promise) {
            try {
                InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
                ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>(inetAddressArray.length);
                for (InetAddress inetAddress : inetAddressArray) {
                    arrayList.add(new InetSocketAddress(inetAddress, n));
                }
                if (arrayList.isEmpty()) {
                    promise.failed(new UnknownHostException());
                } else {
                    promise.succeeded(arrayList);
                }
            }
            catch (Throwable throwable) {
                promise.failed(throwable);
            }
        }
    }
}

