/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ConstantThrowable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public class SharedBlockingCallback {
    private static final Logger LOG = Log.getLogger(SharedBlockingCallback.class);
    private static final Throwable IDLE = new ConstantThrowable("IDLE");
    private static final Throwable SUCCEEDED = new ConstantThrowable("SUCCEEDED");
    private static final Throwable FAILED = new ConstantThrowable("FAILED");
    private final ReentrantLock _lock = new ReentrantLock();
    private final Condition _idle = this._lock.newCondition();
    private final Condition _complete = this._lock.newCondition();
    private Blocker _blocker = new Blocker();

    @Deprecated
    protected long getIdleTimeout() {
        return -1L;
    }

    public Blocker acquire() throws IOException {
        long l = this.getIdleTimeout();
        this._lock.lock();
        try {
            while (this._blocker._state != IDLE) {
                if (l > 0L && l < 0x3FFFFFFFFFFFFFFFL) {
                    if (this._idle.await(l * 2L, TimeUnit.MILLISECONDS)) continue;
                    throw new IOException(new TimeoutException());
                }
                this._idle.await();
            }
            this._blocker._state = null;
            Blocker blocker = this._blocker;
            return blocker;
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
        finally {
            this._lock.unlock();
        }
    }

    public boolean fail(Throwable throwable) {
        Objects.requireNonNull(throwable);
        this._lock.lock();
        try {
            if (this._blocker._state == null) {
                this._blocker._state = new BlockerFailedException(throwable);
                this._complete.signalAll();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this._lock.unlock();
        }
        return false;
    }

    protected void notComplete(Blocker blocker) {
        LOG.warn("Blocker not complete {}", blocker);
        if (LOG.isDebugEnabled()) {
            LOG.debug(new Throwable());
        }
    }

    private static class BlockerFailedException
    extends Exception {
        public BlockerFailedException(Throwable throwable) {
            super(throwable);
        }
    }

    private static class BlockerTimeoutException
    extends TimeoutException {
        private BlockerTimeoutException() {
        }
    }

    public class Blocker
    implements Callback,
    Closeable {
        private Throwable _state = SharedBlockingCallback.access$100();

        protected Blocker() {
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }

        @Override
        public void succeeded() {
            SharedBlockingCallback.this._lock.lock();
            try {
                if (this._state == null) {
                    this._state = SUCCEEDED;
                    SharedBlockingCallback.this._complete.signalAll();
                } else {
                    LOG.warn("Succeeded after {}", this._state.toString());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this._state);
                    }
                }
            }
            finally {
                SharedBlockingCallback.this._lock.unlock();
            }
        }

        @Override
        public void failed(Throwable throwable) {
            SharedBlockingCallback.this._lock.lock();
            try {
                if (this._state == null) {
                    this._state = throwable == null ? FAILED : (throwable instanceof BlockerTimeoutException ? new IOException(throwable) : throwable);
                    SharedBlockingCallback.this._complete.signalAll();
                } else if (this._state instanceof BlockerTimeoutException || this._state instanceof BlockerFailedException) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Failed after {}", this._state);
                    }
                } else {
                    LOG.warn("Failed after {}: {}", this._state, throwable);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this._state);
                        LOG.debug(throwable);
                    }
                }
            }
            finally {
                SharedBlockingCallback.this._lock.unlock();
            }
        }

        public void block() throws IOException {
            long l = SharedBlockingCallback.this.getIdleTimeout();
            SharedBlockingCallback.this._lock.lock();
            try {
                while (this._state == null) {
                    if (l > 0L) {
                        long l2 = Math.min(l / 2L, 1000L);
                        if (SharedBlockingCallback.this._complete.await(l + l2, TimeUnit.MILLISECONDS)) continue;
                        this._state = new BlockerTimeoutException();
                        continue;
                    }
                    SharedBlockingCallback.this._complete.await();
                }
                if (this._state == SUCCEEDED) {
                    return;
                }
                try {
                    if (this._state == IDLE) {
                        throw new IllegalStateException("IDLE");
                    }
                    if (this._state instanceof IOException) {
                        throw (IOException)this._state;
                    }
                    if (this._state instanceof CancellationException) {
                        throw (CancellationException)this._state;
                    }
                    if (this._state instanceof RuntimeException) {
                        throw (RuntimeException)this._state;
                    }
                    if (this._state instanceof Error) {
                        throw (Error)this._state;
                    }
                    throw new IOException(this._state);
                }
                catch (InterruptedException interruptedException) {
                    this._state = interruptedException;
                    throw new InterruptedIOException();
                }
            }
            finally {
                SharedBlockingCallback.this._lock.unlock();
            }
        }

        @Override
        public void close() {
            SharedBlockingCallback.this._lock.lock();
            try {
                if (this._state == IDLE) {
                    throw new IllegalStateException("IDLE");
                }
                if (this._state == null) {
                    SharedBlockingCallback.this.notComplete(this);
                }
            }
            finally {
                try {
                    if (this._state != null && this._state != SUCCEEDED) {
                        SharedBlockingCallback.this._blocker = new Blocker();
                    } else {
                        this._state = IDLE;
                    }
                    SharedBlockingCallback.this._idle.signalAll();
                    SharedBlockingCallback.this._complete.signalAll();
                }
                finally {
                    SharedBlockingCallback.this._lock.unlock();
                }
            }
        }

        public String toString() {
            SharedBlockingCallback.this._lock.lock();
            try {
                String string = String.format("%s@%x{%s}", Blocker.class.getSimpleName(), this.hashCode(), this._state);
                return string;
            }
            finally {
                SharedBlockingCallback.this._lock.unlock();
            }
        }
    }
}

