/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class PathWatcher
extends AbstractLifeCycle
implements Runnable {
    private static final boolean IS_WINDOWS;
    static final Logger LOG;
    private static final WatchEvent.Kind<?>[] WATCH_EVENT_KINDS;
    private static final WatchEvent.Kind<?>[] WATCH_DIR_KINDS;
    private WatchService watchService;
    private final List<Config> configs = new ArrayList<Config>();
    private final Map<WatchKey, Config> keys = new ConcurrentHashMap<WatchKey, Config>();
    private final List<EventListener> listeners = new CopyOnWriteArrayList<EventListener>();
    private final Map<Path, PathWatchEvent> pending = new LinkedHashMap<Path, PathWatchEvent>(32, 0.75f, false);
    private final List<PathWatchEvent> events = new ArrayList<PathWatchEvent>();
    private long updateQuietTimeDuration = 1000L;
    private TimeUnit updateQuietTimeUnit = TimeUnit.MILLISECONDS;
    private Thread thread;
    private boolean _notifyExistingOnStart = true;

    protected static <T> WatchEvent<T> cast(WatchEvent<?> watchEvent) {
        return watchEvent;
    }

    public Collection<Config> getConfigs() {
        return this.configs;
    }

    public void watch(Path path) {
        Path path2 = path;
        if (!path2.isAbsolute()) {
            path2 = path.toAbsolutePath();
        }
        Config config = null;
        Path path3 = path2.getParent();
        for (Config config2 : this.configs) {
            if (!config2.getPath().equals(path3)) continue;
            config = config2;
            break;
        }
        if (config == null) {
            config = new Config(path2.getParent());
            config.addIncludeGlobRelative("");
            config.addIncludeGlobRelative(path.getFileName().toString());
            this.watch(config);
        } else {
            config.addIncludeGlobRelative(path.getFileName().toString());
        }
    }

    public void watch(Config config) {
        this.configs.add(config);
    }

    public void addListener(EventListener eventListener) {
        this.listeners.add(eventListener);
    }

    private void appendConfigId(StringBuilder stringBuilder) {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (Config config : this.keys.values()) {
            arrayList.add(config.path);
        }
        Collections.sort(arrayList);
        stringBuilder.append("[");
        if (arrayList.size() > 0) {
            stringBuilder.append(arrayList.get(0));
            if (arrayList.size() > 1) {
                stringBuilder.append(" (+").append(arrayList.size() - 1).append(")");
            }
        } else {
            stringBuilder.append("<null>");
        }
        stringBuilder.append("]");
    }

    @Override
    protected void doStart() throws Exception {
        this.watchService = FileSystems.getDefault().newWatchService();
        this.setUpdateQuietTime(this.getUpdateQuietTimeMillis(), TimeUnit.MILLISECONDS);
        for (Config config : this.configs) {
            this.registerTree(config.getPath(), config, this.isNotifyExistingOnStart());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PathWatcher@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} -> {}", this, stringBuilder);
        }
        this.thread = new Thread((Runnable)this, stringBuilder.toString());
        this.thread.setDaemon(true);
        this.thread.start();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.watchService != null) {
            this.watchService.close();
        }
        this.watchService = null;
        this.thread = null;
        this.keys.clear();
        this.pending.clear();
        this.events.clear();
        super.doStop();
    }

    public void reset() {
        if (!this.isStopped()) {
            throw new IllegalStateException("PathWatcher must be stopped before reset.");
        }
        this.configs.clear();
        this.listeners.clear();
    }

    protected boolean isNotifiable() {
        return this.isStarted() || !this.isStarted() && this.isNotifyExistingOnStart();
    }

    public Iterator<EventListener> getListeners() {
        return this.listeners.iterator();
    }

    public long getUpdateQuietTimeMillis() {
        return TimeUnit.MILLISECONDS.convert(this.updateQuietTimeDuration, this.updateQuietTimeUnit);
    }

    private void registerTree(Path path2, Config config, boolean bl) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("registerTree {} {} {}", path2, config, bl);
        }
        if (!Files.isDirectory(path2, new LinkOption[0])) {
            throw new IllegalArgumentException(path2.toString());
        }
        this.register(path2, config);
        MultiException multiException = new MultiException();
        try (Stream<Path> stream = Files.list(path2);){
            stream.forEach(path -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("registerTree? {}", path);
                }
                try {
                    if (bl && config.test((Path)path)) {
                        this.pending.put((Path)path, new PathWatchEvent((Path)path, PathWatchEventType.ADDED, config));
                    }
                    switch (config.handleDir((Path)path)) {
                        case ENTER: {
                            this.registerTree((Path)path, config.asSubConfig((Path)path), bl);
                            break;
                        }
                        case WATCH: {
                            this.registerDir((Path)path, config);
                            break;
                        }
                    }
                }
                catch (IOException iOException) {
                    multiException.add(iOException);
                }
            });
        }
        try {
            multiException.ifExceptionThrow();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    private void registerDir(Path path, Config config) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("registerDir {} {}", path, config);
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException(path.toString());
        }
        this.register(path, config.asSubConfig(path), WATCH_DIR_KINDS);
    }

    protected void register(Path path, Config config) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering watch on {}", path);
        }
        this.register(path, config, WATCH_EVENT_KINDS);
    }

    private void register(Path path, Config config, WatchEvent.Kind<?>[] kindArray) throws IOException {
        WatchKey watchKey = path.register(this.watchService, kindArray);
        this.keys.put(watchKey, config);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting java.nio file watching with {}", this.watchService);
        }
        long l = this.getUpdateQuietTimeMillis();
        WatchService watchService = this.watchService;
        while (this.isRunning() && this.thread == Thread.currentThread()) {
            try {
                WatchKey watchKey;
                long l2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                for (Map.Entry<WatchKey, Config> entry : this.keys.entrySet()) {
                    WatchKey watchKey2 = entry.getKey();
                    Config config = entry.getValue();
                    if (config.isPaused(l2) || watchKey2.reset()) continue;
                    this.keys.remove(watchKey2);
                    if (!this.keys.isEmpty()) continue;
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Waiting for poll({})", l);
                }
                WatchKey watchKey3 = l < 0L ? watchService.take() : (watchKey = l > 0L ? watchService.poll(l, this.updateQuietTimeUnit) : watchService.poll());
                while (watchKey != null) {
                    this.handleKey(watchKey);
                    watchKey = watchService.poll();
                }
                l = this.processPending();
                this.notifyEvents();
            }
            catch (ClosedWatchServiceException closedWatchServiceException) {
                return;
            }
            catch (InterruptedException interruptedException) {
                if (this.isRunning()) {
                    LOG.warn(interruptedException);
                    continue;
                }
                LOG.ignore(interruptedException);
            }
        }
    }

    private void handleKey(WatchKey watchKey) {
        Config config = this.keys.get(watchKey);
        if (config == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("WatchKey not recognized: {}", watchKey);
            }
            return;
        }
        for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
            WatchEvent<Path> watchEvent2 = PathWatcher.cast(watchEvent);
            Path path = (Path)watchEvent2.context();
            Path path2 = config.resolve(path);
            if (LOG.isDebugEnabled()) {
                LOG.debug("handleKey? {} {} {}", watchEvent2.kind(), config.toShortPath(path2), config);
            }
            if (watchEvent2.kind() == StandardWatchEventKinds.ENTRY_MODIFY && Files.exists(path2, new LinkOption[0]) && Files.isDirectory(path2, new LinkOption[0])) continue;
            if (config.test(path2)) {
                this.handleWatchEvent(path2, new PathWatchEvent(path2, watchEvent2, config));
            } else if (config.getRecurseDepth() == -1) {
                Path path3 = path2.getParent();
                Config config2 = config.getParent();
                this.handleWatchEvent(path3, new PathWatchEvent(path3, PathWatchEventType.MODIFIED, config2));
                continue;
            }
            if (watchEvent2.kind() != StandardWatchEventKinds.ENTRY_CREATE) continue;
            try {
                switch (config.handleDir(path2)) {
                    case ENTER: {
                        this.registerTree(path2, config.asSubConfig(path2), true);
                        break;
                    }
                    case WATCH: {
                        this.registerDir(path2, config);
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                LOG.warn(iOException);
            }
        }
    }

    public void handleWatchEvent(Path path, PathWatchEvent pathWatchEvent) {
        PathWatchEvent pathWatchEvent2 = this.pending.get(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("handleWatchEvent {} {} <= {}", path, pathWatchEvent, pathWatchEvent2);
        }
        switch (pathWatchEvent.getType()) {
            case ADDED: {
                if (pathWatchEvent2 != null && pathWatchEvent2.getType() == PathWatchEventType.MODIFIED) {
                    this.events.add(new PathWatchEvent(path, PathWatchEventType.DELETED, pathWatchEvent2.getConfig()));
                }
                this.pending.put(path, pathWatchEvent);
                break;
            }
            case MODIFIED: {
                if (pathWatchEvent2 == null) {
                    this.pending.put(path, pathWatchEvent);
                    break;
                }
                pathWatchEvent2.modified();
                break;
            }
            case DELETED: 
            case UNKNOWN: {
                if (pathWatchEvent2 != null) {
                    this.pending.remove(path);
                }
                this.events.add(pathWatchEvent);
            }
        }
    }

    private long processPending() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processPending> {}", this.pending.values());
        }
        long l = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        long l2 = Long.MAX_VALUE;
        for (PathWatchEvent pathWatchEvent : new ArrayList<PathWatchEvent>(this.pending.values())) {
            Path path = pathWatchEvent.getPath();
            if (this.pending.containsKey(path.getParent())) continue;
            if (pathWatchEvent.isQuiet(l, this.getUpdateQuietTimeMillis())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("isQuiet {}", pathWatchEvent);
                }
                this.pending.remove(path);
                this.events.add(pathWatchEvent);
                continue;
            }
            long l3 = pathWatchEvent.toQuietCheck(l, this.getUpdateQuietTimeMillis());
            if (LOG.isDebugEnabled()) {
                LOG.debug("pending {} {}", pathWatchEvent, l3);
            }
            if (l3 >= l2) continue;
            l2 = l3;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processPending< {}", this.pending.values());
        }
        return l2 == Long.MAX_VALUE ? -1L : l2;
    }

    private void notifyEvents() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("notifyEvents {}", this.events.size());
        }
        if (this.events.isEmpty()) {
            return;
        }
        boolean bl = false;
        for (EventListener object : this.listeners) {
            if (object instanceof EventListListener) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("notifyEvents {} {}", object, this.events);
                    }
                    ((EventListListener)object).onPathWatchEvents(this.events);
                }
                catch (Throwable throwable) {
                    LOG.warn(throwable);
                }
                continue;
            }
            bl = true;
        }
        if (bl) {
            for (PathWatchEvent pathWatchEvent : this.events) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("notifyEvent {} {}", pathWatchEvent, this.listeners);
                }
                for (EventListener eventListener : this.listeners) {
                    if (!(eventListener instanceof Listener)) continue;
                    try {
                        ((Listener)eventListener).onPathWatchEvent(pathWatchEvent);
                    }
                    catch (Throwable throwable) {
                        LOG.warn(throwable);
                    }
                }
            }
        }
        this.events.clear();
    }

    public void setNotifyExistingOnStart(boolean bl) {
        this._notifyExistingOnStart = bl;
    }

    public boolean isNotifyExistingOnStart() {
        return this._notifyExistingOnStart;
    }

    public void setUpdateQuietTime(long l, TimeUnit timeUnit) {
        long l2 = timeUnit.toMillis(l);
        if (IS_WINDOWS && l2 < 1000L) {
            LOG.warn("Quiet Time is too low for Microsoft Windows: {} < 1000 ms (defaulting to 1000 ms)", l2);
            this.updateQuietTimeDuration = 1000L;
            this.updateQuietTimeUnit = TimeUnit.MILLISECONDS;
            return;
        }
        this.updateQuietTimeDuration = l;
        this.updateQuietTimeUnit = timeUnit;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        this.appendConfigId(stringBuilder);
        return stringBuilder.toString();
    }

    static {
        String string = System.getProperty("os.name");
        if (string == null) {
            IS_WINDOWS = false;
        } else {
            String string2 = string.toLowerCase(Locale.ENGLISH);
            IS_WINDOWS = string2.contains("windows");
        }
        LOG = Log.getLogger(PathWatcher.class);
        WATCH_EVENT_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
        WATCH_DIR_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE};
    }

    public static class PathMatcherSet
    extends HashSet<PathMatcher>
    implements Predicate<Path> {
        @Override
        public boolean test(Path path) {
            for (PathMatcher pathMatcher : this) {
                if (!pathMatcher.matches(path)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ExactPathMatcher
    implements PathMatcher {
        private final Path path;

        ExactPathMatcher(Path path) {
            this.path = path;
        }

        @Override
        public boolean matches(Path path) {
            return this.path.equals(path);
        }
    }

    public static enum PathWatchEventType {
        ADDED,
        DELETED,
        MODIFIED,
        UNKNOWN;

    }

    public class PathWatchEvent {
        private final Path path;
        private final PathWatchEventType type;
        private final Config config;
        long checked;
        long modified;
        long length;

        public PathWatchEvent(Path path, PathWatchEventType pathWatchEventType, Config config) {
            this.path = path;
            this.type = pathWatchEventType;
            this.config = config;
            this.checked = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            this.check();
        }

        public Config getConfig() {
            return this.config;
        }

        public PathWatchEvent(Path path, WatchEvent<Path> watchEvent, Config config) {
            this.path = path;
            this.type = watchEvent.kind() == StandardWatchEventKinds.ENTRY_CREATE ? PathWatchEventType.ADDED : (watchEvent.kind() == StandardWatchEventKinds.ENTRY_DELETE ? PathWatchEventType.DELETED : (watchEvent.kind() == StandardWatchEventKinds.ENTRY_MODIFY ? PathWatchEventType.MODIFIED : PathWatchEventType.UNKNOWN));
            this.config = config;
            this.checked = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            this.check();
        }

        private void check() {
            if (Files.exists(this.path, new LinkOption[0])) {
                try {
                    this.modified = Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
                    this.length = Files.size(this.path);
                }
                catch (IOException iOException) {
                    this.modified = -1L;
                    this.length = -1L;
                }
            } else {
                this.modified = -1L;
                this.length = -1L;
            }
        }

        public boolean isQuiet(long l, long l2) {
            long l3 = this.modified;
            long l4 = this.length;
            this.check();
            if (l3 == this.modified && l4 == this.length) {
                return l - this.checked >= l2;
            }
            this.checked = l;
            return false;
        }

        public long toQuietCheck(long l, long l2) {
            long l3 = l2 - (l - this.checked);
            if (l3 <= 0L) {
                return l2;
            }
            return l3;
        }

        public void modified() {
            long l;
            this.checked = l = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            this.check();
            this.config.setPauseUntil(l + PathWatcher.this.getUpdateQuietTimeMillis());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            PathWatchEvent pathWatchEvent = (PathWatchEvent)object;
            if (this.path == null ? pathWatchEvent.path != null : !this.path.equals(pathWatchEvent.path)) {
                return false;
            }
            return this.type == pathWatchEvent.type;
        }

        public Path getPath() {
            return this.path;
        }

        public PathWatchEventType getType() {
            return this.type;
        }

        @Deprecated
        public int getCount() {
            return 1;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.path == null ? 0 : this.path.hashCode());
            n2 = 31 * n2 + (this.type == null ? 0 : this.type.hashCode());
            return n2;
        }

        public String toString() {
            return String.format("PathWatchEvent[%8s|%s]", new Object[]{this.type, this.path});
        }
    }

    public static interface EventListListener
    extends EventListener {
        public void onPathWatchEvents(List<PathWatchEvent> var1);
    }

    public static interface Listener
    extends EventListener {
        public void onPathWatchEvent(PathWatchEvent var1);
    }

    public static enum DirAction {
        IGNORE,
        WATCH,
        ENTER;

    }

    public static class Config
    implements Predicate<Path> {
        public static final int UNLIMITED_DEPTH = -9999;
        private static final String PATTERN_SEP;
        protected final Config parent;
        protected final Path path;
        protected final IncludeExcludeSet<PathMatcher, Path> includeExclude;
        protected int recurseDepth = 0;
        protected boolean excludeHidden = false;
        protected long pauseUntil;

        public Config(Path path) {
            this(path, null);
        }

        public Config(Path path, Config config) {
            IncludeExcludeSet<PathMatcher, Path> includeExcludeSet;
            this.parent = config;
            if (config == null) {
                IncludeExcludeSet<PathMatcher, Path> includeExcludeSet2;
                includeExcludeSet = includeExcludeSet2;
                super(PathMatcherSet.class);
            } else {
                includeExcludeSet = config.includeExclude;
            }
            this.includeExclude = includeExcludeSet;
            Path path2 = path;
            if (!Files.exists(path, new LinkOption[0])) {
                throw new IllegalStateException("Path does not exist: " + path);
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                path2 = path.getParent();
                this.includeExclude.include(new ExactPathMatcher(path));
                this.setRecurseDepth(0);
            }
            this.path = path2;
        }

        public Config getParent() {
            return this.parent;
        }

        public void setPauseUntil(long l) {
            if (l > this.pauseUntil) {
                this.pauseUntil = l;
            }
        }

        public boolean isPaused(long l) {
            if (this.pauseUntil == 0L) {
                return false;
            }
            if (this.pauseUntil > l) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("PAUSED {}", this);
                }
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("unpaused {}", this);
            }
            this.pauseUntil = 0L;
            return false;
        }

        public void addExclude(PathMatcher pathMatcher) {
            this.includeExclude.exclude(pathMatcher);
        }

        public void addExclude(String string) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding exclude: [{}]", string);
            }
            this.addExclude(this.path.getFileSystem().getPathMatcher(string));
        }

        public void addExcludeGlobRelative(String string) {
            this.addExclude(this.toGlobPattern(this.path, string));
        }

        public void addExcludeHidden() {
            if (!this.excludeHidden) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding hidden files and directories to exclusions", new Object[0]);
                }
                this.excludeHidden = true;
            }
        }

        public void addExcludes(List<String> list) {
            for (String string : list) {
                this.addExclude(string);
            }
        }

        public void addInclude(PathMatcher pathMatcher) {
            this.includeExclude.include(pathMatcher);
        }

        public void addInclude(String string) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding include: [{}]", string);
            }
            this.addInclude(this.path.getFileSystem().getPathMatcher(string));
        }

        public void addIncludeGlobRelative(String string) {
            this.addInclude(this.toGlobPattern(this.path, string));
        }

        public void addIncludes(List<String> list) {
            for (String string : list) {
                this.addInclude(string);
            }
        }

        public Config asSubConfig(Path path) {
            Config config = new Config(path, this);
            if (path == this.path) {
                throw new IllegalStateException("sub " + path.toString() + " of " + this);
            }
            config.recurseDepth = this.recurseDepth == -9999 ? -9999 : this.recurseDepth - (path.getNameCount() - this.path.getNameCount());
            if (LOG.isDebugEnabled()) {
                LOG.debug("subconfig {} of {}", config, this.path);
            }
            return config;
        }

        public int getRecurseDepth() {
            return this.recurseDepth;
        }

        public boolean isRecurseDepthUnlimited() {
            return this.recurseDepth == -9999;
        }

        public Path getPath() {
            return this.path;
        }

        public Path resolve(Path path) {
            if (Files.isDirectory(this.path, new LinkOption[0])) {
                return this.path.resolve(path);
            }
            if (Files.exists(this.path, new LinkOption[0])) {
                return this.path;
            }
            return path;
        }

        @Override
        public boolean test(Path path) {
            int n;
            if (this.excludeHidden && this.isHidden(path)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("test({}) -> [Hidden]", this.toShortPath(path));
                }
                return false;
            }
            if (!path.startsWith(this.path)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("test({}) -> [!child {}]", this.toShortPath(path), this.path);
                }
                return false;
            }
            if (this.recurseDepth != -9999 && (n = path.getNameCount() - this.path.getNameCount() - 1) > this.recurseDepth) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("test({}) -> [depth {}>{}]", this.toShortPath(path), n, this.recurseDepth);
                }
                return false;
            }
            n = this.includeExclude.test(path);
            if (LOG.isDebugEnabled()) {
                LOG.debug("test({}) -> {}", this.toShortPath(path), n != 0);
            }
            return n != 0;
        }

        public void setRecurseDepth(int n) {
            this.recurseDepth = n;
        }

        private String toGlobPattern(Path path, String string) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("glob:");
            boolean bl = false;
            Path path2 = path.getRoot();
            if (path2 != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Path: {} -> Root: {}", path, path2);
                }
                for (Object object : (Object)path2.toString().toCharArray()) {
                    if (object == 92) {
                        stringBuilder.append(PATTERN_SEP);
                        continue;
                    }
                    stringBuilder.append((char)object);
                }
            } else {
                bl = true;
            }
            for (Path path3 : path) {
                if (bl) {
                    stringBuilder.append(PATTERN_SEP);
                }
                stringBuilder.append(path3);
                bl = true;
            }
            if (string != null && string.length() > 0) {
                if (bl) {
                    stringBuilder.append(PATTERN_SEP);
                }
                for (Object object : (Object)string.toCharArray()) {
                    if (object == 47) {
                        stringBuilder.append(PATTERN_SEP);
                        continue;
                    }
                    stringBuilder.append((char)object);
                }
            }
            return stringBuilder.toString();
        }

        DirAction handleDir(Path path) {
            try {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    return DirAction.IGNORE;
                }
                if (this.excludeHidden && this.isHidden(path)) {
                    return DirAction.IGNORE;
                }
                if (this.getRecurseDepth() == 0) {
                    return DirAction.WATCH;
                }
                return DirAction.ENTER;
            }
            catch (Exception exception) {
                LOG.ignore(exception);
                return DirAction.IGNORE;
            }
        }

        public boolean isHidden(Path path) {
            try {
                if (!path.startsWith(this.path)) {
                    return true;
                }
                for (int i = this.path.getNameCount(); i < path.getNameCount(); ++i) {
                    if (!path.getName(i).toString().startsWith(".")) continue;
                    return true;
                }
                return Files.exists(path, new LinkOption[0]) && Files.isHidden(path);
            }
            catch (IOException iOException) {
                LOG.ignore(iOException);
                return false;
            }
        }

        public String toShortPath(Path path) {
            if (!path.startsWith(this.path)) {
                return path.toString();
            }
            return this.path.relativize(path).toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.path).append(" [depth=");
            if (this.recurseDepth == -9999) {
                stringBuilder.append("UNLIMITED");
            } else {
                stringBuilder.append(this.recurseDepth);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        static {
            String string = File.separator;
            if (File.separatorChar == '\\') {
                string = "\\\\";
            }
            PATTERN_SEP = string;
        }
    }
}

