/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class ManifestUtils {
    private ManifestUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<Manifest> getManifest(Class<?> clazz) {
        try {
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource == null) return Optional.empty();
            URL uRL = codeSource.getLocation();
            if (uRL == null) return Optional.empty();
            try (JarFile jarFile = new JarFile(new File(uRL.toURI()));){
                Optional<Manifest> optional = Optional.of(jarFile.getManifest());
                return optional;
            }
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    public static Optional<String> getVersion(Class<?> clazz) {
        Optional<String> optional = ManifestUtils.getManifest(clazz).map(Manifest::getMainAttributes).map(attributes -> attributes.getValue("Implementation-Version"));
        if (optional.isPresent()) {
            return optional;
        }
        try {
            Object object = clazz.getClass().getMethod("getModule", new Class[0]).invoke(clazz, new Object[0]);
            Object object2 = object.getClass().getMethod("getDescriptor", new Class[0]).invoke(object, new Object[0]);
            return (Optional)object2.getClass().getMethod("rawVersion", new Class[0]).invoke(object2, new Object[0]);
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }
}

