/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class IO {
    private static final Logger LOG = Log.getLogger(IO.class);
    public static final String CRLF = "\r\n";
    public static final byte[] CRLF_BYTES = new byte[]{13, 10};
    public static final int bufferSize = 65536;
    private static NullOS __nullStream = new NullOS();
    private static ClosedIS __closedStream = new ClosedIS();
    private static NullWrite __nullWriter = new NullWrite();
    private static PrintWriter __nullPrintWriter = new PrintWriter(__nullWriter);

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        IO.copy(inputStream, outputStream, -1L);
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        IO.copy(reader, writer, -1L);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        byte[] byArray = new byte[65536];
        int n = 65536;
        if (l >= 0L) {
            int n2;
            while (l > 0L && (n = inputStream.read(byArray, 0, n2 = l < 65536L ? (int)l : 65536)) != -1) {
                l -= (long)n;
                outputStream.write(byArray, 0, n);
            }
        } else {
            while ((n = inputStream.read(byArray, 0, 65536)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
        }
    }

    public static void copy(Reader reader, Writer writer, long l) throws IOException {
        char[] cArray = new char[65536];
        int n = 65536;
        if (l >= 0L) {
            while (l > 0L && (n = l < 65536L ? reader.read(cArray, 0, (int)l) : reader.read(cArray, 0, 65536)) != -1) {
                l -= (long)n;
                writer.write(cArray, 0, n);
            }
        } else if (writer instanceof PrintWriter) {
            PrintWriter printWriter = (PrintWriter)writer;
            while (!printWriter.checkError() && (n = reader.read(cArray, 0, 65536)) != -1) {
                writer.write(cArray, 0, n);
            }
        } else {
            while ((n = reader.read(cArray, 0, 65536)) != -1) {
                writer.write(cArray, 0, n);
            }
        }
    }

    public static void copy(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            IO.copyDir(file, file2);
        } else {
            IO.copyFile(file, file2);
        }
    }

    public static void copyDir(File file, File file2) throws IOException {
        File[] fileArray;
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                throw new IllegalArgumentException(file2.toString());
            }
        } else {
            file2.mkdirs();
        }
        if ((fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getName();
                if (".".equals(string) || "..".equals(string)) continue;
                IO.copy(fileArray[i], new File(file2, string));
            }
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);
             FileOutputStream fileOutputStream = new FileOutputStream(file2);){
            IO.copy(fileInputStream, fileOutputStream);
        }
    }

    public static String toString(Path path, Charset charset) throws IOException {
        byte[] byArray = Files.readAllBytes(path);
        return new String(byArray, charset);
    }

    public static String toString(InputStream inputStream) throws IOException {
        return IO.toString(inputStream, (Charset)null);
    }

    public static String toString(InputStream inputStream, String string) throws IOException {
        return IO.toString(inputStream, string == null ? null : Charset.forName(string));
    }

    public static String toString(InputStream inputStream, Charset charset) throws IOException {
        StringWriter stringWriter = new StringWriter();
        InputStreamReader inputStreamReader = charset == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, charset);
        IO.copy(inputStreamReader, stringWriter);
        return stringWriter.toString();
    }

    public static String toString(Reader reader) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IO.copy(reader, stringWriter);
        return stringWriter.toString();
    }

    public static boolean delete(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                IO.delete(fileArray[i]);
            }
        }
        return file.delete();
    }

    public static boolean isEmptyDir(File file) {
        if (file == null) {
            return true;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return true;
        }
        return stringArray.length <= 0;
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            LOG.ignore(iOException);
        }
    }

    public static void close(InputStream inputStream) {
        IO.close((Closeable)inputStream);
    }

    public static void close(OutputStream outputStream) {
        IO.close((Closeable)outputStream);
    }

    public static void close(Reader reader) {
        IO.close((Closeable)reader);
    }

    public static void close(Writer writer) {
        IO.close((Closeable)writer);
    }

    public static byte[] readBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IO.copy(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static long write(GatheringByteChannel gatheringByteChannel, ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l;
        long l2 = 0L;
        block0: while (n2 > 0 && (l = gatheringByteChannel.write(byteBufferArray, n, n2)) != 0L) {
            l2 += l;
            for (int i = n; i < byteBufferArray.length; ++i) {
                if (!byteBufferArray[i].hasRemaining()) continue;
                n2 -= i - n;
                n = i;
                continue block0;
            }
            n2 = 0;
        }
        return l2;
    }

    public static OutputStream getNullStream() {
        return __nullStream;
    }

    public static InputStream getClosedStream() {
        return __closedStream;
    }

    public static Writer getNullWriter() {
        return __nullWriter;
    }

    public static PrintWriter getNullPrintWriter() {
        return __nullPrintWriter;
    }

    private static class NullWrite
    extends Writer {
        private NullWrite() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(char[] cArray) {
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
        }

        @Override
        public void write(int n) {
        }

        @Override
        public void write(String string) {
        }

        @Override
        public void write(String string, int n, int n2) {
        }
    }

    private static class ClosedIS
    extends InputStream {
        private ClosedIS() {
        }

        @Override
        public int read() throws IOException {
            return -1;
        }
    }

    private static class NullOS
    extends OutputStream {
        private NullOS() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] byArray) {
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
        }

        @Override
        public void write(int n) {
        }
    }

    static class Job
    implements Runnable {
        InputStream in;
        OutputStream out;
        Reader read;
        Writer write;

        Job(InputStream inputStream, OutputStream outputStream) {
            this.in = inputStream;
            this.out = outputStream;
            this.read = null;
            this.write = null;
        }

        Job(Reader reader, Writer writer) {
            this.in = null;
            this.out = null;
            this.read = reader;
            this.write = writer;
        }

        @Override
        public void run() {
            try {
                if (this.in != null) {
                    IO.copy(this.in, this.out, -1L);
                } else {
                    IO.copy(this.read, this.write, -1L);
                }
            }
            catch (IOException iOException) {
                LOG.ignore(iOException);
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                    if (this.write != null) {
                        this.write.close();
                    }
                }
                catch (IOException iOException2) {
                    LOG.ignore(iOException2);
                }
            }
        }
    }
}

