/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class ClassLoadingObjectInputStream
extends ObjectInputStream {
    private ThreadLocal<ClassLoader> _classloader = new ClassLoaderThreadLocal();

    public ClassLoadingObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public ClassLoadingObjectInputStream() throws IOException {
    }

    public Object readObject(ClassLoader classLoader) throws IOException, ClassNotFoundException {
        try {
            this._classloader.set(classLoader);
            Object object = this.readObject();
            return object;
        }
        finally {
            this._classloader.set(ClassLoaderThreadLocal.UNSET);
        }
    }

    @Override
    public Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        try {
            ClassLoader classLoader = this._classloader.get();
            if (ClassLoaderThreadLocal.UNSET == classLoader) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            return Class.forName(objectStreamClass.getName(), false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.resolveClass(objectStreamClass);
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = null;
        boolean bl = false;
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Class<?> clazz = Class.forName(stringArray[i], false, classLoader);
            if ((clazz.getModifiers() & 1) == 0) {
                if (bl) {
                    if (classLoader2 != clazz.getClassLoader()) {
                        throw new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                } else {
                    classLoader2 = clazz.getClassLoader();
                    bl = true;
                }
            }
            classArray[i] = clazz;
        }
        try {
            return Proxy.getProxyClass(bl ? classLoader2 : classLoader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(null, illegalArgumentException);
        }
    }

    protected static class ClassLoaderThreadLocal
    extends ThreadLocal<ClassLoader> {
        protected static final ClassLoader UNSET = new ClassLoader(){};

        protected ClassLoaderThreadLocal() {
        }

        @Override
        protected ClassLoader initialValue() {
            return UNSET;
        }
    }
}

