/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.util.AbstractTrie;
import org.eclipse.jetty.util.MathUtils;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;

public class ArrayTernaryTrie<V>
extends AbstractTrie<V> {
    private static int LO = 1;
    private static int EQ = 2;
    private static int HI = 3;
    private static final int ROW_SIZE = 4;
    public static final int MAX_CAPACITY = 65534;
    private final char[] _tree;
    private final String[] _key;
    private final V[] _value;
    private char _rows;

    public ArrayTernaryTrie() {
        this(128);
    }

    public ArrayTernaryTrie(boolean bl) {
        this(bl, 128);
    }

    public ArrayTernaryTrie(int n) {
        this(true, n);
    }

    public ArrayTernaryTrie(boolean bl, int n) {
        super(bl);
        if (n > 65534) {
            throw new IllegalArgumentException("Capacity " + n + " > " + 65534);
        }
        this._value = new Object[n + 1];
        this._tree = new char[(n + 1) * 4];
        this._key = new String[n + 1];
    }

    public ArrayTernaryTrie(ArrayTernaryTrie<V> arrayTernaryTrie, double d) {
        super(arrayTernaryTrie.isCaseInsensitive());
        int n = (int)((double)arrayTernaryTrie._value.length * d);
        if (n > 65534) {
            throw new IllegalArgumentException("Capacity " + n + " > " + 65534);
        }
        this._rows = arrayTernaryTrie._rows;
        this._value = Arrays.copyOf(arrayTernaryTrie._value, n);
        this._tree = Arrays.copyOf(arrayTernaryTrie._tree, n * 4);
        this._key = Arrays.copyOf(arrayTernaryTrie._key, n);
    }

    @Override
    public void clear() {
        this._rows = '\u0000';
        Arrays.fill(this._value, null);
        Arrays.fill(this._tree, '\u0000');
        Arrays.fill(this._key, null);
    }

    @Override
    public boolean put(String string, V v) {
        char c = '\u0000';
        int n = string.length();
        if (n > 65534) {
            return false;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            char c2 = string.charAt(i);
            if (this.isCaseInsensitive() && c2 < '\u0080') {
                c2 = StringUtil.lowercases[c2];
            }
            do {
                char c3;
                if (this._rows == '\ufffe') {
                    return false;
                }
                int n4 = 4 * c;
                if (c == this._rows) {
                    this._rows = (char)MathUtils.cappedAdd(this._rows, 1, this._key.length);
                    if (this._rows == this._key.length) {
                        return false;
                    }
                    this._tree[n4] = c2;
                }
                if ((n3 = (c3 = this._tree[n4]) - c2) == 0) {
                    n2 = n4 + EQ;
                    c = this._tree[n2];
                } else if (n3 < 0) {
                    n2 = n4 + LO;
                    c = this._tree[n2];
                } else {
                    n2 = n4 + HI;
                    c = this._tree[n2];
                }
                if (c != '\u0000') continue;
                c = this._rows;
                this._tree[n2] = c;
            } while (n3 != 0);
        }
        if (c == this._rows) {
            if (this._rows == this._key.length) {
                return false;
            }
            this._rows = (char)(this._rows + '\u0001');
        }
        this._key[c] = v == null ? null : string;
        this._value[c] = v;
        return true;
    }

    @Override
    public V get(String string, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        block0: while (n4 < n2) {
            int n5;
            int n6;
            char c = string.charAt(n + n4++);
            if (this.isCaseInsensitive() && c < '\u0080') {
                c = StringUtil.lowercases[c];
            }
            do {
                char c2;
                if ((n5 = (c2 = this._tree[n6 = 4 * n3]) - c) != 0) continue;
                n3 = this._tree[n6 + EQ];
                if (n3 != 0) continue block0;
                return null;
            } while ((n3 = this._tree[n6 + ArrayTernaryTrie.hilo(n5)]) != 0);
            return null;
        }
        return this._value[n3];
    }

    @Override
    public V get(ByteBuffer byteBuffer, int n, int n2) {
        int n3 = 0;
        n += byteBuffer.position();
        int n4 = 0;
        block0: while (n4 < n2) {
            int n5;
            int n6;
            byte by = (byte)(byteBuffer.get(n + n4++) & 0x7F);
            if (this.isCaseInsensitive()) {
                by = (byte)StringUtil.lowercases[by];
            }
            do {
                char c;
                if ((n5 = (c = this._tree[n6 = 4 * n3]) - by) != 0) continue;
                n3 = this._tree[n6 + EQ];
                if (n3 != 0) continue block0;
                return null;
            } while ((n3 = this._tree[n6 + ArrayTernaryTrie.hilo(n5)]) != 0);
            return null;
        }
        return this._value[n3];
    }

    @Override
    public V getBest(String string) {
        return this.getBest(0, string, 0, string.length());
    }

    @Override
    public V getBest(String string, int n, int n2) {
        return this.getBest(0, string, n, n2);
    }

    private V getBest(int n, String string, int n2, int n3) {
        int n4 = n;
        int n5 = n2 + n3;
        block0: while (n2 < n5) {
            int n6;
            int n7;
            char c = string.charAt(n2++);
            --n3;
            if (this.isCaseInsensitive() && c < '\u0080') {
                c = StringUtil.lowercases[c];
            }
            do {
                char c2;
                if ((n6 = (c2 = this._tree[n7 = 4 * n]) - c) != 0) continue;
                n = this._tree[n7 + EQ];
                if (n == 0) break block0;
                if (this._key[n] == null) continue block0;
                n4 = n;
                V v = this.getBest(n, string, n2, n3);
                if (v == null) continue block0;
                return v;
            } while ((n = this._tree[n7 + ArrayTernaryTrie.hilo(n6)]) != 0);
            break;
        }
        return this._value[n4];
    }

    @Override
    public V getBest(ByteBuffer byteBuffer, int n, int n2) {
        if (byteBuffer.hasArray()) {
            return this.getBest(0, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position() + n, n2);
        }
        return this.getBest(0, byteBuffer, n, n2);
    }

    @Override
    public V getBest(byte[] byArray, int n, int n2) {
        return this.getBest(0, byArray, n, n2);
    }

    private V getBest(int n, byte[] byArray, int n2, int n3) {
        int n4 = n;
        int n5 = n2 + n3;
        block0: while (n2 < n5) {
            int n6;
            int n7;
            byte by = (byte)(byArray[n2++] & 0x7F);
            --n3;
            if (this.isCaseInsensitive()) {
                by = (byte)StringUtil.lowercases[by];
            }
            do {
                char c;
                if ((n6 = (c = this._tree[n7 = 4 * n]) - by) != 0) continue;
                n = this._tree[n7 + EQ];
                if (n == 0) break block0;
                if (this._key[n] == null) continue block0;
                n4 = n;
                V v = this.getBest(n, byArray, n2, n3);
                if (v == null) continue block0;
                return v;
            } while ((n = this._tree[n7 + ArrayTernaryTrie.hilo(n6)]) != 0);
            break;
        }
        return this._value[n4];
    }

    private V getBest(int n, ByteBuffer byteBuffer, int n2, int n3) {
        int n4 = n;
        int n5 = n2 + byteBuffer.position();
        block0: for (int i = 0; i < n3; ++i) {
            int n6;
            int n7;
            if (n5 + i >= byteBuffer.limit()) {
                return null;
            }
            byte by = (byte)(byteBuffer.get(n5 + i) & 0x7F);
            if (this.isCaseInsensitive()) {
                by = (byte)StringUtil.lowercases[by];
            }
            do {
                char c;
                if ((n6 = (c = this._tree[n7 = 4 * n]) - by) != 0) continue;
                n = this._tree[n7 + EQ];
                if (n == 0) break block0;
                if (this._key[n] == null) continue block0;
                n4 = n;
                V v = this.getBest(n, byteBuffer, n2 + i + 1, n3 - i - 1);
                if (v == null) continue block0;
                return v;
            } while ((n = this._tree[n7 + ArrayTernaryTrie.hilo(n6)]) != 0);
            break;
        }
        return this._value[n4];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this._rows; ++i) {
            if (this._key[i] == null || this._value[i] == null) continue;
            stringBuilder.append(',');
            stringBuilder.append(this._key[i]);
            stringBuilder.append('=');
            stringBuilder.append(this._value[i].toString());
        }
        if (stringBuilder.length() == 0) {
            return "{}";
        }
        stringBuilder.setCharAt(0, '{');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this._rows; ++i) {
            if (this._key[i] == null || this._value[i] == null) continue;
            hashSet.add(this._key[i]);
        }
        return hashSet;
    }

    public int size() {
        int n = 0;
        for (int i = 0; i < this._rows; ++i) {
            if (this._key[i] == null || this._value[i] == null) continue;
            ++n;
        }
        return n;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this._rows; ++i) {
            if (this._key[i] == null || this._value[i] == null) continue;
            return false;
        }
        return true;
    }

    public Set<Map.Entry<String, V>> entrySet() {
        HashSet<Map.Entry<String, V>> hashSet = new HashSet<Map.Entry<String, V>>();
        for (int i = 0; i < this._rows; ++i) {
            if (this._key[i] == null || this._value[i] == null) continue;
            hashSet.add(new AbstractMap.SimpleEntry<String, V>(this._key[i], this._value[i]));
        }
        return hashSet;
    }

    @Override
    public boolean isFull() {
        return this._rows == this._key.length;
    }

    public static int hilo(int n) {
        return 1 + (n | Integer.MAX_VALUE) / 0x3FFFFFFF;
    }

    public void dump() {
        for (int i = 0; i < this._rows; ++i) {
            char c = this._tree[i * 4 + 0];
            System.err.printf("%4d [%s,%d,%d,%d] '%s':%s%n", i, c < ' ' || c > '\u007f' ? "" + c : "'" + c + "'", (int)this._tree[i * 4 + LO], (int)this._tree[i * 4 + EQ], (int)this._tree[i * 4 + HI], this._key[i], this._value[i]);
        }
    }

    public static class Growing<V>
    implements Trie<V> {
        private final int _growby;
        private ArrayTernaryTrie<V> _trie;

        public Growing() {
            this(1024, 1024);
        }

        public Growing(int n, int n2) {
            this._growby = n2;
            this._trie = new ArrayTernaryTrie(n);
        }

        public Growing(boolean bl, int n, int n2) {
            this._growby = n2;
            this._trie = new ArrayTernaryTrie(bl, n);
        }

        @Override
        public boolean put(V v) {
            return this.put(v.toString(), v);
        }

        public int hashCode() {
            return this._trie.hashCode();
        }

        @Override
        public V remove(String string) {
            return this._trie.remove(string);
        }

        @Override
        public V get(String string) {
            return this._trie.get(string);
        }

        @Override
        public V get(ByteBuffer byteBuffer) {
            return this._trie.get(byteBuffer);
        }

        @Override
        public V getBest(byte[] byArray, int n, int n2) {
            return this._trie.getBest(byArray, n, n2);
        }

        @Override
        public boolean isCaseInsensitive() {
            return this._trie.isCaseInsensitive();
        }

        public boolean equals(Object object) {
            return this._trie.equals(object);
        }

        @Override
        public void clear() {
            this._trie.clear();
        }

        @Override
        public boolean put(String string, V v) {
            boolean bl = this._trie.put(string, v);
            while (!bl && this._growby > 0) {
                int n = ((ArrayTernaryTrie)this._trie)._key.length + this._growby;
                if (n > 65534) {
                    return false;
                }
                ArrayTernaryTrie<V> arrayTernaryTrie = new ArrayTernaryTrie<V>(this._trie.isCaseInsensitive(), n);
                for (Map.Entry<String, V> entry : this._trie.entrySet()) {
                    arrayTernaryTrie.put(entry.getKey(), entry.getValue());
                }
                this._trie = arrayTernaryTrie;
                bl = this._trie.put(string, v);
            }
            return bl;
        }

        @Override
        public V get(String string, int n, int n2) {
            return this._trie.get(string, n, n2);
        }

        @Override
        public V get(ByteBuffer byteBuffer, int n, int n2) {
            return this._trie.get(byteBuffer, n, n2);
        }

        @Override
        public V getBest(String string) {
            return this._trie.getBest(string);
        }

        @Override
        public V getBest(String string, int n, int n2) {
            return this._trie.getBest(string, n, n2);
        }

        @Override
        public V getBest(ByteBuffer byteBuffer, int n, int n2) {
            return this._trie.getBest(byteBuffer, n, n2);
        }

        public String toString() {
            return this._trie.toString();
        }

        @Override
        public Set<String> keySet() {
            return this._trie.keySet();
        }

        @Override
        public boolean isFull() {
            return false;
        }

        public void dump() {
            this._trie.dump();
        }

        public boolean isEmpty() {
            return this._trie.isEmpty();
        }

        public int size() {
            return this._trie.size();
        }
    }
}

