/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.Trie;

public abstract class AbstractTrie<V>
implements Trie<V> {
    final boolean _caseInsensitive;

    protected AbstractTrie(boolean bl) {
        this._caseInsensitive = bl;
    }

    @Override
    public boolean put(V v) {
        return this.put(v.toString(), v);
    }

    @Override
    public V remove(String string) {
        V v = this.get(string);
        this.put(string, null);
        return v;
    }

    @Override
    public V get(String string) {
        return this.get(string, 0, string.length());
    }

    @Override
    public V get(ByteBuffer byteBuffer) {
        return this.get(byteBuffer, 0, byteBuffer.remaining());
    }

    @Override
    public V getBest(String string) {
        return this.getBest(string, 0, string.length());
    }

    @Override
    public V getBest(byte[] byArray, int n, int n2) {
        return this.getBest(new String(byArray, n, n2, StandardCharsets.ISO_8859_1));
    }

    @Override
    public boolean isCaseInsensitive() {
        return this._caseInsensitive;
    }
}

