/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.ThreadPoolBudget;

@ManagedObject(value="Manager of the NIO Selectors")
public abstract class SelectorManager
extends ContainerLifeCycle
implements Dumpable {
    public static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    protected static final Logger LOG = Log.getLogger(SelectorManager.class);
    private final Executor executor;
    private final Scheduler scheduler;
    private final ManagedSelector[] _selectors;
    private final AtomicInteger _selectorIndex = new AtomicInteger();
    private final IntUnaryOperator _selectorIndexUpdate;
    private final List<AcceptListener> _acceptListeners = new ArrayList<AcceptListener>();
    private long _connectTimeout = 15000L;
    private ThreadPoolBudget.Lease _lease;

    private static int defaultSelectors(Executor executor) {
        if (executor instanceof ThreadPool.SizedThreadPool) {
            int n = ((ThreadPool.SizedThreadPool)executor).getMaxThreads();
            int n2 = ProcessorUtils.availableProcessors();
            return Math.max(1, Math.min(n2 / 2, n / 16));
        }
        return Math.max(1, ProcessorUtils.availableProcessors() / 2);
    }

    protected SelectorManager(Executor executor, Scheduler scheduler) {
        this(executor, scheduler, -1);
    }

    protected SelectorManager(Executor executor, Scheduler scheduler, int n2) {
        if (n2 <= 0) {
            n2 = SelectorManager.defaultSelectors(executor);
        }
        this.executor = executor;
        this.scheduler = scheduler;
        this._selectors = new ManagedSelector[n2];
        this._selectorIndexUpdate = n -> (n + 1) % this._selectors.length;
    }

    @ManagedAttribute(value="The Executor")
    public Executor getExecutor() {
        return this.executor;
    }

    @ManagedAttribute(value="The Scheduler")
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @ManagedAttribute(value="The Connection timeout (ms)")
    public long getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(long l) {
        this._connectTimeout = l;
    }

    @Deprecated
    public int getReservedThreads() {
        return -1;
    }

    @Deprecated
    public void setReservedThreads(int n) {
        throw new UnsupportedOperationException();
    }

    protected void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    @ManagedAttribute(value="The number of NIO Selectors")
    public int getSelectorCount() {
        return this._selectors.length;
    }

    private ManagedSelector chooseSelector() {
        return this._selectors[this._selectorIndex.updateAndGet(this._selectorIndexUpdate)];
    }

    public void connect(SelectableChannel selectableChannel, Object object) {
        ManagedSelector managedSelector;
        ManagedSelector managedSelector2 = managedSelector = this.chooseSelector();
        Objects.requireNonNull(managedSelector2);
        managedSelector.submit(managedSelector2.new ManagedSelector.Connect(selectableChannel, object));
    }

    public void accept(SelectableChannel selectableChannel) {
        this.accept(selectableChannel, null);
    }

    public void accept(SelectableChannel selectableChannel, Object object) {
        ManagedSelector managedSelector;
        ManagedSelector managedSelector2 = managedSelector = this.chooseSelector();
        Objects.requireNonNull(managedSelector2);
        managedSelector.submit(managedSelector2.new ManagedSelector.Accept(selectableChannel, object));
    }

    public Closeable acceptor(SelectableChannel selectableChannel) {
        ManagedSelector managedSelector;
        ManagedSelector managedSelector2 = managedSelector = this.chooseSelector();
        Objects.requireNonNull(managedSelector2);
        ManagedSelector.Acceptor acceptor = managedSelector2.new ManagedSelector.Acceptor(selectableChannel);
        managedSelector.submit(acceptor);
        return acceptor;
    }

    protected void accepted(SelectableChannel selectableChannel) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doStart() throws Exception {
        this._lease = ThreadPoolBudget.leaseFrom(this.getExecutor(), this, this._selectors.length);
        for (int i = 0; i < this._selectors.length; ++i) {
            ManagedSelector managedSelector;
            this._selectors[i] = managedSelector = this.newSelector(i);
            this.addBean(managedSelector);
        }
        super.doStart();
    }

    protected ManagedSelector newSelector(int n) {
        return new ManagedSelector(this, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        try {
            super.doStop();
        }
        finally {
            for (ManagedSelector managedSelector : this._selectors) {
                if (managedSelector == null) continue;
                this.removeBean(managedSelector);
            }
            Arrays.fill(this._selectors, null);
            if (this._lease != null) {
                this._lease.close();
            }
        }
    }

    protected void endPointOpened(EndPoint endPoint) {
    }

    protected void endPointClosed(EndPoint endPoint) {
    }

    public void connectionOpened(Connection connection) {
        try {
            connection.onOpen();
        }
        catch (Throwable throwable) {
            if (this.isRunning()) {
                LOG.warn("Exception while notifying connection " + connection, throwable);
            } else {
                LOG.debug("Exception while notifying connection " + connection, throwable);
            }
            throw throwable;
        }
    }

    public void connectionClosed(Connection connection) {
        try {
            connection.onClose();
        }
        catch (Throwable throwable) {
            LOG.debug("Exception while notifying connection " + connection, throwable);
        }
    }

    protected boolean doFinishConnect(SelectableChannel selectableChannel) throws IOException {
        return ((SocketChannel)selectableChannel).finishConnect();
    }

    protected boolean isConnectionPending(SelectableChannel selectableChannel) {
        return ((SocketChannel)selectableChannel).isConnectionPending();
    }

    protected SelectableChannel doAccept(SelectableChannel selectableChannel) throws IOException {
        return ((ServerSocketChannel)selectableChannel).accept();
    }

    protected void connectionFailed(SelectableChannel selectableChannel, Throwable throwable, Object object) {
        LOG.warn(String.format("%s - %s", selectableChannel, object), throwable);
    }

    protected Selector newSelector() throws IOException {
        return Selector.open();
    }

    protected abstract EndPoint newEndPoint(SelectableChannel var1, ManagedSelector var2, SelectionKey var3) throws IOException;

    public abstract Connection newConnection(SelectableChannel var1, EndPoint var2, Object var3) throws IOException;

    public void addEventListener(EventListener eventListener) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.toString());
        }
        if (eventListener instanceof AcceptListener) {
            this.addAcceptListener((AcceptListener)eventListener);
        }
    }

    public void removeEventListener(EventListener eventListener) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.toString());
        }
        if (eventListener instanceof AcceptListener) {
            this.removeAcceptListener((AcceptListener)eventListener);
        }
    }

    public void addAcceptListener(AcceptListener acceptListener) {
        if (!this._acceptListeners.contains(acceptListener)) {
            this._acceptListeners.add(acceptListener);
        }
    }

    public void removeAcceptListener(AcceptListener acceptListener) {
        this._acceptListeners.remove(acceptListener);
    }

    protected void onAccepting(SelectableChannel selectableChannel) {
        for (AcceptListener acceptListener : this._acceptListeners) {
            try {
                acceptListener.onAccepting(selectableChannel);
            }
            catch (Throwable throwable) {
                LOG.warn(throwable);
            }
        }
    }

    protected void onAcceptFailed(SelectableChannel selectableChannel, Throwable throwable) {
        for (AcceptListener acceptListener : this._acceptListeners) {
            try {
                acceptListener.onAcceptFailed(selectableChannel, throwable);
            }
            catch (Throwable throwable2) {
                LOG.warn(throwable2);
            }
        }
    }

    protected void onAccepted(SelectableChannel selectableChannel) {
        for (AcceptListener acceptListener : this._acceptListeners) {
            try {
                acceptListener.onAccepted(selectableChannel);
            }
            catch (Throwable throwable) {
                LOG.warn(throwable);
            }
        }
    }

    public static interface AcceptListener
    extends EventListener {
        default public void onAccepting(SelectableChannel selectableChannel) {
        }

        default public void onAcceptFailed(SelectableChannel selectableChannel, Throwable throwable) {
        }

        default public void onAccepted(SelectableChannel selectableChannel) {
        }
    }
}

