/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import org.eclipse.jetty.http.pathmap.AbstractPathSpec;
import org.eclipse.jetty.http.pathmap.MatchedPath;
import org.eclipse.jetty.http.pathmap.PathSpecGroup;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ServletPathSpec
extends AbstractPathSpec {
    private static final Logger LOG = Log.getLogger(ServletPathSpec.class);
    private final String _declaration;
    private final PathSpecGroup _group;
    private final int _pathDepth;
    private final int _specLength;
    private final int _matchLength;
    private final String _prefix;
    private final String _suffix;
    private final MatchedPath _preMatchedPath;

    public static String normalize(String string) {
        if (StringUtil.isNotBlank(string) && !string.startsWith("/") && !string.startsWith("*")) {
            return "/" + string;
        }
        return string;
    }

    public ServletPathSpec(String string) {
        MatchedPath matchedPath;
        String string2;
        String string3;
        PathSpecGroup pathSpecGroup;
        if (string == null) {
            string = "";
        }
        if (string.startsWith("servlet|")) {
            string = string.substring("servlet|".length());
        }
        ServletPathSpec.assertValidServletPathSpec(string);
        if (string.isEmpty()) {
            this._declaration = "";
            this._group = PathSpecGroup.ROOT;
            this._pathDepth = -1;
            this._specLength = 1;
            this._matchLength = 0;
            this._prefix = null;
            this._suffix = null;
            this._preMatchedPath = MatchedPath.from("", "/");
            return;
        }
        if ("/".equals(string)) {
            this._declaration = "/";
            this._group = PathSpecGroup.DEFAULT;
            this._pathDepth = -1;
            this._specLength = 1;
            this._matchLength = 0;
            this._prefix = null;
            this._suffix = null;
            this._preMatchedPath = null;
            return;
        }
        int n = string.length();
        if (string.charAt(0) == '/' && string.endsWith("/*")) {
            pathSpecGroup = PathSpecGroup.PREFIX_GLOB;
            string3 = string.substring(0, n - 2);
            string2 = null;
            matchedPath = MatchedPath.from(string3, null);
        } else if (string.charAt(0) == '*' && string.length() > 1) {
            pathSpecGroup = PathSpecGroup.SUFFIX_GLOB;
            string3 = null;
            string2 = string.substring(2, n);
            matchedPath = null;
        } else {
            pathSpecGroup = PathSpecGroup.EXACT;
            string3 = string;
            string2 = null;
            if (string.endsWith("*")) {
                LOG.warn("Suspicious URL pattern: '{}'; see sections 12.1 and 12.2 of the Servlet specification", string);
            }
            matchedPath = MatchedPath.from(string, null);
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0080' || c != '/') continue;
            ++n2;
        }
        this._declaration = string;
        this._group = pathSpecGroup;
        this._pathDepth = n2;
        this._specLength = n;
        this._matchLength = string3 == null ? 0 : string3.length();
        this._prefix = string3;
        this._suffix = string2;
        this._preMatchedPath = matchedPath;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating {}[{}] (group: {}, prefix: \"{}\", suffix: \"{}\")", new Object[]{this.getClass().getSimpleName(), this._declaration, this._group, this._prefix, this._suffix});
        }
    }

    private static void assertValidServletPathSpec(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        int n = string.length();
        if (string.charAt(0) == '/') {
            if (n == 1) {
                return;
            }
            int n2 = string.indexOf(42);
            if (n2 < 0) {
                return;
            }
            if (n2 != n - 1) {
                throw new IllegalArgumentException("Servlet Spec 12.2 violation: glob '*' can only exist at end of prefix based matches: bad spec \"" + string + "\"");
            }
        } else if (string.startsWith("*.")) {
            int n3 = string.indexOf(47);
            if (n3 >= 0) {
                throw new IllegalArgumentException("Servlet Spec 12.2 violation: suffix based path spec cannot have path separators: bad spec \"" + string + "\"");
            }
            n3 = string.indexOf(42, 2);
            if (n3 >= 1) {
                throw new IllegalArgumentException("Servlet Spec 12.2 violation: suffix based path spec cannot have multiple glob '*': bad spec \"" + string + "\"");
            }
        } else {
            throw new IllegalArgumentException("Servlet Spec 12.2 violation: path spec must start with \"/\" or \"*.\": bad spec \"" + string + "\"");
        }
    }

    @Override
    public int getSpecLength() {
        return this._specLength;
    }

    @Override
    public PathSpecGroup getGroup() {
        return this._group;
    }

    @Override
    public int getPathDepth() {
        return this._pathDepth;
    }

    @Override
    @Deprecated
    public String getPathInfo(String string) {
        switch (this._group) {
            case ROOT: {
                return string;
            }
            case PREFIX_GLOB: {
                if (string.length() == this._matchLength) {
                    return null;
                }
                return string.substring(this._matchLength);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String getPathMatch(String string) {
        switch (this._group) {
            case ROOT: {
                return "";
            }
            case EXACT: {
                if (this._declaration.equals(string)) {
                    return string;
                }
                return null;
            }
            case PREFIX_GLOB: {
                if (this.isWildcardMatch(string)) {
                    return string.substring(0, this._matchLength);
                }
                return null;
            }
            case SUFFIX_GLOB: {
                if (string.regionMatches(string.length() - (this._specLength - 1), this._declaration, 1, this._specLength - 1)) {
                    return string;
                }
                return null;
            }
            case DEFAULT: {
                return string;
            }
        }
        return null;
    }

    @Override
    public String getDeclaration() {
        return this._declaration;
    }

    @Override
    public String getPrefix() {
        return this._prefix;
    }

    @Override
    public String getSuffix() {
        return this._suffix;
    }

    private boolean isWildcardMatch(String string) {
        if (this._group == PathSpecGroup.PREFIX_GLOB && string.length() >= this._matchLength && string.regionMatches(0, this._declaration, 0, this._matchLength)) {
            return string.length() == this._matchLength || string.charAt(this._matchLength) == '/';
        }
        return false;
    }

    @Override
    public MatchedPath matched(String string) {
        switch (this._group) {
            case EXACT: {
                if (!this._declaration.equals(string)) break;
                return this._preMatchedPath;
            }
            case PREFIX_GLOB: {
                if (!this.isWildcardMatch(string)) break;
                if (string.length() == this._matchLength) {
                    return this._preMatchedPath;
                }
                return MatchedPath.from(string.substring(0, this._matchLength), string.substring(this._matchLength));
            }
            case SUFFIX_GLOB: {
                if (!string.regionMatches(string.length() - this._specLength + 1, this._declaration, 1, this._specLength - 1)) break;
                return MatchedPath.from(string, null);
            }
            case ROOT: {
                if (!"/".equals(string)) break;
                return this._preMatchedPath;
            }
            case DEFAULT: {
                return MatchedPath.from(string, null);
            }
        }
        return null;
    }

    @Override
    public boolean matches(String string) {
        switch (this._group) {
            case EXACT: {
                return this._declaration.equals(string);
            }
            case PREFIX_GLOB: {
                return this.isWildcardMatch(string);
            }
            case SUFFIX_GLOB: {
                return string.regionMatches(string.length() - this._specLength + 1, this._declaration, 1, this._specLength - 1);
            }
            case ROOT: {
                return "/".equals(string);
            }
            case DEFAULT: {
                return true;
            }
        }
        return false;
    }
}

