/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.util.log.Log;

public class QuotedQualityCSV
extends QuotedCSV
implements Iterable<String> {
    public static ToIntFunction<String> MOST_SPECIFIC_MIME_ORDERING = string -> {
        if ("*/*".equals(string)) {
            return 0;
        }
        if (string.endsWith("/*")) {
            return 1;
        }
        if (string.indexOf(59) < 0) {
            return 2;
        }
        return 3;
    };
    private final List<QualityValue> _qualities = new ArrayList<QualityValue>();
    private QualityValue _lastQuality;
    private boolean _sorted = false;
    private final ToIntFunction<String> _secondaryOrdering;

    public QuotedQualityCSV() {
        this((ToIntFunction<String>)null);
    }

    public QuotedQualityCSV(String[] stringArray) {
        this(string -> {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                return stringArray.length - i;
            }
            if ("*".equals(string)) {
                return stringArray.length;
            }
            return 0;
        });
    }

    public QuotedQualityCSV(ToIntFunction<String> toIntFunction) {
        super(new String[0]);
        this._secondaryOrdering = toIntFunction == null ? string -> 0 : toIntFunction;
    }

    @Override
    protected void parsedValueAndParams(StringBuffer stringBuffer) {
        super.parsedValueAndParams(stringBuffer);
        this._lastQuality = new QualityValue(this._lastQuality._quality, stringBuffer.toString(), this._lastQuality._index);
        this._qualities.set(this._lastQuality._index, this._lastQuality);
    }

    @Override
    protected void parsedValue(StringBuffer stringBuffer) {
        super.parsedValue(stringBuffer);
        this._sorted = false;
        this._lastQuality = new QualityValue(1.0, stringBuffer.toString(), this._qualities.size());
        this._qualities.add(this._lastQuality);
    }

    @Override
    protected void parsedParam(StringBuffer stringBuffer, int n, int n2, int n3) {
        this._sorted = false;
        if (n2 < 0) {
            if (stringBuffer.charAt(stringBuffer.length() - 1) == ';') {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
        } else if (n3 >= 0 && stringBuffer.charAt(n2) == 'q' && n3 > n2 && stringBuffer.length() >= n2 && stringBuffer.charAt(n2 + 1) == '=') {
            double d;
            try {
                d = this._keepQuotes && stringBuffer.charAt(n3) == '\"' ? Double.valueOf(stringBuffer.substring(n3 + 1, stringBuffer.length() - 1)) : Double.valueOf(stringBuffer.substring(n3));
            }
            catch (Exception exception) {
                Log.getLogger(QuotedQualityCSV.class).ignore(exception);
                d = 0.0;
            }
            stringBuffer.setLength(Math.max(0, n2 - 1));
            if (d != 1.0) {
                this._lastQuality = new QualityValue(d, stringBuffer.toString(), this._lastQuality._index);
                this._qualities.set(this._lastQuality._index, this._lastQuality);
            }
        }
    }

    @Override
    public List<String> getValues() {
        if (!this._sorted) {
            this.sort();
        }
        return this._values;
    }

    @Override
    public Iterator<String> iterator() {
        if (!this._sorted) {
            this.sort();
        }
        return this._values.iterator();
    }

    protected void sort() {
        this._values.clear();
        this._qualities.stream().filter(qualityValue -> ((QualityValue)qualityValue)._quality != 0.0).sorted().map(object -> ((QualityValue)object).getValue()).collect(Collectors.toCollection(() -> this._values));
        this._sorted = true;
    }

    private class QualityValue
    implements Comparable<QualityValue> {
        private final double _quality;
        private final String _value;
        private final int _index;

        private QualityValue(double d, String string, int n) {
            this._quality = d;
            this._value = string;
            this._index = n;
        }

        public int hashCode() {
            return Double.hashCode(this._quality) ^ Objects.hash(this._value, this._index);
        }

        public boolean equals(Object object) {
            if (!(object instanceof QualityValue)) {
                return false;
            }
            QualityValue qualityValue = (QualityValue)object;
            return this._quality == qualityValue._quality && Objects.equals(this._value, qualityValue._value) && Objects.equals(this._index, qualityValue._index);
        }

        private String getValue() {
            return this._value;
        }

        @Override
        public int compareTo(QualityValue qualityValue) {
            int n = Double.compare(qualityValue._quality, this._quality);
            if (n == 0 && (n = Integer.compare(QuotedQualityCSV.this._secondaryOrdering.applyAsInt(qualityValue._value), QuotedQualityCSV.this._secondaryOrdering.applyAsInt(this._value))) == 0) {
                n = -Integer.compare(qualityValue._index, this._index);
            }
            return n;
        }

        public String toString() {
            return String.format("%s@%x[%s,q=%f,i=%d]", this.getClass().getSimpleName(), this.hashCode(), this._value, this._quality, this._index);
        }
    }
}

