/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Supplier;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;

public class MetaData
implements Iterable<HttpField> {
    private HttpVersion _httpVersion;
    private final HttpFields _fields;
    private long _contentLength;
    private Supplier<HttpFields> _trailers;

    public MetaData(HttpVersion httpVersion, HttpFields httpFields) {
        this(httpVersion, httpFields, Long.MIN_VALUE);
    }

    public MetaData(HttpVersion httpVersion, HttpFields httpFields, long l) {
        this._httpVersion = httpVersion;
        this._fields = httpFields;
        this._contentLength = l;
    }

    protected void recycle() {
        this._httpVersion = null;
        if (this._fields != null) {
            this._fields.clear();
        }
        this._contentLength = Long.MIN_VALUE;
    }

    public boolean isRequest() {
        return false;
    }

    public boolean isResponse() {
        return false;
    }

    @Deprecated
    public HttpVersion getVersion() {
        return this.getHttpVersion();
    }

    public HttpVersion getHttpVersion() {
        return this._httpVersion;
    }

    public void setHttpVersion(HttpVersion httpVersion) {
        this._httpVersion = httpVersion;
    }

    public HttpFields getFields() {
        return this._fields;
    }

    public Supplier<HttpFields> getTrailerSupplier() {
        return this._trailers;
    }

    public void setTrailerSupplier(Supplier<HttpFields> supplier) {
        this._trailers = supplier;
    }

    public long getContentLength() {
        if (this._contentLength == Long.MIN_VALUE && this._fields != null) {
            HttpField httpField = this._fields.getField(HttpHeader.CONTENT_LENGTH);
            this._contentLength = httpField == null ? -1L : httpField.getLongValue();
        }
        return this._contentLength;
    }

    public void setContentLength(long l) {
        this._contentLength = l;
    }

    @Override
    public Iterator<HttpField> iterator() {
        HttpFields httpFields = this.getFields();
        return httpFields == null ? Collections.emptyIterator() : httpFields.iterator();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (HttpField httpField : this) {
            stringBuilder.append(httpField).append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    public static class Response
    extends MetaData {
        private int _status;
        private String _reason;

        public Response() {
            this(null, 0, null);
        }

        public Response(HttpVersion httpVersion, int n, HttpFields httpFields) {
            this(httpVersion, n, httpFields, Long.MIN_VALUE);
        }

        public Response(HttpVersion httpVersion, int n, HttpFields httpFields, long l) {
            super(httpVersion, httpFields, l);
            this._status = n;
        }

        public Response(HttpVersion httpVersion, int n, String string, HttpFields httpFields, long l) {
            super(httpVersion, httpFields, l);
            this._reason = string;
            this._status = n;
        }

        @Override
        public boolean isResponse() {
            return true;
        }

        public int getStatus() {
            return this._status;
        }

        public String getReason() {
            return this._reason;
        }

        public void setStatus(int n) {
            this._status = n;
        }

        public void setReason(String string) {
            this._reason = string;
        }

        @Override
        public String toString() {
            HttpFields httpFields = this.getFields();
            return String.format("%s{s=%d,h=%d,cl=%d}", new Object[]{this.getHttpVersion(), this.getStatus(), httpFields == null ? -1 : httpFields.size(), this.getContentLength()});
        }
    }

    public static class Request
    extends MetaData {
        private String _method;
        private HttpURI _uri;

        public Request(HttpFields httpFields) {
            this(null, null, null, httpFields);
        }

        public Request(String string, HttpURI httpURI, HttpVersion httpVersion, HttpFields httpFields) {
            this(string, httpURI, httpVersion, httpFields, Long.MIN_VALUE);
        }

        public Request(String string, HttpURI httpURI, HttpVersion httpVersion, HttpFields httpFields, long l) {
            super(httpVersion, httpFields, l);
            this._method = string;
            this._uri = httpURI;
        }

        public Request(String string, HttpScheme httpScheme, HostPortHttpField hostPortHttpField, String string2, HttpVersion httpVersion, HttpFields httpFields) {
            this(string, new HttpURI(httpScheme == null ? null : httpScheme.asString(), hostPortHttpField == null ? null : hostPortHttpField.getHost(), hostPortHttpField == null ? -1 : hostPortHttpField.getPort(), string2), httpVersion, httpFields);
        }

        public Request(String string, HttpScheme httpScheme, HostPortHttpField hostPortHttpField, String string2, HttpVersion httpVersion, HttpFields httpFields, long l) {
            this(string, new HttpURI(httpScheme == null ? null : httpScheme.asString(), hostPortHttpField == null ? null : hostPortHttpField.getHost(), hostPortHttpField == null ? -1 : hostPortHttpField.getPort(), string2), httpVersion, httpFields, l);
        }

        public Request(String string, String string2, HostPortHttpField hostPortHttpField, String string3, HttpVersion httpVersion, HttpFields httpFields, long l) {
            this(string, new HttpURI(string2, hostPortHttpField == null ? null : hostPortHttpField.getHost(), hostPortHttpField == null ? -1 : hostPortHttpField.getPort(), string3), httpVersion, httpFields, l);
        }

        public Request(Request request) {
            this(request.getMethod(), new HttpURI(request.getURI()), request.getHttpVersion(), new HttpFields(request.getFields()), request.getContentLength());
        }

        @Override
        public void recycle() {
            super.recycle();
            this._method = null;
            if (this._uri != null) {
                this._uri.clear();
            }
        }

        @Override
        public boolean isRequest() {
            return true;
        }

        public String getMethod() {
            return this._method;
        }

        public void setMethod(String string) {
            this._method = string;
        }

        public HttpURI getURI() {
            return this._uri;
        }

        public String getURIString() {
            return this._uri == null ? null : this._uri.toString();
        }

        public void setURI(HttpURI httpURI) {
            this._uri = httpURI;
        }

        @Override
        public String toString() {
            HttpFields httpFields = this.getFields();
            return String.format("%s{u=%s,%s,h=%d,cl=%d}", new Object[]{this.getMethod(), this.getURI(), this.getHttpVersion(), httpFields == null ? -1 : httpFields.size(), this.getContentLength()});
        }
    }
}

