/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.Syntax;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpCookie {
    private static final Logger LOG = Log.getLogger(HttpCookie.class);
    private static final String __COOKIE_DELIM = "\",;\\ \t";
    private static final String __01Jan1970_COOKIE = DateGenerator.formatCookieDate(0L).trim();
    public static final String HTTP_ONLY_COMMENT = "__HTTP_ONLY__";
    private static final String SAME_SITE_COMMENT = "__SAME_SITE_";
    public static final String SAME_SITE_NONE_COMMENT = "__SAME_SITE_NONE__";
    public static final String SAME_SITE_LAX_COMMENT = "__SAME_SITE_LAX__";
    public static final String SAME_SITE_STRICT_COMMENT = "__SAME_SITE_STRICT__";
    public static final String SAME_SITE_DEFAULT_ATTRIBUTE = "org.eclipse.jetty.cookie.sameSiteDefault";
    private final String _name;
    private final String _value;
    private final String _comment;
    private final String _domain;
    private final long _maxAge;
    private final String _path;
    private final boolean _secure;
    private final int _version;
    private final boolean _httpOnly;
    private final long _expiration;
    private final SameSite _sameSite;

    public HttpCookie(String string, String string2) {
        this(string, string2, -1L);
    }

    public HttpCookie(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, -1L, false, false);
    }

    public HttpCookie(String string, String string2, long l) {
        this(string, string2, null, null, l, false, false);
    }

    public HttpCookie(String string, String string2, String string3, String string4, long l, boolean bl, boolean bl2) {
        this(string, string2, string3, string4, l, bl, bl2, null, 0);
    }

    public HttpCookie(String string, String string2, String string3, String string4, long l, boolean bl, boolean bl2, String string5, int n) {
        this(string, string2, string3, string4, l, bl, bl2, string5, n, null);
    }

    public HttpCookie(String string, String string2, String string3, String string4, long l, boolean bl, boolean bl2, String string5, int n, SameSite sameSite) {
        this._name = string;
        this._value = string2;
        this._domain = string3;
        this._path = string4;
        this._maxAge = l;
        this._httpOnly = bl;
        this._secure = bl2;
        this._comment = string5;
        this._version = n;
        this._expiration = l < 0L ? -1L : System.nanoTime() + TimeUnit.SECONDS.toNanos(l);
        this._sameSite = sameSite;
    }

    public HttpCookie(String string) {
        List<java.net.HttpCookie> list = java.net.HttpCookie.parse(string);
        if (list.size() != 1) {
            throw new IllegalStateException();
        }
        java.net.HttpCookie httpCookie = list.get(0);
        this._name = httpCookie.getName();
        this._value = httpCookie.getValue();
        this._domain = httpCookie.getDomain();
        this._path = httpCookie.getPath();
        this._maxAge = httpCookie.getMaxAge();
        this._httpOnly = httpCookie.isHttpOnly();
        this._secure = httpCookie.getSecure();
        this._comment = httpCookie.getComment();
        this._version = httpCookie.getVersion();
        this._expiration = this._maxAge < 0L ? -1L : System.nanoTime() + TimeUnit.SECONDS.toNanos(this._maxAge);
        this._sameSite = HttpCookie.getSameSiteFromComment(httpCookie.getComment());
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public String getComment() {
        return this._comment;
    }

    public String getDomain() {
        return this._domain;
    }

    public long getMaxAge() {
        return this._maxAge;
    }

    public String getPath() {
        return this._path;
    }

    public boolean isSecure() {
        return this._secure;
    }

    public int getVersion() {
        return this._version;
    }

    public SameSite getSameSite() {
        return this._sameSite;
    }

    public boolean isHttpOnly() {
        return this._httpOnly;
    }

    public boolean isExpired(long l) {
        return this._expiration >= 0L && l >= this._expiration;
    }

    public String asString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName()).append("=").append(this.getValue());
        if (this.getDomain() != null) {
            stringBuilder.append(";$Domain=").append(this.getDomain());
        }
        if (this.getPath() != null) {
            stringBuilder.append(";$Path=").append(this.getPath());
        }
        return stringBuilder.toString();
    }

    private static void quoteOnlyOrAppend(StringBuilder stringBuilder, String string, boolean bl) {
        if (bl) {
            QuotedStringTokenizer.quoteOnly(stringBuilder, string);
        } else {
            stringBuilder.append(string);
        }
    }

    private static boolean isQuoteNeededForCookie(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        if (QuotedStringTokenizer.isQuoted(string)) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (__COOKIE_DELIM.indexOf(c) >= 0) {
                return true;
            }
            if (c >= ' ' && c < '\u007f') continue;
            throw new IllegalArgumentException("Illegal character in cookie value");
        }
        return false;
    }

    public String getSetCookie(CookieCompliance cookieCompliance) {
        switch (cookieCompliance) {
            case RFC2965: {
                return this.getRFC2965SetCookie();
            }
            case RFC6265: {
                return this.getRFC6265SetCookie();
            }
        }
        throw new IllegalStateException();
    }

    public String getRFC2965SetCookie() {
        if (this._name == null || this._name.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = HttpCookie.isQuoteNeededForCookie(this._name);
        HttpCookie.quoteOnlyOrAppend(stringBuilder, this._name, bl);
        stringBuilder.append('=');
        boolean bl2 = HttpCookie.isQuoteNeededForCookie(this._value);
        HttpCookie.quoteOnlyOrAppend(stringBuilder, this._value, bl2);
        boolean bl3 = this._domain != null && this._domain.length() > 0;
        boolean bl4 = bl3 && HttpCookie.isQuoteNeededForCookie(this._domain);
        boolean bl5 = this._path != null && this._path.length() > 0;
        boolean bl6 = bl5 && HttpCookie.isQuoteNeededForCookie(this._path);
        int n = this._version;
        if (n == 0 && (this._comment != null || bl || bl2 || bl4 || bl6 || QuotedStringTokenizer.isQuoted(this._name) || QuotedStringTokenizer.isQuoted(this._value) || QuotedStringTokenizer.isQuoted(this._path) || QuotedStringTokenizer.isQuoted(this._domain))) {
            n = 1;
        }
        if (n == 1) {
            stringBuilder.append(";Version=1");
        } else if (n > 1) {
            stringBuilder.append(";Version=").append(n);
        }
        if (bl5) {
            stringBuilder.append(";Path=");
            HttpCookie.quoteOnlyOrAppend(stringBuilder, this._path, bl6);
        }
        if (bl3) {
            stringBuilder.append(";Domain=");
            HttpCookie.quoteOnlyOrAppend(stringBuilder, this._domain, bl4);
        }
        if (this._maxAge >= 0L) {
            stringBuilder.append(";Expires=");
            if (this._maxAge == 0L) {
                stringBuilder.append(__01Jan1970_COOKIE);
            } else {
                DateGenerator.formatCookieDate(stringBuilder, System.currentTimeMillis() + 1000L * this._maxAge);
            }
            if (n >= 1) {
                stringBuilder.append(";Max-Age=");
                stringBuilder.append(this._maxAge);
            }
        }
        if (this._secure) {
            stringBuilder.append(";Secure");
        }
        if (this._httpOnly) {
            stringBuilder.append(";HttpOnly");
        }
        if (this._comment != null) {
            stringBuilder.append(";Comment=");
            HttpCookie.quoteOnlyOrAppend(stringBuilder, this._comment, HttpCookie.isQuoteNeededForCookie(this._comment));
        }
        return stringBuilder.toString();
    }

    public String getRFC6265SetCookie() {
        if (this._name == null || this._name.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        Syntax.requireValidRFC2616Token(this._name, "RFC6265 Cookie name");
        Syntax.requireValidRFC6265CookieValue(this._value);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._name).append('=').append(this._value == null ? "" : this._value);
        if (this._path != null && this._path.length() > 0) {
            stringBuilder.append("; Path=").append(this._path);
        }
        if (this._domain != null && this._domain.length() > 0) {
            stringBuilder.append("; Domain=").append(this._domain);
        }
        if (this._maxAge >= 0L) {
            stringBuilder.append("; Expires=");
            if (this._maxAge == 0L) {
                stringBuilder.append(__01Jan1970_COOKIE);
            } else {
                DateGenerator.formatCookieDate(stringBuilder, System.currentTimeMillis() + 1000L * this._maxAge);
            }
            stringBuilder.append("; Max-Age=");
            stringBuilder.append(this._maxAge);
        }
        if (this._secure) {
            stringBuilder.append("; Secure");
        }
        if (this._httpOnly) {
            stringBuilder.append("; HttpOnly");
        }
        if (this._sameSite != null) {
            stringBuilder.append("; SameSite=");
            stringBuilder.append(this._sameSite.getAttributeValue());
        }
        return stringBuilder.toString();
    }

    public static boolean isHttpOnlyInComment(String string) {
        return string != null && string.contains(HTTP_ONLY_COMMENT);
    }

    public static SameSite getSameSiteFromComment(String string) {
        if (string != null) {
            if (string.contains(SAME_SITE_STRICT_COMMENT)) {
                return SameSite.STRICT;
            }
            if (string.contains(SAME_SITE_LAX_COMMENT)) {
                return SameSite.LAX;
            }
            if (string.contains(SAME_SITE_NONE_COMMENT)) {
                return SameSite.NONE;
            }
        }
        return null;
    }

    public static SameSite getSameSiteDefault(ServletContext servletContext) {
        if (servletContext == null) {
            return null;
        }
        Object object = servletContext.getAttribute(SAME_SITE_DEFAULT_ATTRIBUTE);
        if (object == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No default value for SameSite", new Object[0]);
            }
            return null;
        }
        if (object instanceof SameSite) {
            return (SameSite)((Object)object);
        }
        try {
            SameSite sameSite = Enum.valueOf(SameSite.class, object.toString().trim().toUpperCase(Locale.ENGLISH));
            servletContext.setAttribute(SAME_SITE_DEFAULT_ATTRIBUTE, (Object)sameSite);
            return sameSite;
        }
        catch (Exception exception) {
            LOG.warn("Bad default value {} for SameSite", object);
            throw new IllegalStateException(exception);
        }
    }

    public static String getCommentWithoutAttributes(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        string2 = StringUtil.strip(string2, HTTP_ONLY_COMMENT);
        string2 = StringUtil.strip(string2, SAME_SITE_NONE_COMMENT);
        string2 = StringUtil.strip(string2, SAME_SITE_LAX_COMMENT);
        return (string2 = StringUtil.strip(string2, SAME_SITE_STRICT_COMMENT)).length() == 0 ? null : string2;
    }

    public static String getCommentWithAttributes(String string, boolean bl, SameSite sameSite) {
        if (string == null && sameSite == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtil.isNotBlank(string) && StringUtil.isNotBlank(string = HttpCookie.getCommentWithoutAttributes(string))) {
            stringBuilder.append(string);
        }
        if (bl) {
            stringBuilder.append(HTTP_ONLY_COMMENT);
        }
        if (sameSite != null) {
            switch (sameSite) {
                case NONE: {
                    stringBuilder.append(SAME_SITE_NONE_COMMENT);
                    break;
                }
                case STRICT: {
                    stringBuilder.append(SAME_SITE_STRICT_COMMENT);
                    break;
                }
                case LAX: {
                    stringBuilder.append(SAME_SITE_LAX_COMMENT);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(sameSite.toString());
                }
            }
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    public static class SetCookieHttpField
    extends HttpField {
        final HttpCookie _cookie;

        public SetCookieHttpField(HttpCookie httpCookie, CookieCompliance cookieCompliance) {
            super(HttpHeader.SET_COOKIE, httpCookie.getSetCookie(cookieCompliance));
            this._cookie = httpCookie;
        }

        public HttpCookie getHttpCookie() {
            return this._cookie;
        }
    }

    public static enum SameSite {
        NONE("None"),
        STRICT("Strict"),
        LAX("Lax");

        private String attributeValue;

        private SameSite(String string2) {
            this.attributeValue = string2;
        }

        public String getAttributeValue() {
            return this.attributeValue;
        }
    }
}

