/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.Objects;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;

public class CompressedContentFormat {
    public static final String ETAG_SEPARATOR = System.getProperty(CompressedContentFormat.class.getName() + ".ETAG_SEPARATOR", "--");
    public static final CompressedContentFormat GZIP = new CompressedContentFormat("gzip", ".gz");
    public static final CompressedContentFormat BR = new CompressedContentFormat("br", ".br");
    public static final CompressedContentFormat[] NONE = new CompressedContentFormat[0];
    private final String _encoding;
    private final String _extension;
    private final String _etagSuffix;
    private final String _etagSuffixQuote;
    private final PreEncodedHttpField _contentEncoding;

    public CompressedContentFormat(String string, String string2) {
        this._encoding = StringUtil.asciiToLowerCase(string);
        this._extension = StringUtil.asciiToLowerCase(string2);
        this._etagSuffix = StringUtil.isEmpty(ETAG_SEPARATOR) ? "" : ETAG_SEPARATOR + this._encoding;
        this._etagSuffixQuote = this._etagSuffix + "\"";
        this._contentEncoding = new PreEncodedHttpField(HttpHeader.CONTENT_ENCODING, this._encoding);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CompressedContentFormat)) {
            return false;
        }
        CompressedContentFormat compressedContentFormat = (CompressedContentFormat)object;
        return Objects.equals(this._encoding, compressedContentFormat._encoding) && Objects.equals(this._extension, compressedContentFormat._extension);
    }

    public String getEncoding() {
        return this._encoding;
    }

    public String getExtension() {
        return this._extension;
    }

    public String getEtagSuffix() {
        return this._etagSuffix;
    }

    public HttpField getContentEncoding() {
        return this._contentEncoding;
    }

    public String etag(String string) {
        if (StringUtil.isEmpty(ETAG_SEPARATOR)) {
            return string;
        }
        int n = string.length() - 1;
        if (string.charAt(n) == '\"') {
            return string.substring(0, n) + this._etagSuffixQuote;
        }
        return string + this._etagSuffix;
    }

    public int hashCode() {
        return Objects.hash(this._encoding, this._extension);
    }

    public static boolean tagEquals(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        if (StringUtil.isEmpty(ETAG_SEPARATOR)) {
            return false;
        }
        boolean bl = string.endsWith("\"");
        boolean bl2 = string2.endsWith("\"");
        int n = string2.lastIndexOf(ETAG_SEPARATOR);
        if (bl == bl2) {
            return n > 0 && string.regionMatches(0, string2, 0, n);
        }
        if (string2.startsWith("W/") || string.startsWith("W/")) {
            return false;
        }
        string = bl ? QuotedStringTokenizer.unquote(string) : string;
        string2 = bl2 ? QuotedStringTokenizer.unquote(string2) : string2;
        n = string2.lastIndexOf(ETAG_SEPARATOR);
        if (n > 0) {
            return string.regionMatches(0, string2, 0, n);
        }
        return Objects.equals(string, string2);
    }

    public String stripSuffixes(String string) {
        if (StringUtil.isEmpty(ETAG_SEPARATOR)) {
            return string;
        }
        int n;
        while ((n = string.lastIndexOf(this._etagSuffix)) >= 0) {
            string = string.substring(0, n) + string.substring(n + this._etagSuffix.length());
        }
        return string;
    }

    public String toString() {
        return this._encoding;
    }
}

