/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.AbstractAuthentication;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;

public class DigestAuthentication
extends AbstractAuthentication {
    private final Random random;
    private final String user;
    private final String password;

    public DigestAuthentication(URI uRI, String string, String string2, String string3) {
        this(uRI, string, string2, string3, new SecureRandom());
    }

    public DigestAuthentication(URI uRI, String string, String string2, String string3, Random random) {
        super(uRI, string);
        Objects.requireNonNull(random);
        this.random = random;
        this.user = string2;
        this.password = string3;
    }

    @Override
    public String getType() {
        return "Digest";
    }

    @Override
    public boolean matches(String string, URI uRI, String string2) {
        if (string2 == null) {
            return false;
        }
        return super.matches(string, uRI, string2);
    }

    @Override
    public Authentication.Result authenticate(Request request, ContentResponse contentResponse, Authentication.HeaderInfo headerInfo, Attributes attributes) {
        List<String> list;
        MessageDigest messageDigest;
        Map<String, String> map = headerInfo.getParameters();
        String string = map.get("nonce");
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = map.get("opaque");
        String string3 = map.get("algorithm");
        if (string3 == null) {
            string3 = "MD5";
        }
        if ((messageDigest = this.getMessageDigest(string3)) == null) {
            return null;
        }
        String string4 = map.get("qop");
        String string5 = null;
        if (string4 != null) {
            list = StringUtil.csvSplit(null, string4, 0, string4.length());
            if (list.contains("auth")) {
                string5 = "auth";
            } else if (list.contains("auth-int")) {
                string5 = "auth-int";
            }
        }
        if ("<<ANY_REALM>>".equals(list = this.getRealm())) {
            list = headerInfo.getRealm();
        }
        return new DigestResult(headerInfo.getHeader(), contentResponse.getContent(), (String)((Object)list), this.user, this.password, string3, string, string5, string2);
    }

    private MessageDigest getMessageDigest(String string) {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private class DigestResult
    implements Authentication.Result {
        private final AtomicInteger nonceCount = new AtomicInteger();
        private final HttpHeader header;
        private final byte[] content;
        private final String realm;
        private final String user;
        private final String password;
        private final String algorithm;
        private final String nonce;
        private final String qop;
        private final String opaque;

        public DigestResult(HttpHeader httpHeader, byte[] byArray, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
            this.header = httpHeader;
            this.content = byArray;
            this.realm = string;
            this.user = string2;
            this.password = string3;
            this.algorithm = string4;
            this.nonce = string5;
            this.qop = string6;
            this.opaque = string7;
        }

        @Override
        public URI getURI() {
            return DigestAuthentication.this.getURI();
        }

        @Override
        public void apply(Request request) {
            String string;
            String string2;
            String string3;
            MessageDigest messageDigest = DigestAuthentication.this.getMessageDigest(this.algorithm);
            if (messageDigest == null) {
                return;
            }
            String string4 = this.user + ":" + this.realm + ":" + this.password;
            String string5 = this.toHexString(messageDigest.digest(string4.getBytes(StandardCharsets.ISO_8859_1)));
            String string6 = request.getQuery();
            String string7 = request.getPath();
            String string8 = string6 == null ? string7 : string7 + "?" + string6;
            String string9 = request.getMethod() + ":" + string8;
            if ("auth-int".equals(this.qop)) {
                string9 = string9 + ":" + this.toHexString(messageDigest.digest(this.content));
            }
            String string10 = this.toHexString(messageDigest.digest(string9.getBytes(StandardCharsets.ISO_8859_1)));
            if (this.qop != null) {
                string3 = this.nextNonceCount();
                string2 = this.newClientNonce();
                string = string5 + ":" + this.nonce + ":" + string3 + ":" + string2 + ":" + this.qop + ":" + string10;
            } else {
                string3 = null;
                string2 = null;
                string = string5 + ":" + this.nonce + ":" + string10;
            }
            String string11 = this.toHexString(messageDigest.digest(string.getBytes(StandardCharsets.ISO_8859_1)));
            StringBuilder stringBuilder = new StringBuilder("Digest");
            stringBuilder.append(" username=\"").append(this.user).append("\"");
            stringBuilder.append(", realm=\"").append(this.realm).append("\"");
            stringBuilder.append(", nonce=\"").append(this.nonce).append("\"");
            if (this.opaque != null) {
                stringBuilder.append(", opaque=\"").append(this.opaque).append("\"");
            }
            stringBuilder.append(", algorithm=\"").append(this.algorithm).append("\"");
            stringBuilder.append(", uri=\"").append(string8).append("\"");
            if (this.qop != null) {
                stringBuilder.append(", qop=\"").append(this.qop).append("\"");
                stringBuilder.append(", nc=\"").append(string3).append("\"");
                stringBuilder.append(", cnonce=\"").append(string2).append("\"");
            }
            stringBuilder.append(", response=\"").append(string11).append("\"");
            request.header(this.header, stringBuilder.toString());
        }

        private String nextNonceCount() {
            String string = "00000000";
            String string2 = Integer.toHexString(this.nonceCount.incrementAndGet()).toLowerCase(Locale.ENGLISH);
            return string.substring(0, string.length() - string2.length()) + string2;
        }

        private String newClientNonce() {
            byte[] byArray = new byte[8];
            DigestAuthentication.this.random.nextBytes(byArray);
            return this.toHexString(byArray);
        }

        private String toHexString(byte[] byArray) {
            return TypeUtil.toHexString(byArray).toLowerCase(Locale.ENGLISH);
        }
    }
}

