/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.SendFailure;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import org.eclipse.jetty.client.http.HttpDestinationOverHTTP;
import org.eclipse.jetty.client.http.HttpReceiverOverHTTP;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Attachable;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Sweeper;

public class HttpConnectionOverHTTP
extends AbstractConnection
implements Connection,
Connection.UpgradeFrom,
Sweeper.Sweepable,
Attachable {
    private static final Logger LOG = Log.getLogger(HttpConnectionOverHTTP.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicInteger sweeps = new AtomicInteger();
    private final Promise<Connection> promise;
    private final Delegate delegate;
    private final HttpChannelOverHTTP channel;
    private long idleTimeout;
    private final LongAdder bytesIn = new LongAdder();
    private final LongAdder bytesOut = new LongAdder();

    public HttpConnectionOverHTTP(EndPoint endPoint, HttpDestination httpDestination, Promise<Connection> promise) {
        super(endPoint, httpDestination.getHttpClient().getExecutor());
        this.promise = promise;
        this.delegate = new Delegate(httpDestination);
        this.channel = this.newHttpChannel();
    }

    protected HttpChannelOverHTTP newHttpChannel() {
        return new HttpChannelOverHTTP(this);
    }

    public HttpChannelOverHTTP getHttpChannel() {
        return this.channel;
    }

    public HttpDestinationOverHTTP getHttpDestination() {
        return (HttpDestinationOverHTTP)this.delegate.getHttpDestination();
    }

    @Override
    public long getBytesIn() {
        return this.bytesIn.longValue();
    }

    protected void addBytesIn(long l) {
        this.bytesIn.add(l);
    }

    @Override
    public long getBytesOut() {
        return this.bytesOut.longValue();
    }

    protected void addBytesOut(long l) {
        this.bytesOut.add(l);
    }

    @Override
    public long getMessagesIn() {
        return this.getHttpChannel().getMessagesIn();
    }

    @Override
    public long getMessagesOut() {
        return this.getHttpChannel().getMessagesOut();
    }

    @Override
    public void send(Request request, Response.CompleteListener completeListener) {
        this.delegate.send(request, completeListener);
    }

    protected SendFailure send(HttpExchange httpExchange) {
        return this.delegate.send(httpExchange);
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.fillInterested();
        this.promise.succeeded(this);
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void setAttachment(Object object) {
        this.delegate.setAttachment(object);
    }

    @Override
    public Object getAttachment() {
        return this.delegate.getAttachment();
    }

    @Override
    public boolean onIdleExpired() {
        long l = this.getEndPoint().getIdleTimeout();
        boolean bl = this.onIdleTimeout(l);
        if (bl) {
            this.close(new TimeoutException("Idle timeout " + l + " ms"));
        }
        return false;
    }

    protected boolean onIdleTimeout(long l) {
        return this.delegate.onIdleTimeout(l);
    }

    @Override
    public void onFillable() {
        this.channel.receive();
    }

    @Override
    public ByteBuffer onUpgradeFrom() {
        HttpReceiverOverHTTP httpReceiverOverHTTP = this.channel.getHttpReceiver();
        return httpReceiverOverHTTP.onUpgradeFrom();
    }

    public void release() {
        this.getEndPoint().setIdleTimeout(this.idleTimeout);
        this.getHttpDestination().release(this);
    }

    @Override
    public void close() {
        this.close(new AsynchronousCloseException());
    }

    protected void close(Throwable throwable) {
        if (this.closed.compareAndSet(false, true)) {
            this.getHttpDestination().remove(this);
            this.abort(throwable);
            this.channel.destroy();
            this.getEndPoint().shutdownOutput();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Shutdown {}", this);
            }
            this.getEndPoint().close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closed {}", this);
            }
        }
    }

    protected boolean abort(Throwable throwable) {
        HttpExchange httpExchange = this.channel.getHttpExchange();
        return httpExchange != null && httpExchange.getRequest().abort(throwable);
    }

    @Override
    public boolean sweep() {
        if (!this.closed.get()) {
            return false;
        }
        return this.sweeps.incrementAndGet() >= 4;
    }

    public void remove() {
        this.getHttpDestination().remove(this);
    }

    @Override
    public String toConnectionString() {
        return String.format("%s@%x(l:%s <-> r:%s,closed=%b)=>%s", this.getClass().getSimpleName(), this.hashCode(), this.getEndPoint().getLocalAddress(), this.getEndPoint().getRemoteAddress(), this.closed.get(), this.channel);
    }

    private class Delegate
    extends HttpConnection {
        private Delegate(HttpDestination httpDestination) {
            super(httpDestination);
        }

        @Override
        protected Iterator<HttpChannel> getHttpChannels() {
            return Collections.singleton(HttpConnectionOverHTTP.this.channel).iterator();
        }

        @Override
        protected SendFailure send(HttpExchange httpExchange) {
            HttpRequest httpRequest = httpExchange.getRequest();
            this.normalizeRequest(httpRequest);
            EndPoint endPoint = HttpConnectionOverHTTP.this.getEndPoint();
            HttpConnectionOverHTTP.this.idleTimeout = endPoint.getIdleTimeout();
            long l = httpRequest.getIdleTimeout();
            if (l >= 0L) {
                endPoint.setIdleTimeout(l);
            }
            return this.send(HttpConnectionOverHTTP.this.channel, httpExchange);
        }

        @Override
        public void close() {
            HttpConnectionOverHTTP.this.close();
            this.destroy();
        }

        @Override
        public boolean isClosed() {
            return HttpConnectionOverHTTP.this.isClosed();
        }

        @Override
        public String toString() {
            return HttpConnectionOverHTTP.this.toString();
        }
    }
}

