/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.api;

import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;

public class Result {
    private final Request request;
    private final Throwable requestFailure;
    private final Response response;
    private final Throwable responseFailure;

    public Result(Request request, Response response) {
        this(request, null, response, null);
    }

    public Result(Request request, Response response, Throwable throwable) {
        this(request, null, response, throwable);
    }

    public Result(Request request, Throwable throwable, Response response) {
        this(request, throwable, response, null);
    }

    public Result(Request request, Throwable throwable, Response response, Throwable throwable2) {
        this.request = request;
        this.requestFailure = throwable;
        this.response = response;
        this.responseFailure = throwable2;
    }

    public Result(Result result, Throwable throwable) {
        this.request = result.request;
        this.requestFailure = result.requestFailure;
        this.response = result.response;
        this.responseFailure = throwable;
    }

    public Request getRequest() {
        return this.request;
    }

    public Throwable getRequestFailure() {
        return this.requestFailure;
    }

    public Response getResponse() {
        return this.response;
    }

    public Throwable getResponseFailure() {
        return this.responseFailure;
    }

    public boolean isSucceeded() {
        return this.getFailure() == null;
    }

    public boolean isFailed() {
        return !this.isSucceeded();
    }

    public Throwable getFailure() {
        return this.responseFailure != null ? this.responseFailure : this.requestFailure;
    }

    public String toString() {
        return String.format("%s[%s > %s] %s", Result.class.getSimpleName(), this.request, this.response, this.getFailure());
    }
}

