/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.function.LongConsumer;
import java.util.function.ObjLongConsumer;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.CountingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ResponseNotifier {
    private static final Logger LOG = Log.getLogger(ResponseNotifier.class);

    public void notifyBegin(List<Response.ResponseListener> list, Response response) {
        for (Response.ResponseListener responseListener : list) {
            if (!(responseListener instanceof Response.BeginListener)) continue;
            this.notifyBegin((Response.BeginListener)responseListener, response);
        }
    }

    private void notifyBegin(Response.BeginListener beginListener, Response response) {
        try {
            beginListener.onBegin(response);
        }
        catch (Throwable throwable) {
            LOG.info("Exception while notifying listener " + beginListener, throwable);
        }
    }

    public boolean notifyHeader(List<Response.ResponseListener> list, Response response, HttpField httpField) {
        boolean bl = true;
        for (Response.ResponseListener responseListener : list) {
            if (!(responseListener instanceof Response.HeaderListener)) continue;
            bl &= this.notifyHeader((Response.HeaderListener)responseListener, response, httpField);
        }
        return bl;
    }

    private boolean notifyHeader(Response.HeaderListener headerListener, Response response, HttpField httpField) {
        try {
            return headerListener.onHeader(response, httpField);
        }
        catch (Throwable throwable) {
            LOG.info("Exception while notifying listener " + headerListener, throwable);
            return false;
        }
    }

    public void notifyHeaders(List<Response.ResponseListener> list, Response response) {
        for (Response.ResponseListener responseListener : list) {
            if (!(responseListener instanceof Response.HeadersListener)) continue;
            this.notifyHeaders((Response.HeadersListener)responseListener, response);
        }
    }

    private void notifyHeaders(Response.HeadersListener headersListener, Response response) {
        try {
            headersListener.onHeaders(response);
        }
        catch (Throwable throwable) {
            LOG.info("Exception while notifying listener " + headersListener, throwable);
        }
    }

    public void notifyBeforeContent(Response response, ObjLongConsumer<Object> objLongConsumer, List<Response.DemandedContentListener> list) {
        for (Response.DemandedContentListener demandedContentListener : list) {
            this.notifyBeforeContent(demandedContentListener, response, (long l) -> objLongConsumer.accept(demandedContentListener, l));
        }
    }

    private void notifyBeforeContent(Response.DemandedContentListener demandedContentListener, Response response, LongConsumer longConsumer) {
        try {
            demandedContentListener.onBeforeContent(response, longConsumer);
        }
        catch (Throwable throwable) {
            LOG.info("Exception while notifying listener " + demandedContentListener, throwable);
        }
    }

    public void notifyContent(Response response, ObjLongConsumer<Object> objLongConsumer, ByteBuffer byteBuffer, Callback callback, List<Response.DemandedContentListener> list) {
        int n = list.size();
        if (n == 0) {
            callback.succeeded();
            objLongConsumer.accept(null, 1L);
        } else if (n == 1) {
            Response.DemandedContentListener demandedContentListener = list.get(0);
            this.notifyContent(demandedContentListener, response, (long l) -> objLongConsumer.accept(demandedContentListener, l), byteBuffer.slice(), callback);
        } else {
            callback = new CountingCallback(callback, n);
            for (Response.DemandedContentListener demandedContentListener : list) {
                this.notifyContent(demandedContentListener, response, (long l) -> objLongConsumer.accept(demandedContentListener, l), byteBuffer.slice(), callback);
            }
        }
    }

    private void notifyContent(Response.DemandedContentListener demandedContentListener, Response response, LongConsumer longConsumer, ByteBuffer byteBuffer, Callback callback) {
        try {
            demandedContentListener.onContent(response, longConsumer, byteBuffer, callback);
        }
        catch (Throwable throwable) {
            LOG.info("Exception while notifying listener " + demandedContentListener, throwable);
        }
    }

    public void notifySuccess(List<Response.ResponseListener> list, Response response) {
        for (Response.ResponseListener responseListener : list) {
            if (!(responseListener instanceof Response.SuccessListener)) continue;
            this.notifySuccess((Response.SuccessListener)responseListener, response);
        }
    }

    private void notifySuccess(Response.SuccessListener successListener, Response response) {
        try {
            successListener.onSuccess(response);
        }
        catch (Throwable throwable) {
            LOG.info("Exception while notifying listener " + successListener, throwable);
        }
    }

    public void notifyFailure(List<Response.ResponseListener> list, Response response, Throwable throwable) {
        for (Response.ResponseListener responseListener : list) {
            if (!(responseListener instanceof Response.FailureListener)) continue;
            this.notifyFailure((Response.FailureListener)responseListener, response, throwable);
        }
    }

    private void notifyFailure(Response.FailureListener failureListener, Response response, Throwable throwable) {
        try {
            failureListener.onFailure(response, throwable);
        }
        catch (Throwable throwable2) {
            LOG.info("Exception while notifying listener " + failureListener, throwable2);
        }
    }

    public void notifyComplete(List<Response.ResponseListener> list, Result result) {
        for (Response.ResponseListener responseListener : list) {
            if (!(responseListener instanceof Response.CompleteListener)) continue;
            this.notifyComplete((Response.CompleteListener)responseListener, result);
        }
    }

    private void notifyComplete(Response.CompleteListener completeListener, Result result) {
        try {
            completeListener.onComplete(result);
        }
        catch (Throwable throwable) {
            LOG.info("Exception while notifying listener " + completeListener, throwable);
        }
    }

    public void forwardSuccess(List<Response.ResponseListener> list, Response response) {
        this.forwardEvents(list, response);
        this.notifySuccess(list, response);
    }

    public void forwardSuccessComplete(List<Response.ResponseListener> list, Request request, Response response) {
        this.forwardSuccess(list, response);
        this.notifyComplete(list, new Result(request, response));
    }

    public void forwardFailure(List<Response.ResponseListener> list, Response response, Throwable throwable) {
        this.forwardEvents(list, response);
        this.notifyFailure(list, response, throwable);
    }

    private void forwardEvents(List<Response.ResponseListener> list, Response response) {
        Object object2;
        this.notifyBegin(list, response);
        Iterator<HttpField> iterator = response.getHeaders().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (this.notifyHeader(list, response, (HttpField)object2)) continue;
            iterator.remove();
        }
        this.notifyHeaders(list, response);
        if (response instanceof ContentResponse && (object2 = (Object)((ContentResponse)response).getContent()) != null && ((Object)object2).length > 0) {
            List<Response.DemandedContentListener> list2 = list.stream().filter(Response.DemandedContentListener.class::isInstance).map(Response.DemandedContentListener.class::cast).collect(Collectors.toList());
            ObjLongConsumer<Object> objLongConsumer = (object, l) -> {};
            this.notifyBeforeContent(response, objLongConsumer, list2);
            this.notifyContent(response, objLongConsumer, ByteBuffer.wrap((byte[])object2), Callback.NOOP, list2);
        }
    }

    public void forwardFailureComplete(List<Response.ResponseListener> list, Request request, Throwable throwable, Response response, Throwable throwable2) {
        this.forwardFailure(list, response, throwable2);
        this.notifyComplete(list, new Result(request, throwable, response, throwable2));
    }
}

