/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class HttpChannel
implements CyclicTimeouts.Expirable {
    protected static final Logger LOG = Log.getLogger(HttpChannel.class);
    private final HttpDestination _destination;
    private HttpExchange _exchange;

    protected HttpChannel(HttpDestination httpDestination) {
        this._destination = httpDestination;
    }

    public void destroy() {
    }

    public HttpDestination getHttpDestination() {
        return this._destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean associate(HttpExchange httpExchange) {
        boolean bl = false;
        boolean bl2 = true;
        HttpChannel httpChannel = this;
        synchronized (httpChannel) {
            if (this._exchange == null) {
                bl2 = false;
                bl = httpExchange.associate(this);
                if (bl) {
                    this._exchange = httpExchange;
                }
            }
        }
        if (bl2) {
            httpExchange.getRequest().abort(new UnsupportedOperationException("Pipelined requests not supported"));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("{} associated {} to {}", httpExchange, bl, this);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disassociate(HttpExchange httpExchange) {
        boolean bl = false;
        HttpChannel httpChannel = this;
        synchronized (httpChannel) {
            HttpExchange httpExchange2 = this._exchange;
            this._exchange = null;
            if (httpExchange2 == httpExchange) {
                httpExchange2.disassociate(this);
                bl = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} disassociated {} from {}", httpExchange, bl, this);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpExchange getHttpExchange() {
        HttpChannel httpChannel = this;
        synchronized (httpChannel) {
            return this._exchange;
        }
    }

    @Override
    public long getExpireNanoTime() {
        HttpExchange httpExchange = this.getHttpExchange();
        return httpExchange != null ? httpExchange.getExpireNanoTime() : Long.MAX_VALUE;
    }

    protected abstract HttpSender getHttpSender();

    protected abstract HttpReceiver getHttpReceiver();

    public void send() {
        HttpExchange httpExchange = this.getHttpExchange();
        if (httpExchange != null) {
            this.send(httpExchange);
        }
    }

    public abstract void send(HttpExchange var1);

    public abstract void release();

    public void proceed(HttpExchange httpExchange, Throwable throwable) {
        this.getHttpSender().proceed(httpExchange, throwable);
    }

    public boolean abort(HttpExchange httpExchange, Throwable throwable, Throwable throwable2) {
        boolean bl = false;
        if (throwable != null) {
            bl = this.getHttpSender().abort(httpExchange, throwable);
        }
        boolean bl2 = false;
        if (throwable2 != null) {
            bl2 = this.abortResponse(httpExchange, throwable2);
        }
        return bl || bl2;
    }

    public boolean abortResponse(HttpExchange httpExchange, Throwable throwable) {
        return this.getHttpReceiver().abort(httpExchange, throwable);
    }

    public Result exchangeTerminating(HttpExchange httpExchange, Result result) {
        return result;
    }

    public void exchangeTerminated(HttpExchange httpExchange, Result result) {
        this.disassociate(httpExchange);
    }

    public String toString() {
        return String.format("%s@%x(exchange=%s)", this.getClass().getSimpleName(), this.hashCode(), this.getHttpExchange());
    }
}

