/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.util.Attachable;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Pool;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Sweeper;

@ManagedObject
public abstract class AbstractConnectionPool
extends ContainerLifeCycle
implements ConnectionPool,
Dumpable,
Sweeper.Sweepable {
    private static final Logger LOG = Log.getLogger(AbstractConnectionPool.class);
    private final AtomicInteger pending = new AtomicInteger();
    private final HttpDestination destination;
    private final Callback requester;
    private final Pool<Connection> pool;
    private boolean maximizeConnections;
    private volatile long maxDurationNanos = 0L;

    @Deprecated
    protected AbstractConnectionPool(Destination destination, int n, Callback callback) {
        this((HttpDestination)destination, n, false, callback);
    }

    protected AbstractConnectionPool(HttpDestination httpDestination, int n, boolean bl, Callback callback) {
        this(httpDestination, Pool.StrategyType.FIRST, n, bl, callback);
    }

    protected AbstractConnectionPool(HttpDestination httpDestination, Pool.StrategyType strategyType, int n, boolean bl, Callback callback) {
        this(httpDestination, new Pool<Connection>(strategyType, n, bl), callback);
    }

    protected AbstractConnectionPool(HttpDestination httpDestination, Pool<Connection> pool, Callback callback) {
        this.destination = httpDestination;
        this.requester = callback;
        this.pool = pool;
        pool.setMaxMultiplex(1);
        this.addBean(pool);
    }

    @Override
    protected void doStop() throws Exception {
        this.pool.close();
    }

    @Override
    public CompletableFuture<Void> preCreateConnections(int n) {
        Pool.Entry entry;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pre-creating connections {}/{}", n, this.getMaxConnectionCount());
        }
        ArrayList<FutureConnection> arrayList = new ArrayList<FutureConnection>();
        for (int i = 0; i < n && (entry = this.pool.reserve()) != null; ++i) {
            this.pending.incrementAndGet();
            FutureConnection futureConnection = new FutureConnection(entry);
            arrayList.add(futureConnection);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Pre-creating connection {}/{} at {}", arrayList.size(), this.getMaxConnectionCount(), entry);
            }
            this.destination.newConnection(futureConnection);
        }
        return CompletableFuture.allOf(arrayList.toArray(new CompletableFuture[0]));
    }

    @ManagedAttribute(value="The maximum duration in milliseconds a connection can be used for before it gets closed")
    public long getMaxDuration() {
        return TimeUnit.NANOSECONDS.toMillis(this.maxDurationNanos);
    }

    public void setMaxDuration(long l) {
        this.maxDurationNanos = TimeUnit.MILLISECONDS.toNanos(l);
    }

    protected int getMaxMultiplex() {
        return this.pool.getMaxMultiplex();
    }

    protected void setMaxMultiplex(int n) {
        this.pool.setMaxMultiplex(n);
    }

    protected int getMaxUsageCount() {
        return this.pool.getMaxUsageCount();
    }

    protected void setMaxUsageCount(int n) {
        this.pool.setMaxUsageCount(n);
    }

    @ManagedAttribute(value="The number of active connections", readonly=true)
    public int getActiveConnectionCount() {
        return this.pool.getInUseCount();
    }

    @ManagedAttribute(value="The number of idle connections", readonly=true)
    public int getIdleConnectionCount() {
        return this.pool.getIdleCount();
    }

    @ManagedAttribute(value="The max number of connections", readonly=true)
    public int getMaxConnectionCount() {
        return this.pool.getMaxEntries();
    }

    @ManagedAttribute(value="The number of connections", readonly=true)
    public int getConnectionCount() {
        return this.pool.size();
    }

    @ManagedAttribute(value="The number of pending connections", readonly=true)
    @Deprecated
    public int getPendingCount() {
        return this.getPendingConnectionCount();
    }

    @ManagedAttribute(value="The number of pending connections", readonly=true)
    public int getPendingConnectionCount() {
        return this.pending.get();
    }

    @Override
    public boolean isEmpty() {
        return this.pool.size() == 0;
    }

    @Override
    @ManagedAttribute(value="Whether this pool is closed")
    public boolean isClosed() {
        return this.pool.isClosed();
    }

    @ManagedAttribute(value="Whether the pool tries to maximize the number of connections used")
    public boolean isMaximizeConnections() {
        return this.maximizeConnections;
    }

    public void setMaximizeConnections(boolean bl) {
        this.maximizeConnections = bl;
    }

    @Override
    public Connection acquire() {
        return this.acquire(true);
    }

    protected Connection acquire(boolean bl) {
        Connection connection;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Acquiring create={} on {}", bl, this);
        }
        if ((connection = this.activate()) == null) {
            this.tryCreate(bl);
            connection = this.activate();
        }
        return connection;
    }

    protected void tryCreate(boolean bl) {
        int n;
        int n2 = this.getConnectionCount();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Try creating connection {}/{} with {} pending", n2, this.getMaxConnectionCount(), this.getPendingConnectionCount());
        }
        int n3 = this.getMaxMultiplex();
        do {
            boolean bl2;
            n = this.pending.get();
            int n4 = n * n3;
            int n5 = this.destination.getQueuedRequestCount() + (bl ? 1 : 0);
            boolean bl3 = bl2 = this.isMaximizeConnections() || n4 < n5;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try creating({}) connection, pending/demand/supply: {}/{}/{}, result={}", bl, n, n5, n4, bl2);
            }
            if (bl2) continue;
            return;
        } while (!this.pending.compareAndSet(n, n + 1));
        Pool.Entry entry = this.pool.reserve();
        if (entry == null) {
            this.pending.decrementAndGet();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not creating connection as pool {} is full, pending: {}", this.pool, this.pending);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating connection {}/{} at {}", n2, this.getMaxConnectionCount(), entry);
        }
        FutureConnection futureConnection = new FutureConnection(entry);
        this.destination.newConnection(futureConnection);
    }

    protected void proceed() {
        this.requester.succeeded();
    }

    protected Connection activate() {
        Pool.Entry entry;
        while ((entry = this.pool.acquire()) != null) {
            EntryHolder entryHolder;
            Connection connection = (Connection)entry.getPooled();
            long l = this.maxDurationNanos;
            if (l > 0L && (entryHolder = (EntryHolder)((Attachable)((Object)connection)).getAttachment()).isExpired(l)) {
                boolean bl = this.remove(connection);
                if (bl) {
                    IO.close(connection);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Connection removed{} due to expiration {} {}", bl ? " and closed" : "", entry, this.pool);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Activated {} {}", entry, this.pool);
            }
            this.acquired(connection);
            return connection;
        }
        return null;
    }

    @Override
    public boolean isActive(Connection connection) {
        if (!(connection instanceof Attachable)) {
            throw new IllegalArgumentException("Invalid connection object: " + connection);
        }
        Attachable attachable = (Attachable)((Object)connection);
        EntryHolder entryHolder = (EntryHolder)attachable.getAttachment();
        if (entryHolder == null) {
            return false;
        }
        return !entryHolder.entry.isIdle();
    }

    @Override
    public boolean release(Connection connection) {
        if (!this.deactivate(connection)) {
            return false;
        }
        this.released(connection);
        return this.idle(connection, this.isClosed());
    }

    protected boolean deactivate(Connection connection) {
        if (!(connection instanceof Attachable)) {
            throw new IllegalArgumentException("Invalid connection object: " + connection);
        }
        Attachable attachable = (Attachable)((Object)connection);
        EntryHolder entryHolder = (EntryHolder)attachable.getAttachment();
        if (entryHolder == null) {
            return true;
        }
        long l = this.maxDurationNanos;
        if (l > 0L && entryHolder.isExpired(l)) {
            return !this.remove(connection);
        }
        boolean bl = this.pool.release(entryHolder.entry);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released ({}) {} {}", bl, entryHolder.entry, this.pool);
        }
        if (bl) {
            return true;
        }
        return !this.remove(connection);
    }

    @Override
    public boolean remove(Connection connection) {
        if (!(connection instanceof Attachable)) {
            throw new IllegalArgumentException("Invalid connection object: " + connection);
        }
        Attachable attachable = (Attachable)((Object)connection);
        EntryHolder entryHolder = (EntryHolder)attachable.getAttachment();
        if (entryHolder == null) {
            return false;
        }
        boolean bl = this.pool.remove(entryHolder.entry);
        if (bl) {
            attachable.setAttachment(null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removed ({}) {} {}", bl, entryHolder.entry, this.pool);
        }
        if (bl) {
            this.released(connection);
            this.removed(connection);
        }
        return bl;
    }

    @Deprecated
    protected boolean remove(Connection connection, boolean bl) {
        return this.remove(connection);
    }

    protected void onCreated(Connection connection) {
    }

    protected boolean idle(Connection connection, boolean bl) {
        return !bl;
    }

    protected void acquired(Connection connection) {
    }

    protected void released(Connection connection) {
    }

    protected void removed(Connection connection) {
    }

    @Deprecated
    public Queue<Connection> getIdleConnections() {
        return this.pool.values().stream().filter(Pool.Entry::isIdle).filter(entry -> !entry.isClosed()).map(Pool.Entry::getPooled).collect(Collectors.toCollection(ArrayDeque::new));
    }

    @Deprecated
    public Collection<Connection> getActiveConnections() {
        return this.pool.values().stream().filter(entry -> !entry.isIdle()).filter(entry -> !entry.isClosed()).map(Pool.Entry::getPooled).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.pool.close();
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        Dumpable.dumpObjects(appendable, string, this, new Object[0]);
    }

    @Override
    public boolean sweep() {
        this.pool.values().stream().map(Pool.Entry::getPooled).filter(connection -> connection instanceof Sweeper.Sweepable).forEach(connection -> {
            if (((Sweeper.Sweepable)((Object)connection)).sweep()) {
                boolean bl = this.remove((Connection)connection);
                LOG.warn("Connection swept: {}{}{} from active connections{}{}", connection, System.lineSeparator(), bl ? "Removed" : "Not removed", System.lineSeparator(), this.dump());
            }
        });
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s@%x[s=%s,c=%d/%d/%d,a=%d,i=%d,q=%d,p=%s]", this.getClass().getSimpleName(), this.hashCode(), this.getState(), this.getPendingConnectionCount(), this.getConnectionCount(), this.getMaxConnectionCount(), this.getActiveConnectionCount(), this.getIdleConnectionCount(), this.destination.getQueuedRequestCount(), this.pool);
    }

    private static class EntryHolder {
        private final Pool.Entry entry;
        private final long creationTimestamp = System.nanoTime();

        private EntryHolder(Pool.Entry entry) {
            this.entry = Objects.requireNonNull(entry);
        }

        private boolean isExpired(long l) {
            return System.nanoTime() - this.creationTimestamp >= l;
        }
    }

    private class FutureConnection
    extends Promise.Completable<Connection> {
        private final Pool.Entry reserved;

        public FutureConnection(Pool.Entry entry) {
            this.reserved = entry;
        }

        @Override
        public void succeeded(Connection connection) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connection creation succeeded {}: {}", this.reserved, connection);
            }
            if (connection instanceof Attachable) {
                ((Attachable)((Object)connection)).setAttachment(new EntryHolder(this.reserved));
                AbstractConnectionPool.this.onCreated(connection);
                AbstractConnectionPool.this.pending.decrementAndGet();
                this.reserved.enable(connection, false);
                AbstractConnectionPool.this.idle(connection, false);
                this.complete(null);
                AbstractConnectionPool.this.proceed();
            } else {
                this.failed(new IllegalArgumentException("Invalid connection object: " + connection));
            }
        }

        @Override
        public void failed(Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connection creation failed {}", this.reserved, throwable);
            }
            AbstractConnectionPool.this.pending.decrementAndGet();
            this.reserved.remove();
            this.completeExceptionally(throwable);
            AbstractConnectionPool.this.requester.failed(throwable);
        }
    }
}

